/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionContentProvider;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionViewer;
import org.eclipse.emf.eef.runtime.ui.widgets.EObjectFlatComboViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleCompositionViewer<T extends EObject>
extends Composite {
    EObjectFlatComboViewer comboViewer;
    private FormToolkit widgetFactory;
    private AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private PropertiesEditionViewer viewer;
    private Button setActiveEEFViewerCheckBox;
    private Label label;
    private Composite top;
    private ArrayList<EObject> instanciableObjectsInHierarchy;
    private int kind;
    private EditingDomain editingDomain;
    private String labelText;
    private boolean isRequired;
    private List<ISelectionChangedListener> comboListeners = new ArrayList<ISelectionChangedListener>();

    public SingleCompositionViewer(String label, Composite parent, int style, FormToolkit widgetFactory, int kind, boolean isRequired) {
        super(parent, style);
        this.layout(true);
        this.isRequired = isRequired;
        this.labelText = label;
        this.widgetFactory = widgetFactory;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.createTop(label);
        this.kind = kind;
    }

    private void createTop(String label) {
        this.top = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.top.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.top.setLayoutData((Object)data);
        this.createCheckBox(this.top);
        this.createLabel(label, this.top);
        this.createFlatComboViewer(this.top);
    }

    private void resetTopWithoutCheckBox() {
        this.top.dispose();
        this.setActiveEEFViewerCheckBox = null;
        this.top = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.top.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.top.setLayoutData((Object)data);
        this.createLabel(this.labelText, this.top);
        this.createFlatComboViewer(this.top);
        for (ISelectionChangedListener listener : this.comboListeners) {
            this.comboViewer.addSelectionChangedListener(listener);
        }
    }

    private void createLabel(String label, Composite top) {
        this.label = new Label(top, 0);
        if (this.isRequired) {
            this.label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        this.label.setText(label);
    }

    private void createCheckBox(Composite top) {
        this.setActiveEEFViewerCheckBox = new Button(top, 32);
    }

    private void createFlatComboViewer(Composite top) {
        this.comboViewer = new EObjectFlatComboViewer(top, false);
        this.comboViewer.setLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboViewer.setEnabled(true);
        GridData matchData = new GridData(768);
        this.comboViewer.setLayoutData(matchData);
        if (this.setActiveEEFViewerCheckBox != null) {
            this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SingleCompositionViewer.this.setActiveEEFViewerCheckBox.setSelection(true);
                }
            });
            this.setActiveEEFViewerCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (SingleCompositionViewer.this.getCheckBoxSelection()) {
                        SingleCompositionViewer.this.comboViewer.getSelectionAdapter(false).widgetSelected(e);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void createViewer(int kind) {
        GridData viewerStrategyData = new GridData(768);
        viewerStrategyData.horizontalSpan = 3;
        this.viewer = new PropertiesEditionViewer(this, null, 2048, kind);
        this.viewer.getControl().setLayoutData((Object)viewerStrategyData);
        if (this.widgetFactory != null) {
            this.viewer.setToolkit(this.widgetFactory);
        }
        this.viewer.setDynamicTabHeader(true);
    }

    public void update(EObject newValue) {
        if (newValue != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
        } else {
            this.clearComboViewer();
        }
        this.updateEEFViewer(newValue);
        this.refresh();
    }

    private void updateEEFViewer(EObject newValue) {
        if (this.viewer == null && this.hasFeatures(newValue)) {
            this.createViewer(this.kind);
            this.initViewer(this.editingDomain);
        }
        if (this.viewer != null) {
            this.viewer.setInput(newValue);
            if (!this.hasFeatures(newValue)) {
                this.viewer.getControl().dispose();
                this.viewer = null;
            } else {
                this.viewer.getControl().setVisible(true);
            }
        }
    }

    private void clearComboViewer() {
        this.comboViewer.selectedElement = null;
        this.comboViewer.initComponent();
    }

    public void setInput(EObject current, EReference feature, ResourceSet allResources) {
        List<EClass> instanciableTypesInHierarchy = EEFUtils.instanciableTypesInHierarchy(feature.getEType(), allResources);
        this.instanciableObjectsInHierarchy = new ArrayList();
        for (EClass eClass : instanciableTypesInHierarchy) {
            this.instanciableObjectsInHierarchy.add(EcoreUtil.create((EClass)eClass));
        }
        if (feature.getLowerBound() > 0) {
            this.resetTopWithoutCheckBox();
        }
        this.comboViewer.setInput(this.instanciableObjectsInHierarchy);
        if (this.instanciableObjectsInHierarchy.size() == 1) {
            this.comboViewer.setVisible(false);
        }
    }

    public EObject getElement() {
        Object firstElement;
        if (this.comboViewer.getSelection() instanceof StructuredSelection && (firstElement = ((StructuredSelection)this.comboViewer.getSelection()).getFirstElement()) instanceof EObject) {
            if (this.kind == 0 && this.viewer != null) {
                firstElement = this.viewer.getInput();
            }
            return (EObject)firstElement;
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.comboViewer.addSelectionChangedListener(listener);
        this.comboListeners.add(listener);
    }

    public void addCheckBoxSelectionListener(SelectionListener selectionListener) {
        if (this.setActiveEEFViewerCheckBox != null) {
            this.setActiveEEFViewerCheckBox.addSelectionListener(selectionListener);
        }
    }

    public void setLabelProvider(AdapterFactoryLabelProvider provider) {
        this.comboViewer.setLabelProvider((ILabelProvider)provider);
    }

    public void setSelection(StructuredSelection structuredSelection, EReference feature) {
        EObject selectedObject = (EObject)((EObject)structuredSelection.getFirstElement()).eGet((EStructuralFeature)feature);
        if (selectedObject != null) {
            StructuredSelection selection = new StructuredSelection((Object)selectedObject);
            this.comboViewer.setSelection((ISelection)selection);
            if (this.hasFeatures(selectedObject)) {
                if (this.viewer == null) {
                    this.createViewer(this.kind);
                }
                this.initViewer(this.editingDomain);
                this.viewer.setInput(selectedObject);
            }
            if (this.setActiveEEFViewerCheckBox != null) {
                this.setActiveEEFViewerCheckBox.setSelection(true);
            }
        }
        this.comboViewer.initComponent();
    }

    private void initViewer(EditingDomain editingDomain) {
        if (editingDomain != null) {
            this.viewer.setContentProvider((IContentProvider)new PropertiesEditionContentProvider(this.adapterFactory, "Live", editingDomain));
        } else {
            try {
                this.viewer.setContentProvider((IContentProvider)new PropertiesEditionContentProvider(this.adapterFactory, "Batch"));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public boolean getCheckBoxSelection() {
        return this.setActiveEEFViewerCheckBox.getSelection();
    }

    public void refresh() {
        this.reflow();
        this.layout();
    }

    public void setEnable(boolean value) {
        this.comboViewer.setEnabled(value);
        this.setActiveEEFViewerCheckBox.setEnabled(value);
    }

    private boolean hasFeatures(EObject eObject) {
        if (eObject != null) {
            return eObject.eClass().getEAllStructuralFeatures().size() > 0;
        }
        return false;
    }

    protected void reflow() {
        SingleCompositionViewer c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)c).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboViewer.setEnabled(enabled);
        this.setActiveEEFViewerCheckBox.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }
}

