/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal.serialization;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.efacet.core.internal.exception.SaveStructuralFeatureInstanceModelException;
import org.eclipse.emf.facet.efacet.core.internal.serialization.ILinkToExtendedEObjectReference;
import org.eclipse.emf.facet.efacet.core.internal.serialization.ILinkToExtendedEObjectReferenceAdapterFactory;
import org.eclipse.emf.facet.efacet.core.internal.serialization.LinkToExtendedEObjectReferenceAdapter;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.AbstractAttributeInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.AbstractReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.ExtendedEObjectReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.MultiValuedAttributeInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.MultiValuedContainmentReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.MultiValuedReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SerializationFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SingleValuedAttributeInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SingleValuedContainmentReferenceInstance;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.SingleValuedReferenceInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationManager {
    private final Resource structuralFeatureInstancesResource;

    public SerializationManager(Resource structuralFeatureInstancesResource) {
        this.structuralFeatureInstancesResource = structuralFeatureInstancesResource;
        if (structuralFeatureInstancesResource != null) {
            EList contents = structuralFeatureInstancesResource.getContents();
            for (EObject eObject : contents) {
                if (!(eObject instanceof ExtendedEObjectReference)) continue;
                ExtendedEObjectReference extendedEObjectReference = (ExtendedEObjectReference)eObject;
                LinkToExtendedEObjectReferenceAdapter adapter = (LinkToExtendedEObjectReferenceAdapter)ILinkToExtendedEObjectReferenceAdapterFactory.INSTANCE.adapt((Notifier)extendedEObjectReference.getExtendedEObject(), ILinkToExtendedEObjectReference.class);
                adapter.setExtendedEObjectReference(extendedEObjectReference);
            }
        }
    }

    private static MultiValuedContainmentReferenceInstance createMultiValuedContainmentReferenceInstance(EReference reference, List<EObject> values, ExtendedEObjectReference extendedEObjectReference) {
        MultiValuedContainmentReferenceInstance containmentReferenceInstance = SerializationFactory.eINSTANCE.createMultiValuedContainmentReferenceInstance();
        containmentReferenceInstance.setEReference(reference);
        if (values != null) {
            containmentReferenceInstance.getOwnedElements().addAll(values);
        }
        extendedEObjectReference.getReferenceInstances().add((Object)containmentReferenceInstance);
        return containmentReferenceInstance;
    }

    private static ExtendedEObjectReference getExtendedEObjectReference(EObject eObject) {
        ExtendedEObjectReference result = null;
        for (Adapter adapter : eObject.eAdapters()) {
            if (!adapter.isAdapterForType(ILinkToExtendedEObjectReference.class)) continue;
            LinkToExtendedEObjectReferenceAdapter linkToExtendedEObjectReferenceAdapter = (LinkToExtendedEObjectReferenceAdapter)adapter;
            result = linkToExtendedEObjectReferenceAdapter.getExtendedEObjectReference();
            break;
        }
        return result;
    }

    private static MultiValuedAttributeInstance createMultiValuedAttributeInstance(EAttribute attribute, List<Object> values, ExtendedEObjectReference extendedEObjectReference) {
        MultiValuedAttributeInstance attributeInstance = SerializationFactory.eINSTANCE.createMultiValuedAttributeInstance();
        attributeInstance.setEAttribute(attribute);
        if (values != null) {
            attributeInstance.getValues().addAll(values);
        }
        extendedEObjectReference.getAttributeInstances().add((Object)attributeInstance);
        return attributeInstance;
    }

    private static MultiValuedReferenceInstance createMultiValuedReferenceInstance(EReference reference, List<EObject> values, ExtendedEObjectReference extendedEObjectReference) {
        MultiValuedReferenceInstance referenceInstance = SerializationFactory.eINSTANCE.createMultiValuedReferenceInstance();
        referenceInstance.setEReference(reference);
        if (values != null) {
            referenceInstance.getReferencedElements().addAll(values);
        }
        extendedEObjectReference.getReferenceInstances().add((Object)referenceInstance);
        return referenceInstance;
    }

    private static SingleValuedAttributeInstance getSingleValuedAttributeInstance(ExtendedEObjectReference extendedEObjectReference, EAttribute eAttribute) {
        SingleValuedAttributeInstance result = null;
        EList attributeInstances = extendedEObjectReference.getAttributeInstances();
        for (AbstractAttributeInstance attributeInstance : attributeInstances) {
            if (!eAttribute.equals(attributeInstance.getEAttribute())) continue;
            if (attributeInstance instanceof SingleValuedAttributeInstance) {
                result = (SingleValuedAttributeInstance)attributeInstance;
                break;
            }
            throw new IllegalStateException("single valued attribute should be associated to an instance of SingleValuedAttributeInstance");
        }
        return result;
    }

    private static MultiValuedAttributeInstance getMultiValuedAttributeInstance(ExtendedEObjectReference extendedEObjectReference, EAttribute eAttribute) {
        MultiValuedAttributeInstance result = null;
        EList attributeInstances = extendedEObjectReference.getAttributeInstances();
        for (AbstractAttributeInstance attributeInstance : attributeInstances) {
            if (!eAttribute.equals(attributeInstance.getEAttribute())) continue;
            if (attributeInstance instanceof MultiValuedAttributeInstance) {
                result = (MultiValuedAttributeInstance)attributeInstance;
                break;
            }
            throw new IllegalStateException("multi valued attribute should be associated to an instance of MultiValuedAttributeInstance");
        }
        return result;
    }

    private static SingleValuedReferenceInstance getSingleValuedReferenceInstance(ExtendedEObjectReference extendedEObjectReference, EReference eReference) {
        SingleValuedReferenceInstance result = null;
        EList referenceInstances = extendedEObjectReference.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : referenceInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof SingleValuedReferenceInstance) {
                result = (SingleValuedReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a single valued non-containment reference should be associated to an instance of SingleValuedReferenceInstance");
        }
        return result;
    }

    private static SingleValuedContainmentReferenceInstance getSingleValuedContainmentReferenceInstance(ExtendedEObjectReference extendedEObjectReference, EReference eReference) {
        SingleValuedContainmentReferenceInstance result = null;
        EList referenceInstances = extendedEObjectReference.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : referenceInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof SingleValuedContainmentReferenceInstance) {
                result = (SingleValuedContainmentReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a single valued containment reference should be associated to an instance of SingleValuedContainmentReferenceInstance");
        }
        return result;
    }

    private static MultiValuedReferenceInstance getMultiValuedReferenceInstance(ExtendedEObjectReference extendedEObjectReference, EReference eReference) {
        MultiValuedReferenceInstance result = null;
        EList referenceInstances = extendedEObjectReference.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : referenceInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof MultiValuedReferenceInstance) {
                result = (MultiValuedReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a multi valued non-containment reference should be associated to an instance of MultiValuedReferenceInstance");
        }
        return result;
    }

    private static MultiValuedContainmentReferenceInstance getMultiValuedContainmentReferenceInstance(ExtendedEObjectReference extendedEObjectReference, EReference eReference) {
        MultiValuedContainmentReferenceInstance result = null;
        EList referenceInstances = extendedEObjectReference.getReferenceInstances();
        for (AbstractReferenceInstance referenceInstance : referenceInstances) {
            if (!eReference.equals(referenceInstance.getEReference())) continue;
            if (referenceInstance instanceof MultiValuedContainmentReferenceInstance) {
                result = (MultiValuedContainmentReferenceInstance)referenceInstance;
                break;
            }
            throw new IllegalStateException("a multi valued containment reference should be associated to an instance of MultiValuedContainmentReferenceInstance");
        }
        return result;
    }

    public void saveStructuralFeatureInstanceModel() throws SaveStructuralFeatureInstanceModelException {
        if (this.structuralFeatureInstancesResource == null) {
            throw new SaveStructuralFeatureInstanceModelException("This facet manager has been initailized with a null structural feature instances resource");
        }
        try {
            this.structuralFeatureInstancesResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new SaveStructuralFeatureInstanceModelException(e);
        }
    }

    private ExtendedEObjectReference getOrCreateExtendedEObjectReference(EObject eObject) {
        ExtendedEObjectReference extendedEObjectReference = SerializationManager.getExtendedEObjectReference(eObject);
        if (extendedEObjectReference == null) {
            extendedEObjectReference = SerializationFactory.eINSTANCE.createExtendedEObjectReference();
            extendedEObjectReference.setExtendedEObject(eObject);
            if (this.structuralFeatureInstancesResource != null) {
                this.structuralFeatureInstancesResource.getContents().add((Object)extendedEObjectReference);
            }
            LinkToExtendedEObjectReferenceAdapter adapter = (LinkToExtendedEObjectReferenceAdapter)ILinkToExtendedEObjectReferenceAdapterFactory.INSTANCE.adapt((Notifier)eObject, ILinkToExtendedEObjectReference.class);
            adapter.setExtendedEObjectReference(extendedEObjectReference);
        }
        return extendedEObjectReference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(EObject eObject, EAttribute attribute, Object newValue) {
        ExtendedEObjectReference extendedEObjectReference = this.getOrCreateExtendedEObjectReference(eObject);
        if (attribute.isMany()) {
            if (!(newValue instanceof List)) throw new IllegalArgumentException("The given FacetAttribute is multiplicity-many, so the value must be a List");
            List list = (List)newValue;
            MultiValuedAttributeInstance attributeInstance = SerializationManager.getMultiValuedAttributeInstance(extendedEObjectReference, attribute);
            if (attributeInstance == null) {
                SerializationManager.createMultiValuedAttributeInstance(attribute, list, extendedEObjectReference);
                return;
            } else {
                attributeInstance.getValues().clear();
                attributeInstance.getValues().addAll((Collection)list);
            }
            return;
        } else {
            SingleValuedAttributeInstance attributeInstance = SerializationManager.getSingleValuedAttributeInstance(extendedEObjectReference, attribute);
            if (attributeInstance == null) {
                SerializationManager.createSingleValuedAttributeInstance(attribute, newValue, extendedEObjectReference);
                return;
            } else {
                attributeInstance.setValue(newValue);
            }
        }
    }

    private static SingleValuedAttributeInstance createSingleValuedAttributeInstance(EAttribute attribute, Object value, ExtendedEObjectReference extendedEObjectReference) {
        SingleValuedAttributeInstance attributeInstance = SerializationFactory.eINSTANCE.createSingleValuedAttributeInstance();
        attributeInstance.setEAttribute(attribute);
        attributeInstance.setValue(value);
        extendedEObjectReference.getAttributeInstances().add((Object)attributeInstance);
        return attributeInstance;
    }

    private static SingleValuedReferenceInstance createSingleValuedReferenceInstance(EReference reference, EObject value, ExtendedEObjectReference extendedEObjectReference) {
        SingleValuedReferenceInstance referenceInstance = SerializationFactory.eINSTANCE.createSingleValuedReferenceInstance();
        referenceInstance.setEReference(reference);
        referenceInstance.setReferencedElement(value);
        extendedEObjectReference.getReferenceInstances().add((Object)referenceInstance);
        return referenceInstance;
    }

    public void setReference(EObject eObject, EReference reference, Object newValue) {
        ExtendedEObjectReference extendedEObjectReference = this.getOrCreateExtendedEObjectReference(eObject);
        if (reference.isMany()) {
            throw new UnsupportedOperationException("The given FacetReference is multi-valued : add elements to the list returned by getMultiValuedReference() instead");
        }
        if (!(newValue instanceof EObject)) {
            throw new IllegalArgumentException("newValue should be an EObject because eStructuralFeature is an EReference");
        }
        EObject newEObjectValue = (EObject)newValue;
        if (reference.isContainment()) {
            SingleValuedContainmentReferenceInstance referenceInstance = SerializationManager.getSingleValuedContainmentReferenceInstance(extendedEObjectReference, reference);
            if (referenceInstance == null) {
                SerializationManager.createSingleValuedContainmentReferenceInstance(reference, newEObjectValue, extendedEObjectReference);
            } else {
                referenceInstance.setOwnedElement(newEObjectValue);
            }
        } else {
            SingleValuedReferenceInstance referenceInstance = SerializationManager.getSingleValuedReferenceInstance(extendedEObjectReference, reference);
            if (referenceInstance == null) {
                SerializationManager.createSingleValuedReferenceInstance(reference, newEObjectValue, extendedEObjectReference);
            } else {
                referenceInstance.setReferencedElement(newEObjectValue);
            }
        }
    }

    private static SingleValuedContainmentReferenceInstance createSingleValuedContainmentReferenceInstance(EReference reference, EObject value, ExtendedEObjectReference extendedEObjectReference) {
        SingleValuedContainmentReferenceInstance containmentReferenceInstance = SerializationFactory.eINSTANCE.createSingleValuedContainmentReferenceInstance();
        containmentReferenceInstance.setEReference(reference);
        containmentReferenceInstance.setOwnedElement(value);
        extendedEObjectReference.getReferenceInstances().add((Object)containmentReferenceInstance);
        return containmentReferenceInstance;
    }

    private Object getMultiValuedStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        EList result = null;
        ExtendedEObjectReference extendedEObjectReference = this.getOrCreateExtendedEObjectReference(eObject);
        if (structuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)structuralFeature;
            MultiValuedAttributeInstance attributeInstance = SerializationManager.getMultiValuedAttributeInstance(extendedEObjectReference, eAttribute);
            if (attributeInstance != null) {
                result = attributeInstance.getValues();
            }
        } else if (structuralFeature instanceof EReference) {
            EReference eReference = (EReference)structuralFeature;
            if (eReference.isContainment()) {
                MultiValuedContainmentReferenceInstance referenceInstance = SerializationManager.getMultiValuedContainmentReferenceInstance(extendedEObjectReference, eReference);
                if (referenceInstance == null) {
                    referenceInstance = SerializationManager.createMultiValuedContainmentReferenceInstance(eReference, null, extendedEObjectReference);
                    result = referenceInstance.getOwnedElements();
                } else {
                    result = referenceInstance.getOwnedElements();
                }
            } else {
                MultiValuedReferenceInstance referenceInstance = SerializationManager.getMultiValuedReferenceInstance(extendedEObjectReference, eReference);
                if (referenceInstance == null) {
                    referenceInstance = SerializationManager.createMultiValuedReferenceInstance(eReference, null, extendedEObjectReference);
                    result = referenceInstance.getReferencedElements();
                } else {
                    result = referenceInstance.getReferencedElements();
                }
            }
        } else {
            throw new UnsupportedOperationException("Getting a structural feature of type '" + structuralFeature.getClass().getName() + "' is not implemented");
        }
        return result;
    }

    private static Object getSingleValuedStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        Object result = null;
        ExtendedEObjectReference extendedEObjectReference = SerializationManager.getExtendedEObjectReference(eObject);
        if (extendedEObjectReference != null) {
            if (structuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)structuralFeature;
                SingleValuedAttributeInstance attributeInstance = SerializationManager.getSingleValuedAttributeInstance(extendedEObjectReference, eAttribute);
                if (attributeInstance != null) {
                    result = attributeInstance.getValue();
                }
            } else if (structuralFeature instanceof EReference) {
                EReference eReference = (EReference)structuralFeature;
                if (eReference.isContainment()) {
                    SingleValuedContainmentReferenceInstance referenceInstance = SerializationManager.getSingleValuedContainmentReferenceInstance(extendedEObjectReference, eReference);
                    result = referenceInstance.getOwnedElement();
                } else {
                    SingleValuedReferenceInstance referenceInstance = SerializationManager.getSingleValuedReferenceInstance(extendedEObjectReference, eReference);
                    result = referenceInstance.getReferencedElement();
                }
            } else {
                throw new IllegalArgumentException("Unexpected structuralFeature kind");
            }
        }
        return result;
    }

    public Object getNotDerivedValue(EObject eObject, EStructuralFeature structuralFeature) {
        Object result = structuralFeature.isMany() ? this.getMultiValuedStructuralFeature(eObject, structuralFeature) : SerializationManager.getSingleValuedStructuralFeature(eObject, structuralFeature);
        return result;
    }
}

