/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.sdk.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.efacet.core.IFacetActions;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.Activator;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.WorkbenchUtils;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.exported.wizard.page.ICreateFacetSetWizardPage;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.exported.wizard.page.IFacetSetPropertyWizardPage;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.wizard.page.CreateFacetSetWizardPage;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.wizard.page.FacetSetPropertyWizardPage;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.wizard.page.SynchronizedCreateFacetSetWizardPage;
import org.eclipse.emf.facet.efacet.sdk.ui.internal.wizard.page.SynchronizedFacetSetPropertyWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.util.wizard.page.SynchronizedWizardPage;
import org.eclipse.emf.facet.util.ui.internal.exported.wizard.IExtendedWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateFacetSetWizard
extends Wizard
implements INewWizard,
IExtendedWizard {
    private WizardDialog dialog;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private final ICreateFacetSetWizardPage facetSetWizard;
    private final IFacetSetPropertyWizardPage propertyWizard;
    private boolean openFacetSet = true;

    public CreateFacetSetWizard() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection());
    }

    public CreateFacetSetWizard(ISelection selection, boolean openFacetSet) {
        this(selection);
        this.openFacetSet = openFacetSet;
    }

    public CreateFacetSetWizard(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
        this.setWindowTitle(Messages.Create_FacetSet_Model);
        this.facetSetWizard = new CreateFacetSetWizardPage("Whatever", this.selection);
        this.propertyWizard = new FacetSetPropertyWizardPage("Whatever");
    }

    public void addPages() {
        this.addPage(this.facetSetWizard);
        this.addPage(this.propertyWizard);
    }

    public int open() {
        this.dialog = new WizardDialog(Display.getDefault().getShells()[0], (IWizard)this);
        int result = 1;
        if (this.dialog != null) {
            result = this.dialog.open();
        }
        return result;
    }

    public boolean performFinish() {
        boolean result = false;
        if (this.propertyWizard.isPageComplete()) {
            try {
                IFile modelFile = this.getModelFile();
                WorkspaceModifyOperation operation = this.createOperation(modelFile);
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                if (this.openFacetSet) {
                    IWorkbenchWindow workbenchWindow = this.selectWorkbenchWindow();
                    IWorkbenchPage page = WorkbenchUtils.selectNewFile(modelFile, workbenchWindow);
                    WorkbenchUtils.openNewFile(modelFile, this.workbench, workbenchWindow, page);
                }
                result = true;
            }
            catch (Exception exception) {
                Logger.logError((Throwable)exception, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    protected IWorkbenchWindow selectWorkbenchWindow() {
        if (this.workbench == null) {
            this.workbench = PlatformUI.getWorkbench();
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        return workbenchWindow;
    }

    protected WorkspaceModifyOperation createOperation(final IFile modelFile) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        FacetSet facetSet = CreateFacetSetWizard.this.createInitialFacet();
                        IFacetActions.INSTANCE.saveFacetSet(facetSet, modelFile);
                    }
                    catch (Exception exception) {
                        Logger.logError((Throwable)exception, (Plugin)Activator.getDefault());
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        return operation;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.propertyWizard && this.propertyWizard.isPageComplete();
    }

    public void init(IWorkbench newWorkbench, IStructuredSelection newSelection) {
        this.workbench = newWorkbench;
        this.selection = newSelection;
    }

    protected FacetSet createInitialFacet() {
        FacetSet facetSet = EFacetPackage.eINSTANCE.getEFacetFactory().createFacetSet();
        String modelFacetSetName = this.getModelFile().getName().replaceAll(".efacet", "");
        facetSet.setName(modelFacetSetName);
        facetSet.setNsURI(this.propertyWizard.getNsUri());
        facetSet.setNsPrefix(this.propertyWizard.getPrefix());
        return facetSet;
    }

    public IFile getModelFile() {
        return this.facetSetWizard.getModelFile();
    }

    public IFacetSetPropertyWizardPage getPropertyWizard() {
        return this.propertyWizard;
    }

    public IWizardPage next() {
        IWizardPage nextPage = this.getNextPage(this.getContainer().getCurrentPage());
        this.dialog.showPage(nextPage);
        return CreateFacetSetWizard.getSynchronizedPage(nextPage);
    }

    public IWizardPage previous() {
        IWizardPage previousPage = this.getPreviousPage(this.getContainer().getCurrentPage());
        this.dialog.showPage(previousPage);
        return CreateFacetSetWizard.getSynchronizedPage(previousPage);
    }

    public boolean finish() {
        boolean result = this.performFinish();
        this.dispose();
        this.setContainer(null);
        this.getDialog().close();
        return result;
    }

    public ICreateFacetSetWizardPage getFacetSetWizard() {
        return this.facetSetWizard;
    }

    public WizardDialog getDialog() {
        return this.dialog;
    }

    public IWizardPage getCurrentPage() {
        return CreateFacetSetWizard.getSynchronizedPage(this.getContainer().getCurrentPage());
    }

    private static IWizardPage getSynchronizedPage(IWizardPage page) {
        SynchronizedWizardPage result = null;
        if (page instanceof ICreateFacetSetWizardPage) {
            result = new SynchronizedCreateFacetSetWizardPage((ICreateFacetSetWizardPage)page, Display.getDefault());
        } else if (page instanceof IFacetSetPropertyWizardPage) {
            result = new SynchronizedFacetSetPropertyWizardPage((IFacetSetPropertyWizardPage)page, Display.getDefault());
        }
        return result;
    }
}

