/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.validation.constraints;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;

public class MetamodelValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext context) {
        EObject eObject = context.getTarget();
        EMFEventType eType = context.getEventType();
        if (eType == EMFEventType.NULL && eObject instanceof MetamodelView) {
            MetamodelView metamodelView = (MetamodelView)eObject;
            String metamodelURI = metamodelView.getMetamodelURI();
            if (metamodelURI == null) {
                return context.createFailureStatus(new Object[]{"null"});
            }
            EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get((Object)metamodelURI);
            if (ePackage == null) {
                Collection allFacetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                for (FacetSet facetSet : allFacetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    return context.createSuccessStatus();
                }
                return context.createFailureStatus(new Object[]{metamodelURI});
            }
        }
        return context.createSuccessStatus();
    }
}

