/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 340122 - No epackage browser opener is registered
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.opener;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.IEPackageBrowserOpener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DefaultEMFFacetEPackageBrowser implements IEPackageBrowserOpener {

	public void openEPackage(final EPackage ePackage) {
		try {
			final IEditorInput input = new URIEditorInput(URI.createURI(ePackage.getNsURI()));
			IDE.openEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(),
					input, EcoreBrowser.EDITOR_ID, true);
		} catch (final Exception e) {
			Logger.logError(e, BrowserPlugin.getPlugin());
		}
	}

	public String getBrowserName() {
		// TODO : to be externalized
		return "Default EMF Facet EPackage Browser"; //$NON-NLS-1$
	}

}
