/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.uicore.internal.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.uicore.extensions.naming.FilteredNameProvider;
import org.eclipse.emf.facet.infra.browser.uicore.extensions.naming.NameProvider;
import org.eclipse.emf.facet.infra.browser.uicore.internal.Activator;
import org.eclipse.emf.facet.infra.browser.uicore.internal.Messages;
import org.eclipse.emf.facet.infra.common.core.internal.extensions.AbstractRegistry;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.emf.facet.util.core.Logger;

public class NameProvidersRegistry
extends AbstractRegistry {
    private static final String METACLASS_ELEMENT = "metaclass";
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.emf.facet.infra.browser.uicore";
    private static final String EXTENSION_POINT_NAME = "naming";
    private static final String METAMODEL_ID_ATTRIBUTE = "id";
    private static final String METAMODEL_ELEMENT = "metamodel";
    private static final String NAME_PROVIDER_ELEMENT = "nameProvider";
    private static final String NAME_PROVIDER_CLASS = "class";
    private static final String FILTER_ELEMENT = "filter";
    private static final String METACLASS_NAME_ATTRIBUTE = "name";
    private static NameProvidersRegistry instance = null;
    private final Map<String, List<FilteredNameProvider>> nameProviders = new HashMap<String, List<FilteredNameProvider>>();

    public static NameProvidersRegistry getInstance() {
        if (instance == null) {
            instance = new NameProvidersRegistry();
        }
        return instance;
    }

    public NameProvidersRegistry() {
        this.initialize();
    }

    public String getName(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            return null;
        }
        String metaclassQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            return null;
        }
        String nsURI = ePackage.getNsURI();
        List<FilteredNameProvider> filteredNameProviders = this.nameProviders.get(nsURI);
        if (filteredNameProviders == null && (filteredNameProviders = this.nameProviders.get("*")) == null) {
            return null;
        }
        for (FilteredNameProvider filteredNameProvider : filteredNameProviders) {
            String name;
            if (!filteredNameProvider.filter(metaclassQualifiedName) || (name = filteredNameProvider.getName(eObject)) == null) continue;
            return name;
        }
        return null;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(METAMODEL_ELEMENT)) {
            this.readMetamodelElement(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readMetamodelElement(IConfigurationElement configurationElement) {
        IConfigurationElement[] children;
        String metamodelId = configurationElement.getAttribute(METAMODEL_ID_ATTRIBUTE);
        if (metamodelId == null) {
            this.logMissingAttribute(configurationElement, METAMODEL_ID_ATTRIBUTE);
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName();
            if (name.equalsIgnoreCase(NAME_PROVIDER_ELEMENT)) {
                this.readNameProviderElement(child, metamodelId);
            } else {
                this.logUnknownElement(configurationElement);
            }
            ++n2;
        }
    }

    private void readNameProviderElement(IConfigurationElement configurationElement, String metamodelId) {
        Object nameProviderObject;
        HashSet<String> filteredMetaclasses = null;
        IConfigurationElement[] filterElements = configurationElement.getChildren(FILTER_ELEMENT);
        if (filterElements.length > 0) {
            IConfigurationElement[] metaclassElements;
            IConfigurationElement[] iConfigurationElementArray = metaclassElements = filterElements[0].getChildren(METACLASS_ELEMENT);
            int n = metaclassElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement metaclassElement = iConfigurationElementArray[n2];
                String metaclassName = metaclassElement.getAttribute(METACLASS_NAME_ATTRIBUTE);
                if (metaclassName != null) {
                    if (filteredMetaclasses == null) {
                        filteredMetaclasses = new HashSet<String>();
                    }
                    filteredMetaclasses.add(metaclassName);
                }
                ++n2;
            }
        }
        final HashSet<String> fFilteredMetaclasses = filteredMetaclasses;
        try {
            nameProviderObject = configurationElement.createExecutableExtension(NAME_PROVIDER_CLASS);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return;
        }
        if (nameProviderObject == null) {
            this.logMissingAttribute(configurationElement, NAME_PROVIDER_CLASS);
            return;
        }
        List<FilteredNameProvider> filteredNameProviders = this.nameProviders.get(metamodelId);
        if (filteredNameProviders == null) {
            filteredNameProviders = new ArrayList<FilteredNameProvider>();
        }
        if (nameProviderObject instanceof FilteredNameProvider) {
            final FilteredNameProvider filteredNameProvider = (FilteredNameProvider)nameProviderObject;
            filteredNameProviders.add(new FilteredNameProvider(){

                public String getName(EObject eObject) {
                    return filteredNameProvider.getName(eObject);
                }

                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses != null && !fFilteredMetaclasses.contains(metaclass)) {
                        return false;
                    }
                    return filteredNameProvider.filter(metaclass);
                }
            });
        } else if (nameProviderObject instanceof NameProvider) {
            final NameProvider nameProvider = (NameProvider)nameProviderObject;
            FilteredNameProvider filteredNameProvider = new FilteredNameProvider(){

                public String getName(EObject eObject) {
                    return nameProvider.getName(eObject);
                }

                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses == null) {
                        return true;
                    }
                    return fFilteredMetaclasses.contains(metaclass);
                }
            };
            filteredNameProviders.add(filteredNameProvider);
        } else {
            this.logError(configurationElement, Messages.NameProvidersRegistry_notANameProvider);
        }
        this.nameProviders.put(metamodelId, filteredNameProviders);
    }
}

