/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.emf.facet.infra.common.ui.internal.Messages;
import org.eclipse.emf.facet.infra.common.ui.internal.util.ImageProvider;
import org.eclipse.emf.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class GetEmfFacetResourceDialog
extends ElementTreeSelectionDialog {
    protected static final String CATALOG_ICON_URL = "/icons/catalog.png";

    public GetEmfFacetResourceDialog(Shell parent) {
        super(parent, GetEmfFacetResourceDialog.createLabelProvider(), GetEmfFacetResourceDialog.createContentProvider());
        this.setInput(AbstractEmfFacetCatalog.getCatalogs());
        this.setTitle(Messages.GetEmfFacetResourceDialog_loadEmfFacetResource);
    }

    private static ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AbstractEmfFacetCatalog) {
                    AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog)parentElement;
                    return catalog.getAllRootObjects().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof List) {
                    List objectList = (List)element;
                    ArrayList<AbstractEmfFacetCatalog> catalogList = new ArrayList<AbstractEmfFacetCatalog>();
                    for (Object object : objectList) {
                        if (!(object instanceof AbstractEmfFacetCatalog)) continue;
                        AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog)object;
                        catalogList.add(catalog);
                    }
                    return catalogList.size() > 0;
                }
                if (element instanceof AbstractEmfFacetCatalog) {
                    AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog)element;
                    return catalog.getAllRootObjects().size() > 0;
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return AbstractEmfFacetCatalog.getCatalogs().toArray();
                }
                if (inputElement instanceof List) {
                    List objectList = (List)inputElement;
                    ArrayList<AbstractEmfFacetCatalog> catalogList = new ArrayList<AbstractEmfFacetCatalog>();
                    for (Object object : objectList) {
                        if (!(object instanceof AbstractEmfFacetCatalog) || object instanceof EcoreCatalog) continue;
                        AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog)object;
                        catalogList.add(catalog);
                    }
                    return catalogList.toArray(new AbstractEmfFacetCatalog[catalogList.size()]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private static ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                if (element instanceof AbstractEmfFacetCatalog) {
                    return true;
                }
                return element instanceof EObject;
            }

            public String getText(Object element) {
                if (element instanceof AbstractEmfFacetCatalog) {
                    AbstractEmfFacetCatalog catalog = (AbstractEmfFacetCatalog)element;
                    return catalog.getClass().getSimpleName();
                }
                if (element instanceof EObject) {
                    EObject eObject = (EObject)element;
                    for (EAttribute eAttribute : eObject.eClass().getEAttributes()) {
                        if (!eAttribute.getName().equals("name")) continue;
                        return eObject.eGet((EStructuralFeature)eAttribute).toString();
                    }
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof AbstractEmfFacetCatalog) {
                    return ImageProvider.getInstance().getCatalogIcon();
                }
                return ImageUtils.getImage((Object)element);
            }
        };
    }
}

