/**
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 *     Nicolas BROS (Mia-Software)
 */
package org.eclipse.emf.facet.infra.query.core.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.EmfFacetCatalogBuilder;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;

public class QueryBuilder extends EmfFacetCatalogBuilder {

	protected static final String FILE_EXTENSION = "querySet"; //$NON-NLS-1$
	private static final String MARKER_TYPE = "org.eclipse.emf.facet.infra.query.problem"; //$NON-NLS-1$

	@Override
	protected AbstractEmfFacetCatalog getCatalog() {
		return ModelQuerySetCatalog.getSingleton();
	}

	@Override
	protected String getElementType() {
		return Messages.QueryBuilder_querySet;
	}

	@Override
	protected String getRegistrationExtensionPoint() {
		return ModelQuerySetCatalog.REGISTRATION_EXTENSION_POINT_ID;
	}

	@Override
	protected String getMarkerType() {
		return QueryBuilder.MARKER_TYPE;
	}

	@Override
	protected String getFileExtension() {
		return QueryBuilder.FILE_EXTENSION;
	}

	@Override
	protected Plugin getActivator() {
		return Activator.getDefault();
	}

}
