/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.java.ui.internal.wizard.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.ui.internal.composites.BrowseComposite;
import org.eclipse.emf.facet.efacet.ui.internal.exported.wizard.IQueryCreationPagePart;
import org.eclipse.emf.facet.query.java.javaquery.JavaQuery;
import org.eclipse.emf.facet.query.java.javaquery.JavaqueryFactory;
import org.eclipse.emf.facet.query.java.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.ui.internal.Messages;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.SelectOrCreateJavaClassWizard;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JavaQueryWizardPagePart
implements IQueryCreationPagePart {
    private static final String I_JAVA_QUERY = "IJavaQuery";
    private FacetSet facetSet;
    private String queryName;
    private String implementationClassName;
    private int lowerBound;
    private int upperBound;
    private boolean canBeCached;
    private boolean hasSideEffect;
    private EClassifier queryType;
    private EClass scope;
    private boolean fOrdered = false;
    private boolean fUnique = false;
    private SelectOrCreateJavaClassWizard wizardClassCreationWizard;
    private String errorMessage;
    private List<ModifyListener> listeners = new ArrayList<ModifyListener>();

    public Query performFinish() {
        if (this.wizardClassCreationWizard != null) {
            this.wizardClassCreationWizard.setUpperBound(this.upperBound);
            this.wizardClassCreationWizard.setEType(this.queryType);
            this.wizardClassCreationWizard.setScope((EClassifier)this.scope);
            this.wizardClassCreationWizard.createJavaClass();
        }
        JavaQuery query = JavaqueryFactory.eINSTANCE.createJavaQuery();
        query.setName(this.queryName);
        query.setImplementationClassName(this.implementationClassName);
        query.setLowerBound(this.lowerBound);
        query.setUpperBound(this.upperBound);
        query.setCanBeCached(this.canBeCached);
        query.setHasSideEffect(this.hasSideEffect);
        query.setEType(this.queryType);
        query.setScope(this.scope);
        query.setUnique(this.fUnique);
        query.setOrdered(this.fOrdered);
        return query;
    }

    public void completeComposite(final Composite parent) {
        Label javaClassLabel = new Label(parent, 0);
        javaClassLabel.setText(Messages.JavaQueryWizardPage_Java_Class_Name);
        BrowseComposite browseCompositeForJavaClass = new BrowseComposite(parent, 2048){

            protected void handleBrowse() {
                if (JavaQueryWizardPagePart.this.handleCreateQueryClass()) {
                    this.updateTextFieldContent(JavaQueryWizardPagePart.this.getImplementationClassName());
                    JavaQueryWizardPagePart.this.notifyCompositeListeners(parent);
                }
            }
        };
        if (this.implementationClassName != null) {
            browseCompositeForJavaClass.updateTextFieldContent(this.implementationClassName);
        }
        Label dummyLabel2 = new Label(parent, 0);
        dummyLabel2.setText(new String());
    }

    protected boolean handleCreateQueryClass() {
        block4: {
            try {
                this.wizardClassCreationWizard = new SelectOrCreateJavaClassWizard(this.facetSet, this.queryName, false);
                this.wizardClassCreationWizard.setEType(this.queryType);
                if (this.wizardClassCreationWizard.open() == 1) break block4;
                if (this.wizardClassCreationWizard.isSelectExistingJavaClass()) {
                    return this.handleSelectImplClass();
                }
                this.updateImplClassName(this.wizardClassCreationWizard.getImplementationClassName());
                this.errorMessage = null;
                return true;
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                return false;
            }
        }
        this.wizardClassCreationWizard = null;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleSelectImplClass() {
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            String interfaceName;
            Object test;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
            dialog.open();
            if (dialog.getReturnCode() == 1 || !((test = dialog.getResult()[0]) instanceof IType)) return false;
            IType sourceType = (IType)test;
            String[] superInterfaceName = sourceType.getSuperInterfaceNames();
            List<String> list = Arrays.asList(superInterfaceName);
            Iterator<String> iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                this.updateImplClassName("");
                return false;
            } while (!(interfaceName = iterator.next()).startsWith(I_JAVA_QUERY));
            this.updateImplClassName(sourceType.getFullyQualifiedName());
            this.wizardClassCreationWizard = null;
            return true;
        }
        catch (JavaModelException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return false;
    }

    public boolean isCompositeComplete() {
        if (this.implementationClassName == null || this.implementationClassName.length() == 0) {
            this.errorMessage = Messages.JavaQueryWizardPage_Please_select_create_IJavaQuery_Class;
            return false;
        }
        this.errorMessage = null;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void updateImplClassName(String fullyQualifiedName) {
        this.implementationClassName = fullyQualifiedName;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setQueryType(EClassifier queryType) {
        this.queryType = queryType;
    }

    public void setCanBeCached(boolean canBeCached) {
        this.canBeCached = canBeCached;
    }

    public void setHasSideEffect(boolean hasSideEffect) {
        this.hasSideEffect = hasSideEffect;
    }

    public void setFacetSet(FacetSet facetSet) {
        this.facetSet = facetSet;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    protected String getImplementationClassName() {
        return this.implementationClassName;
    }

    public void addModifyListener(ModifyListener listener) {
        this.listeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyCompositeListeners(Composite modifiedComposite) {
        for (ModifyListener listener : this.listeners) {
            Event e = new Event();
            e.widget = modifiedComposite;
            listener.modifyText(new ModifyEvent(e));
        }
    }

    public void setQueryScope(EClass type) {
        this.scope = type;
    }

    public void setOrdered(boolean fOrdered2) {
        this.fOrdered = fOrdered2;
    }

    public void setUnique(boolean fUnique2) {
        this.fUnique = fUnique2;
    }
}

