/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.event.StructuralRefreshEvent;
import net.sourceforge.nattable.sort.ISortModel;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import net.sourceforge.nattable.sort.SortHeaderLayer;

import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget.BodyLayerStack;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class ColumnHeaderLayerStack extends AbstractLayerTransform {

	private final DataLayer dataLayer;

	public ColumnHeaderLayerStack(final IDataProvider dataProvider, final BodyLayerStack bodyLayer,
			final BodyDataProvider bodyDataProvider) {
		this.dataLayer = new DataLayer(dataProvider);
		ColumnHeaderLayer colHeaderLayer = new ColumnHeaderLayer(this.dataLayer, bodyLayer,
				bodyLayer.getSelectionLayer());

		ISortModel sortModel = new ISortModel() {
			private int sortedColumn = -1;
			private SortDirectionEnum fSortDirection = SortDirectionEnum.NONE;

			public void sort(final int columnIndex, final SortDirectionEnum sortDirection,
					final boolean accumulate) {
				this.sortedColumn = columnIndex;
				this.fSortDirection = sortDirection;

				bodyDataProvider.sort(columnIndex, sortDirection);
				bodyLayer.fireLayerEvent(new StructuralRefreshEvent(bodyLayer.getBodyDataLayer()));
			}

			public boolean isColumnIndexSorted(final int columnIndex) {
				return columnIndex == this.sortedColumn
						&& this.fSortDirection != SortDirectionEnum.NONE;
			}

			public int getSortOrder(final int columnIndex) {
				return 0;
			}

			public SortDirectionEnum getSortDirection(final int columnIndex) {
				if (columnIndex == this.sortedColumn) {
					return this.fSortDirection;
				}
				return SortDirectionEnum.NONE;
			}

			public void clear() {
				this.sortedColumn = -1;
				this.fSortDirection = SortDirectionEnum.NONE;
			}
		};

		SortHeaderLayer<ISortModel> sortHeaderLayer = new SortHeaderLayer<ISortModel>(
				colHeaderLayer, sortModel, true);

		setUnderlyingLayer(sortHeaderLayer);
	}

	public DataLayer getDataLayer() {
		return this.dataLayer;
	}
}