/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.UnresolvedProxyException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalTableUtils {
    private InternalTableUtils() {
    }

    public static List<Row> findUselessRow(Table tableInstance) {
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        for (Row row : tableInstance.getRows()) {
            if (row.getElement() != null && row.getElement().eResource() != null) continue;
            rowsToRemove.add(row);
        }
        return rowsToRemove;
    }

    public static Set<ETypedElement> getAllETypedElement(Table table, List<Row> rowsToKeep, List<? extends FacetSet> nextLoadedFacets) {
        HashSet<ETypedElement> eTypedElements = new HashSet<ETypedElement>();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)new ResourceSetImpl());
        if (nextLoadedFacets == null) {
            facetManager.getManagedFacetSets().addAll(table.getFacetSets());
        } else {
            facetManager.getManagedFacetSets().addAll(nextLoadedFacets);
        }
        for (Row row : rowsToKeep) {
            EClass eClass = row.getElement().eClass();
            eTypedElements.addAll((Collection<ETypedElement>)eClass.getEAllStructuralFeatures());
            eTypedElements.addAll((Collection<ETypedElement>)eClass.getEAllOperations());
            try {
                Set facetTEs = FacetUtils.getETypedElements((EObject)row.getElement(), ETypedElement.class, (IFacetManager)facetManager);
                eTypedElements.addAll(facetTEs);
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (String)("An exception has occured while retrieving structural features of:" + row.getElement()), (Plugin)Activator.getDefault());
            }
        }
        return eTypedElements;
    }

    public static List<FeatureColumn> columnsToRemove(Table table, List<? extends FacetSet> newFacetSets, List<Row> rowsToKeep) {
        LinkedList<FeatureColumn> result = new LinkedList<FeatureColumn>();
        if (rowsToKeep.isEmpty()) {
            for (Column column : table.getColumns()) {
                if (!(column instanceof FeatureColumn)) continue;
                FeatureColumn featureColumn = (FeatureColumn)column;
                InternalTableUtils.addToListNotDefault(featureColumn, result, table);
            }
        } else {
            ArrayList<ETypedElement> eTypedElements = new ArrayList<ETypedElement>(InternalTableUtils.getAllETypedElement(table, rowsToKeep, newFacetSets));
            for (Column column : table.getColumns()) {
                if (!(column instanceof FeatureColumn)) continue;
                FeatureColumn featureColumn = (FeatureColumn)column;
                ETypedElement eTypedElement = featureColumn.getFeature();
                if ((eTypedElement = (ETypedElement)EcoreUtil.resolve((EObject)eTypedElement, (EObject)table)).eIsProxy()) {
                    throw new UnresolvedProxyException("The current structural feature should have been resolved. " + EcoreUtil.getURI((EObject)eTypedElement));
                }
                ETypedElement resolvedTE = (ETypedElement)IResolverManager.DEFAULT.resolve((Object)eTypedElement, ETypedElement.class);
                if (resolvedTE != null) {
                    eTypedElement = resolvedTE;
                }
                if (eTypedElements.contains(eTypedElement)) continue;
                InternalTableUtils.addToListNotDefault(featureColumn, result, table);
            }
        }
        return result;
    }

    private static void addToListNotDefault(FeatureColumn featureColumn, List<FeatureColumn> list, Table table) {
        TableConfiguration tableConfig = table.getTableConfiguration();
        if (tableConfig == null || !tableConfig.getDefaultColumns().contains((Object)featureColumn.getFeature())) {
            list.add(featureColumn);
        }
    }

    public static boolean isColumnAlreadyDeclared(Table table, EStructuralFeature structuralFeature) {
        boolean result = false;
        for (Column column : table.getColumns()) {
            FeatureColumn featureColumn;
            if (!(column instanceof FeatureColumn) || (featureColumn = (FeatureColumn)column).getFeature() != structuralFeature) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Set<EStructuralFeature> getAllStructuralFeatures(Table table) {
        ResourceSet resourceSet = ModelUtils.getOrCreateResourceSet((EObject)table);
        IFacetManager facetMgr = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(resourceSet);
        facetMgr.getManagedFacetSets().addAll(0, table.getFacetSets());
        LinkedHashSet<EStructuralFeature> structFeatures = new LinkedHashSet<EStructuralFeature>();
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (EObject eObject : InternalTableUtils.getElements(table)) {
            try {
                structFeatures.addAll((Collection<EStructuralFeature>)eObject.eClass().getEAllStructuralFeatures());
                Set typedElements = FacetUtils.getETypedElements((EObject)eObject, EStructuralFeature.class, (IFacetManager)facetMgr);
                structFeatures.addAll(typedElements);
            }
            catch (Exception e) {
                Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "An exception has occurred while retrieving structural features of:" + eObject, (Throwable)e);
                statusList.add(status);
            }
        }
        if (!statusList.isEmpty()) {
            MultiStatus globalStatus = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 0, "An exception has occurred while retrieving structural features of the eObjects", (Throwable)new Exception());
            Logger.logError((Throwable)new CoreException((IStatus)globalStatus), (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TableUtils_FailToLoadFacetsShortMsg, (String)Messages.TableUtils_FailToLoadFacetsLongMsg);
        }
        return structFeatures;
    }

    public static List<EObject> getElements(Table table) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (Row row : table.getRows()) {
            result.add(row.getElement());
        }
        return result;
    }

    public static boolean hasStructuralFeature(EObject eObject, ETypedElement structuralFeature, IFacetManager context) throws FacetManagerException {
        DerivedTypedElement derivedTypedElt;
        EObject eContainer;
        boolean result = false;
        EClass eClass = eObject.eClass();
        if (eClass.getEAllStructuralFeatures().contains((Object)structuralFeature)) {
            result = true;
        } else if (structuralFeature instanceof DerivedTypedElement && (eContainer = (derivedTypedElt = (DerivedTypedElement)structuralFeature).eContainer()) instanceof Facet) {
            Facet facet = (Facet)eContainer;
            result = context.isConforming(eObject, facet);
        }
        return result;
    }
}

