/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactoryFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.FalseLiteralQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.IsOneOfQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryPackage;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResult;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.InternalTableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableWidgetController;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableInstanceCommandFactory {
    protected static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());

    public static Command createDeleteSelectedElementsCommand(TableWidgetController natTableWidget, ICommandFactory commandFactory) throws CoreException {
        HashSet<EObject> toDelete = new HashSet<EObject>();
        List<Object> rawSelection = natTableWidget.getRawSelection();
        for (Object selectedElement : rawSelection) {
            if (!(selectedElement instanceof IGridElement)) continue;
            IGridElement gridElement = (IGridElement)selectedElement;
            try {
                Object value = TableWidgetUtils.getValueOf(gridElement, natTableWidget.getFacetContext());
                if (!(value instanceof EObject)) continue;
                EObject eObject = (EObject)value;
                toDelete.add(eObject);
            }
            catch (FacetManagerException facetManagerException) {
                Logger.logError((String)"Error getting the value of a grid element to delete", (Plugin)Activator.getDefault());
            }
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        for (EObject eObjectToDelete : toDelete) {
            Command deleteCommand = commandFactory.createDeleteCommand(natTableWidget.getEditingDomain(), (Object)eObjectToDelete);
            compoundCommand.append(deleteCommand);
        }
        DebugUtils.debug((boolean)DEBUG, (String)("compoundCommand.canExecute()=" + compoundCommand.canExecute()));
        return compoundCommand;
    }

    public static Command createShowHideColumnCommand(TableWidgetController widgetController, List<Column> columnsToShow, List<Column> columnsToHide, boolean putOnTheTop) {
        Command cmd;
        CompoundCommand compoundCommand = new CompoundCommand("Show/hide column");
        EditingDomain editingDomain = widgetController.getEditingDomain();
        ICommandFactory commandFactory = widgetController.getCommandFactory();
        for (Column current : columnsToShow) {
            if (!(current instanceof SourceColumn) || !(cmd = commandFactory.createSetCommand(editingDomain, (Object)current, (Object)TablePackage.eINSTANCE.getSourceColumn_IsHidden(), (Object)Boolean.FALSE)).canExecute()) continue;
            compoundCommand.append(cmd);
        }
        HashSet<FeatureColumn> fColumnsToHide = new HashSet<FeatureColumn>();
        cmd = columnsToHide.iterator();
        while (cmd.hasNext()) {
            Column current = cmd.next();
            if (current instanceof FeatureColumn) {
                fColumnsToHide.add((FeatureColumn)current);
                continue;
            }
            Command cmd2 = commandFactory.createSetCommand(widgetController.getEditingDomain(), (Object)current, (Object)TablePackage.eINSTANCE.getSourceColumn_IsHidden(), (Object)Boolean.TRUE);
            compoundCommand.append(cmd2);
        }
        Command tmp = TableInstanceCommandFactory.createHideColumnCommand(widgetController, fColumnsToHide);
        if (tmp != null) {
            compoundCommand.append(tmp);
        }
        if (putOnTheTop && (cmd = TableInstanceCommandFactory.createPutLocalCustomizationOnTheTopCommand(widgetController)).canExecute()) {
            compoundCommand.append(cmd);
        }
        return compoundCommand;
    }

    public static Command createPutLocalCustomizationOnTheTopCommand(TableWidgetController natTableWidget) {
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        List<Customization> localCustoms = natTableWidget.getLocalCustomizations();
        ArrayList<Customization> customizations = new ArrayList<Customization>();
        customizations.addAll((Collection<Customization>)natTableWidget.getTable().getCustomizations());
        customizations.removeAll(localCustoms);
        customizations.addAll(0, localCustoms);
        return commandFactory.createSetCommand(natTableWidget.getEditingDomain(), (Object)natTableWidget.getTable(), (Object)TablePackage.eINSTANCE.getTable_Customizations(), customizations);
    }

    public static CompoundCommand createDropCommand(TableWidgetController natTableWidget, IStructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        EditingDomain editingDomain = natTableWidget.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        ICommandFactory commandFactory = natTableWidget.getCommandFactory();
        CompoundCommand compoundCommand = new CompoundCommand();
        if (feature.isMany()) {
            for (Object object : structuredSelection) {
                Command addCommand = commandFactory.createAddCommand(editingDomain, element, (Object)feature, object);
                compoundCommand.append(addCommand);
            }
        } else if (structuredSelection.toList().size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            Command addCommand = commandFactory.createSetCommand(editingDomain, element, (Object)feature, firstElement);
            compoundCommand.append(addCommand);
        }
        return compoundCommand;
    }

    public static Command createHideColumnCommand(TableWidgetController widgetController, Collection<FeatureColumn> featureColumns) {
        IsOneOfQuery conformanceQuery;
        Facet typeCustomization;
        FacetOperation isVisibleProperty = widgetController.getCustomPropertiesHandler().getIsVisible();
        CompoundCommand resultCmd = new CompoundCommand("Show/hide column");
        EditingDomain editingDomain = widgetController.getEditingDomain();
        ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(editingDomain);
        EList localCustomizations = widgetController.getTable().getLocalCustomizations();
        Customization customization = null;
        if (!localCustomizations.isEmpty()) {
            customization = (Customization)localCustomizations.get(0);
        }
        ICustomizationCommandFactory customCmdFactory = ICustomizationCommandFactoryFactory.DEFAULT.createCustomizationCommandFactory(editingDomain, (org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)commandFactory);
        if (customization == null) {
            TableCommandFactory factory = new TableCommandFactory(widgetController.getTable(), widgetController.getEditingDomain(), commandFactory, null);
            ICommandFactoryResult<Customization> cmdFactoryResult = factory.createCreateLocalCustom((EPackage)EcorePackage.eINSTANCE);
            customization = (Customization)cmdFactoryResult.getResult();
            resultCmd.append(cmdFactoryResult.getCommand());
        }
        if ((typeCustomization = CustomizationUtils.findFacetByExtendedMetaclass(FacetUtils.getFacets((FacetSet)customization), EcorePackage.eINSTANCE.getETypedElement())) == null) {
            conformanceQuery = QueryFactory.eINSTANCE.createIsOneOfQuery();
            ICommandFactoryResult createEClassCustom = customCmdFactory.createEClassCustomization(customization, EcorePackage.eINSTANCE.getETypedElement(), (Query)conformanceQuery);
            typeCustomization = (Facet)createEClassCustom.getResult();
            resultCmd.append(createEClassCustom.getCommand());
        } else {
            if (!(typeCustomization instanceof EClassCustomization)) {
                throw new TableWidgetRuntimeException("Unexpected type for the variable 'featureContainer'");
            }
            DerivedTypedElement conformanceTE = (DerivedTypedElement)typeCustomization.getConformanceTypedElement();
            conformanceQuery = (IsOneOfQuery)conformanceTE.getQuery();
        }
        HashSet<ETypedElement> featuresToHide = new HashSet<ETypedElement>();
        for (FeatureColumn column : featureColumns) {
            featuresToHide.add(column.getFeature());
        }
        Command initQuery = commandFactory.createSetCommand(editingDomain, (Object)conformanceQuery, (Object)QueryPackage.eINSTANCE.getIsOneOfQuery_ExpectedEObjects(), new ArrayList(featuresToHide));
        resultCmd.append(initQuery);
        FalseLiteralQuery query = QueryFactory.eINSTANCE.createFalseLiteralQuery();
        ICommandFactoryResult propConfigCmd = customCmdFactory.setPropertyConfig(typeCustomization, null, isVisibleProperty, (Query)query);
        resultCmd.append(propConfigCmd.getCommand());
        return resultCmd;
    }

    private TableInstanceCommandFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static Command delete(String label, Collection<? extends EObject> eObjects, TableWidgetController controller) {
        void var4_8;
        ArrayList<Command> cmdList = new ArrayList<Command>();
        for (EObject eObject : eObjects) {
            Command command = controller.getCommandFactory().createDeleteCommand(controller.getEditingDomain(), (Object)eObject);
            cmdList.add(command);
        }
        Object var4_6 = null;
        if (!cmdList.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand(label, cmdList);
        }
        return var4_8;
    }

    public static final Command createRemoveUselessRowsAndColumnsCommand(TableWidgetController controller) {
        TableCommandFactory tableCmdFactory;
        Command removeColumnCommand;
        Command deleteRows;
        ArrayList<Command> cmdList = new ArrayList<Command>();
        List<Row> rowsToRemove = InternalTableUtils.findUselessRow(controller.getTable());
        if (TableWidgetController.DEBUG_REMOVE_USELESS_ROWS_AND_COLUMNS) {
            DebugUtils.debug((String)("Rows to be removed: " + rowsToRemove.size()));
        }
        if ((deleteRows = TableInstanceCommandFactory.delete(Messages.TableWidgetController_DeleteUselessRows, rowsToRemove, controller)) != null) {
            cmdList.add(deleteRows);
        }
        if ((removeColumnCommand = (tableCmdFactory = new TableCommandFactory(controller.getTable(), controller.getEditingDomain(), controller.getCommandFactory(), null)).createRemoveUselessColumnsCommand(rowsToRemove, null)) != null) {
            if (!removeColumnCommand.canExecute()) {
                throw new TableWidgetRuntimeException("Command cannot be executed");
            }
            cmdList.add(removeColumnCommand);
        }
        CompoundCommand command = null;
        if (!cmdList.isEmpty()) {
            command = new CompoundCommand(Messages.TableWidgetController_RemoveUselessRowsAndColumns, cmdList);
        }
        return command;
    }
}

