/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.service.CachingMarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.DefaultCatalogService;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator
implements IMarketplaceServiceLocator {
    private static ServiceLocator instance;
    private Map<String, IMarketplaceService> marketplaceServices;
    private ICatalogService catalogService;
    private ServiceTracker<IMarketplaceService, IMarketplaceService> marketplaceServiceTracker;
    private ServiceTracker<ICatalogService, ICatalogService> catalogServiceTracker;
    private URL defaultCatalogUrl;
    private URL defaultMarketplaceUrl = DefaultMarketplaceService.DEFAULT_SERVICE_URL;

    public ServiceLocator() {
        this.defaultCatalogUrl = DefaultCatalogService.DEFAULT_CATALOG_SERVICE_URL;
    }

    @Deprecated
    public IMarketplaceService getMarketplaceService() {
        return this.getDefaultMarketplaceService();
    }

    @Override
    public IMarketplaceService getDefaultMarketplaceService() {
        return this.getMarketplaceService(this.defaultMarketplaceUrl.toExternalForm());
    }

    @Override
    public synchronized IMarketplaceService getMarketplaceService(String baseUrl) {
        IMarketplaceService service;
        ServiceReference[] serviceReferences;
        if (this.marketplaceServiceTracker != null && (serviceReferences = this.marketplaceServiceTracker.getServiceReferences()) != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                Object serviceBaseUrl = serviceReference.getProperty("url");
                if (baseUrl.equals(serviceBaseUrl) && (service = (IMarketplaceService)this.marketplaceServiceTracker.getService(serviceReference)) != null) {
                    return service;
                }
                ++n2;
            }
        }
        if (this.marketplaceServices != null && (service = this.marketplaceServices.get(baseUrl)) != null) {
            return service;
        }
        service = this.createMarketplaceService(baseUrl);
        if (this.marketplaceServices != null) {
            this.marketplaceServices.put(baseUrl, service);
        }
        return service;
    }

    protected IMarketplaceService createMarketplaceService(String baseUrl) {
        URL base;
        try {
            base = URLUtil.toURL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        DefaultMarketplaceService defaultService = new DefaultMarketplaceService(base);
        Map<String, String> requestMetaParameters = ServiceLocator.computeDefaultRequestMetaParameters();
        defaultService.setRequestMetaParameters(requestMetaParameters);
        CachingMarketplaceService service = new CachingMarketplaceService(defaultService);
        return service;
    }

    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        URL marketplaceUrl;
        URL baseUrl = ServiceUtil.getUrl(properties, "url", null);
        URL catalogUrl = ServiceUtil.getUrl(properties, "catalogUrl", baseUrl);
        if (catalogUrl != null) {
            this.defaultCatalogUrl = catalogUrl;
        }
        if ((marketplaceUrl = ServiceUtil.getUrl(properties, "marketplaceUrl", baseUrl)) != null) {
            this.defaultMarketplaceUrl = marketplaceUrl;
        }
        if (this.marketplaceServices == null) {
            this.marketplaceServices = new HashMap<String, IMarketplaceService>();
        }
        this.marketplaceServiceTracker = new ServiceTracker(context, IMarketplaceService.class, null);
        this.marketplaceServiceTracker.open(true);
        this.catalogServiceTracker = new ServiceTracker(context, ICatalogService.class, null);
        this.catalogServiceTracker.open(true);
    }

    public synchronized void deactivate() {
        if (this.marketplaceServiceTracker != null) {
            this.marketplaceServiceTracker.close();
            this.marketplaceServiceTracker = null;
        }
        if (this.catalogServiceTracker != null) {
            this.catalogServiceTracker.close();
            this.catalogServiceTracker = null;
        }
        this.marketplaceServices = null;
        this.catalogService = null;
    }

    @Override
    public synchronized ICatalogService getCatalogService() {
        ICatalogService registeredService;
        if (this.catalogServiceTracker != null && (registeredService = (ICatalogService)this.catalogServiceTracker.getService()) != null) {
            return registeredService;
        }
        if (this.catalogService != null) {
            return this.catalogService;
        }
        DefaultCatalogService catalogService = new DefaultCatalogService(this.defaultCatalogUrl);
        if (this.marketplaceServices != null) {
            this.catalogService = catalogService;
        }
        return catalogService;
    }

    @Deprecated
    public static synchronized void setInstance(ServiceLocator instance) {
        ServiceLocator.instance = instance;
    }

    @Deprecated
    public static synchronized ServiceLocator getInstance() {
        if (instance != null) {
            return instance;
        }
        IMarketplaceServiceLocator locator = ServiceLocator.getCompatibilityLocator();
        if (locator != null && locator instanceof ServiceLocator) {
            return (ServiceLocator)locator;
        }
        instance = new ServiceLocator();
        return instance;
    }

    public static synchronized IMarketplaceServiceLocator getCompatibilityLocator() {
        if (instance != null) {
            return instance;
        }
        IMarketplaceServiceLocator locator = ServiceHelper.getMarketplaceServiceLocator();
        if (locator == null) {
            instance = new ServiceLocator();
            locator = instance;
        }
        return locator;
    }

    public static Map<String, String> computeDefaultRequestMetaParameters() {
        Bundle platformBundle;
        Bundle runtimeBundle;
        HashMap<String, String> requestMetaParameters = new HashMap<String, String>();
        requestMetaParameters.put("client", "org.eclipse.epp.mpc.core");
        requestMetaParameters.put("os", Platform.getOS());
        requestMetaParameters.put("ws", Platform.getWS());
        requestMetaParameters.put("nl", Platform.getNL());
        requestMetaParameters.put("java.version", System.getProperty("java.version"));
        IProduct product = Platform.getProduct();
        if (product != null) {
            requestMetaParameters.put("product", product.getId());
            Bundle productBundle = product.getDefiningBundle();
            if (productBundle != null) {
                requestMetaParameters.put("product.version", productBundle.getVersion().toString());
            }
        }
        if ((runtimeBundle = Platform.getBundle((String)"org.eclipse.core.runtime")) != null) {
            requestMetaParameters.put("runtime.version", runtimeBundle.getVersion().toString());
        }
        if ((platformBundle = Platform.getBundle((String)"org.eclipse.platform")) != null) {
            requestMetaParameters.put("platform.version", platformBundle.getVersion().toString());
        }
        return requestMetaParameters;
    }
}

