/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMarketplaceService
implements IMarketplaceService {
    private final IMarketplaceService delegate;
    private int maxCacheSize = 30;
    private final Map<String, Reference<Object>> cache = new LinkedHashMap<String, Reference<Object>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Reference<Object>> eldest) {
            return this.size() > CachingMarketplaceService.this.maxCacheSize || eldest.getValue().get() == null;
        }
    };

    public CachingMarketplaceService(IMarketplaceService delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    @Override
    public List<? extends IMarket> listMarkets(IProgressMonitor monitor) throws CoreException {
        return this.delegate.listMarkets(monitor);
    }

    @Override
    public IMarket getMarket(IMarket market, IProgressMonitor monitor) throws CoreException {
        return this.delegate.getMarket(market, monitor);
    }

    @Override
    public ICategory getCategory(ICategory category, IProgressMonitor monitor) throws CoreException {
        return this.delegate.getCategory(category, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode getNode(INode node, IProgressMonitor monitor) throws CoreException {
        Map<String, Reference<Object>> map;
        String nodeKey = this.computeNodeKey(node);
        INode nodeResult = null;
        if (nodeKey != null) {
            map = this.cache;
            synchronized (map) {
                Reference<Object> reference = this.cache.get(nodeKey);
                if (reference != null) {
                    nodeResult = (Node)reference.get();
                }
            }
        }
        if (nodeResult == null && (nodeResult = this.delegate.getNode(node, monitor)) != null) {
            map = this.cache;
            synchronized (map) {
                this.cache.put(this.computeNodeKey(nodeResult), new SoftReference<INode>(nodeResult));
            }
        }
        return nodeResult;
    }

    private String computeNodeKey(INode node) {
        if (node.getId() != null) {
            return "Node:" + node.getId();
        }
        return null;
    }

    @Override
    public ISearchResult search(final IMarket market, final ICategory category, final String queryText, IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("search", market, category, queryText);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.search(market, category, queryText, monitor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISearchResult performSearch(IProgressMonitor monitor, String key, SearchOperation searchOperation) throws CoreException {
        ISearchResult result = null;
        Map<String, Reference<Object>> map = this.cache;
        synchronized (map) {
            Reference<Object> reference = this.cache.get(key);
            if (reference != null) {
                result = (ISearchResult)reference.get();
            }
        }
        if (result == null && (result = searchOperation.doSearch(monitor)) != null) {
            map = this.cache;
            synchronized (map) {
                this.cache.put(key, new SoftReference<ISearchResult>(result));
                for (INode iNode : result.getNodes()) {
                    this.cache.put(this.computeNodeKey(iNode), new SoftReference<INode>(iNode));
                }
            }
        }
        return result;
    }

    private String computeSearchKey(String prefix, IMarket market, ICategory category, String queryText) {
        return String.valueOf(prefix) + ":" + (market == null ? "" : market.getId()) + ":" + (category == null ? "" : category.getId()) + ":" + (queryText == null ? "" : queryText.trim());
    }

    @Override
    public ISearchResult featured(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("featured", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.featured(monitor);
            }
        });
    }

    @Override
    public ISearchResult featured(final IMarket market, final ICategory category, IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("featured", market, category, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.featured(market, category, monitor);
            }
        });
    }

    @Override
    public ISearchResult recent(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("recent", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.recent(monitor);
            }
        });
    }

    @Override
    public ISearchResult favorites(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("favorites", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.favorites(monitor);
            }
        });
    }

    @Override
    public ISearchResult popular(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("popular", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.popular(monitor);
            }
        });
    }

    @Override
    public INews news(IProgressMonitor monitor) throws CoreException {
        return this.delegate.news(monitor);
    }

    public void reportInstallError(IProgressMonitor monitor, IStatus result, Set<Node> nodes, Set<String> iuIdsAndVersions, String resolutionDetails) throws CoreException {
        this.reportInstallError(result, nodes, iuIdsAndVersions, resolutionDetails, monitor);
    }

    @Override
    public void reportInstallError(IStatus result, Set<? extends INode> nodes, Set<String> iuIdsAndVersions, String resolutionDetails, IProgressMonitor monitor) throws CoreException {
        this.delegate.reportInstallError(result, nodes, iuIdsAndVersions, resolutionDetails, monitor);
    }

    @Override
    public void reportInstallSuccess(INode node, IProgressMonitor monitor) {
        this.delegate.reportInstallSuccess(node, monitor);
    }

    private static interface SearchOperation {
        public ISearchResult doSearch(IProgressMonitor var1) throws CoreException;
    }
}

