/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.validate.AbstractValidator;
import org.eclipse.gmf.internal.validate.ConstraintDef;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.DefUtils;
import org.eclipse.gmf.internal.validate.ExternModelImport;
import org.eclipse.gmf.internal.validate.IDefElementProvider;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.ValueSpecDef;
import org.eclipse.gmf.internal.validate.expressions.EnvironmentProvider;
import org.eclipse.gmf.internal.validate.expressions.ExpressionProviderRegistry;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;
import org.eclipse.gmf.internal.validate.expressions.NoProviderExpression;
import org.eclipse.gmf.internal.validate.ocl.OCLExpressionProvider;
import org.eclipse.osgi.util.NLS;

public class AnnotatedDefinitionValidator
extends AbstractValidator
implements EValidator {
    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject.eClass().getEPackage() == EcorePackage.eINSTANCE) {
            if (eObject instanceof EModelElement) {
                return this.validateMetaModel((EModelElement)eObject, diagnostics, context);
            }
        } else {
            return this.validateModel(eObject, diagnostics, context);
        }
        return true;
    }

    protected boolean validateModel(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EReference[] constrainedFeatures = AnnotatedDefinitionValidator.collectConstrainedFeatures(eObject.eClass());
        if (constrainedFeatures == null || constrainedFeatures.length == 0) {
            return true;
        }
        boolean result = true;
        EReference[] eReferenceArray = constrainedFeatures;
        int n = constrainedFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EReference sf = eReferenceArray[n2];
            if (eObject.eIsSet((EStructuralFeature)sf)) {
                List constraintObject;
                if (sf.isMany()) {
                    constraintObject = (List)eObject.eGet((EStructuralFeature)sf, true);
                    for (EObject o : constraintObject) {
                        result &= this.validateInstance(eObject, sf, o, diagnostics, context);
                    }
                } else {
                    constraintObject = (EObject)eObject.eGet((EStructuralFeature)sf, true);
                    result = constraintObject != null && this.validateInstance(eObject, sf, (EObject)constraintObject, diagnostics, context);
                }
            }
            ++n2;
        }
        return result;
    }

    private boolean validateInstance(EObject context, EReference contextFeature, EObject constraint, DiagnosticChain diag, Map<Object, Object> validationContext) {
        String body;
        ValueSpecDef def = AnnotatedDefinitionValidator.getDefinition(constraint.eClass(), diag, null, validationContext);
        if (def == null) {
            EValidator.SubstitutionLabelProvider lp = AnnotatedDefinitionValidator.getLabelProvider(validationContext);
            String message = String.format("Object '%s', supposed to be a constraint for feature '%s' of '%s', is missing essential constraint metainformation", lp.getObjectLabel(constraint), lp.getFeatureLabel((EStructuralFeature)contextFeature), lp.getObjectLabel(context));
            diag.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.INVALID_CONSTRAINT_CONTEXT, message, new Object[]{context}));
            return false;
        }
        if (!def.isOK()) {
            return false;
        }
        String lang = def.createLanguage(constraint);
        if (!("ocl".equals(lang) || "regexp".equals(lang) || "nregexp".equals(lang))) {
            return true;
        }
        ContextData contextData = this.getContextBinding(context.eClass(), (EStructuralFeature)contextFeature, validationContext);
        if (contextData == null) {
            diag.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE, NLS.bind((String)Messages.def_NoContextAvailable, (Object)AnnotatedDefinitionValidator.getLabelProvider(validationContext).getObjectLabel(context)), new Object[]{context}));
            return false;
        }
        EClassifier evaluationContextClass = contextData.contextClass.getContextClassifier(context);
        if (evaluationContextClass == null) {
            String noCtxMessage = contextData.contextClass.getStatus().isOK() ? NLS.bind((String)Messages.def_NoContextAvailable, (Object)AnnotatedDefinitionValidator.getLabelProvider(validationContext).getObjectLabel(context)) : contextData.contextClass.getStatus().getMessage();
            diag.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE, noCtxMessage, new Object[]{context}));
        }
        if ((body = def.createBody(constraint)) != null && evaluationContextClass != null) {
            IModelExpression expression;
            IParseEnvironment env = null;
            if (contextData.environment != null) {
                env = EnvironmentProvider.createParseEnv();
                ExternModelImport modelImports = ExternModelImport.getImporter(validationContext);
                env.setImportRegistry(modelImports.getPackageRegistry());
                for (String varName : contextData.environment.keySet()) {
                    IDefElementProvider.TypeProvider typeProvider = contextData.environment.get(varName);
                    EClassifier type = typeProvider.getType(context);
                    if (type == null) continue;
                    env.setVariable(varName, type);
                }
            }
            if (!(expression = AnnotatedDefinitionValidator.getExpression(lang, body, evaluationContextClass, env)).getStatus().isOK()) {
                String message = MessageFormat.format(Messages.invalidExpressionBody, expression.getBody(), expression.getStatus().getMessage());
                diag.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.INVALID_CONSTRAINT_EXPRESSION, message, new Object[]{context}));
                return false;
            }
            EObject typeResolutionContext = context;
            IDefElementProvider.TypeProvider typeProvider = def.getTypeRestriction();
            if (typeProvider == null) {
                typeProvider = AnnotatedDefinitionValidator.getTypeInfo((EModelElement)contextFeature, context.eClass(), diag, validationContext);
            }
            if (typeProvider != null && typeProvider.getStatus().isOK() && expression.getResultType() != null && !typeProvider.isAssignable(typeResolutionContext, expression)) {
                EClassifier type = typeProvider.getType(typeResolutionContext);
                IStatus s = DefUtils.getIncompatibleTypesStatus(type, expression.getResultType());
                diag.add(DefUtils.statusToDiagnostic(s, "org.eclipse.gmf.validation", context));
                return false;
            }
        }
        return true;
    }

    private static IModelExpression getExpression(String language, String body, EClassifier context, IParseEnvironment env) {
        IModelExpressionProvider provider = ExpressionProviderRegistry.getInstance().getProvider(language);
        if (provider == null) {
            return new NoProviderExpression(language, body, context);
        }
        return provider.createExpression(body, context, env);
    }

    public ContextData getContextBinding(EClass contextClass, EStructuralFeature featureToConstraint, Map<Object, Object> validationContext) {
        ContextData contextData = AnnotatedDefinitionValidator.getCachedCtxBinding((EModelElement)featureToConstraint, validationContext);
        if (contextData != null) {
            return contextData;
        }
        IDefElementProvider.ContextProvider contextProvider = AnnotatedDefinitionValidator.getContextClass(featureToConstraint, validationContext);
        if (contextProvider != null) {
            ContextData newContextData = new ContextData(contextProvider, AnnotatedDefinitionValidator.getEnvProvider(featureToConstraint, AnnotatedDefinitionValidator.getExpressionFactory(validationContext)));
            AnnotatedDefinitionValidator.registerCtxBinding(featureToConstraint, newContextData, validationContext);
            if (Trace.shouldTrace(DebugOptions.META_DEFINITIONS)) {
                String msgPtn = "[context-def] {0} binding: {1}::{2}";
                Trace.trace(MessageFormat.format(msgPtn, newContextData.contextClass.toString(), LabelProvider.INSTANCE.getObjectLabel((EObject)contextClass), LabelProvider.INSTANCE.getFeatureLabel(featureToConstraint)));
            }
            return newContextData;
        }
        return null;
    }

    protected boolean validateMetaModel(EModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EAnnotation annotation;
        EAnnotation eAnnotation = annotation = modelElement instanceof EAnnotation ? (EAnnotation)modelElement : null;
        if (annotation != null) {
            if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(annotation.getSource())) {
                return true;
            }
            modelElement = annotation.getEModelElement();
            if (modelElement == null) {
                return true;
            }
        }
        if (modelElement instanceof EStructuralFeature && annotation != null && "context".equals(annotation.getDetails().get((Object)"def"))) {
            EStructuralFeature sfeature = (EStructuralFeature)modelElement;
            IDefElementProvider.ContextProvider contextProvider = AnnotatedDefinitionValidator.getContextClass(sfeature, context);
            if (contextProvider != null) {
                AnnotatedDefinitionValidator.getEnvProvider(sfeature, AnnotatedDefinitionValidator.getExpressionFactory(context));
                if (!contextProvider.getStatus().isOK()) {
                    DefUtils.mergeAndFlatten(contextProvider.getStatus(), "org.eclipse.gmf.validation", annotation, diagnostics);
                    return false;
                }
            }
        } else if (modelElement instanceof EClass) {
            AnnotatedDefinitionValidator.getDefinition((EClass)modelElement, diagnostics, null, context);
        }
        return true;
    }

    private static OCLExpressionProvider getExpressionFactory(Map<Object, Object> validationContext) {
        OCLExpressionProvider p = (OCLExpressionProvider)validationContext.get(OCLExpressionProvider.class);
        if (p == null) {
            p = new OCLExpressionProvider();
            validationContext.put(OCLExpressionProvider.class, p);
        }
        return p;
    }

    public static IDefElementProvider.ContextProvider getContextClass(EStructuralFeature bindFeature, Map<Object, Object> validationContext) {
        EClass resolutionContext = bindFeature.getEContainingClass();
        ExternModelImport modelImports = ExternModelImport.getImporter(validationContext);
        return DefUtils.getContextClass(resolutionContext, AnnotatedDefinitionValidator.getExpressionFactory(validationContext), bindFeature, modelImports.getPackageRegistry());
    }

    private static ValueSpecDef getDefinition(EClass metaClass, DiagnosticChain diagnostics, DefData data, Map<Object, Object> context) {
        ValueSpecDef definition = AnnotatedDefinitionValidator.findDefinition(metaClass, context);
        if (definition != null) {
            return definition;
        }
        if (data == null) {
            for (EAnnotation nextAnnotation : metaClass.getEAnnotations()) {
                String val;
                if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(nextAnnotation.getSource()) || (val = (String)nextAnnotation.getDetails().get((Object)"def")) == null || !val.equals("ValueSpec") && !val.equals("Constraint")) continue;
                data = new DefData();
                data.metaKey = val;
                data.defClass = metaClass;
                break;
            }
        }
        EList superTypes = metaClass.getESuperTypes();
        if (data == null && superTypes.isEmpty()) {
            return null;
        }
        if (data != null) {
            OCLExpressionProvider expressionFactory = AnnotatedDefinitionValidator.getExpressionFactory(context);
            for (EStructuralFeature nextAttr : metaClass.getEStructuralFeatures()) {
                for (EAnnotation annotation : nextAttr.getEAnnotations()) {
                    String ctxExpression;
                    if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(annotation.getSource())) continue;
                    String metaValue = (String)annotation.getDetails().get((Object)"def");
                    if (data.body == null && "body".equals(metaValue)) {
                        data.body = new DefUtils.FeatureValProvider(nextAttr);
                        AnnotatedDefinitionValidator.checkAndReportProblems(data.body, (EObject)annotation, diagnostics);
                    }
                    if (data.lang == null && "lang".equals(metaValue)) {
                        data.lang = new DefUtils.FeatureValProvider(nextAttr);
                        AnnotatedDefinitionValidator.checkAndReportProblems(data.lang, (EObject)annotation, diagnostics);
                    }
                    if (data.context == null && "context".equals(metaValue) && (ctxExpression = (String)annotation.getDetails().get((Object)"ocl")) != null) {
                        data.context = new DefUtils.ExpressionContextProvider(expressionFactory.createExpression(ctxExpression, (EClassifier)metaClass));
                        AnnotatedDefinitionValidator.checkAndReportProblems(data.context, (EObject)annotation, diagnostics);
                    }
                    if (data.type != null || !"type".equals(metaValue)) continue;
                    String typeExpr = (String)annotation.getDetails().get((Object)"ocl");
                    data.type = typeExpr != null ? new DefUtils.ExpressionTypeProvider(expressionFactory.createExpression(typeExpr, (EClassifier)metaClass)) : new DefUtils.TypedElementProvider(nextAttr);
                    AnnotatedDefinitionValidator.checkAndReportProblems(data.type, (EObject)annotation, diagnostics);
                }
            }
            if (data.type == null) {
                data.type = AnnotatedDefinitionValidator.getTypeInfo((EModelElement)metaClass, metaClass, diagnostics, context);
            }
            if (data.body != null) {
                definition = data.createDefinition();
                assert (data.defClass != null);
                AnnotatedDefinitionValidator.registerDefinition(data.defClass, definition, context);
                return definition;
            }
        }
        for (EClass superClass : superTypes) {
            ValueSpecDef inheritedDef = AnnotatedDefinitionValidator.getDefinition(superClass, diagnostics, data, context);
            if (inheritedDef == null) continue;
            if (data == null) {
                data = new DefData();
            }
            data.inheritFrom(metaClass, inheritedDef);
            AnnotatedDefinitionValidator.registerDefinition(data.defClass, data.createDefinition(), context);
            return inheritedDef;
        }
        if (data != null && data.body == null) {
            String message = MessageFormat.format(Messages.def_MissingBodyAnnotation, LabelProvider.INSTANCE.getObjectLabel((EObject)metaClass));
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.MISSING_VALUESPEC_BODY_ANNOTATION, message, new Object[]{metaClass}));
            return null;
        }
        return null;
    }

    private static IDefElementProvider.TypeProvider getTypeInfo(EModelElement typeAnnotationSource, EClass resolutionContext, DiagnosticChain diagnostics, Map<Object, Object> validationContext) {
        String typeExprBody;
        DefUtils.AbstractProvider typeProvider = null;
        List<EAnnotation> annotations = DefUtils.getAnnotationsWithKeyAndValue(typeAnnotationSource, "http://www.eclipse.org/gmf/2005/constraints/meta", "def", "type");
        EAnnotation typeAnnotation = annotations.isEmpty() ? null : annotations.get(0);
        OCLExpressionProvider exprFactory = AnnotatedDefinitionValidator.getExpressionFactory(validationContext);
        ExternModelImport modelImports = ExternModelImport.getImporter(validationContext);
        if (typeAnnotation != null && "type".equals(typeAnnotation.getDetails().get((Object)"def")) && (typeExprBody = (String)typeAnnotation.getDetails().get((Object)"ocl")) != null) {
            IModelExpression typeExpr = exprFactory.createExpression(typeExprBody, (EClassifier)resolutionContext);
            boolean usesTypeName = typeExpr.getStatus().isOK() && String.class.equals((Object)typeExpr.getResultType().getInstanceClass());
            typeProvider = usesTypeName ? new DefUtils.ContextTypeAdapter(new DefUtils.LookupByNameContextProvider(typeExpr, modelImports.getPackageRegistry())) : new DefUtils.ExpressionTypeProvider(typeExpr);
            AnnotatedDefinitionValidator.checkAndReportProblems(typeProvider, (EObject)typeAnnotation, diagnostics);
        }
        return typeProvider;
    }

    private static boolean checkAndReportProblems(IDefElementProvider defElementProvider, EObject destination, DiagnosticChain diagnostics) {
        if (!defElementProvider.getStatus().isOK()) {
            diagnostics.add(DefUtils.statusToDiagnostic(defElementProvider.getStatus(), "org.eclipse.gmf.validation", destination));
            return false;
        }
        return true;
    }

    private static Map<String, IDefElementProvider.TypeProvider> getEnvProvider(EStructuralFeature contextBindFeature, OCLExpressionProvider exprFactory) {
        List<EAnnotation> varDefs = DefUtils.getAnnotationsWithKeyAndValue((EModelElement)contextBindFeature, "http://www.eclipse.org/gmf/2005/constraints/meta", "def", "variable");
        if (varDefs.isEmpty()) {
            return null;
        }
        HashMap<String, DefUtils.ExpressionTypeProvider> env = null;
        for (EAnnotation nextVarAnnotation : varDefs) {
            String name;
            String body;
            DefUtils.ExpressionTypeProvider type = null;
            String typePrefix = "type.";
            Map.Entry<String, String> typeExpression = DefUtils.getKeyPrefixAnnotation(nextVarAnnotation, typePrefix);
            if (typeExpression != null && (body = typeExpression.getValue()) != null) {
                IModelExpression expression = exprFactory.createExpression(body, (EClassifier)contextBindFeature.getEContainingClass());
                type = new DefUtils.ExpressionTypeProvider(expression);
            }
            if ((name = (String)nextVarAnnotation.getDetails().get((Object)"name")) == null) continue;
            if (env == null) {
                env = new HashMap<String, DefUtils.ExpressionTypeProvider>();
            }
            env.put(name, type);
        }
        return env;
    }

    private static void registerDefinition(EClass eClass, ValueSpecDef definition, Map<Object, Object> context) {
        assert (definition != null);
        assert (eClass != null);
        HashMap<EClass, ValueSpecDef> defMap = (HashMap<EClass, ValueSpecDef>)context.get(ValueSpecDef.class);
        if (defMap == null) {
            defMap = new HashMap<EClass, ValueSpecDef>();
            context.put(ValueSpecDef.class, defMap);
        }
        defMap.put(eClass, definition);
    }

    private static ValueSpecDef findDefinition(EClass eClass, Map<Object, Object> context) {
        Map defMap = (Map)context.get(ValueSpecDef.class);
        return defMap != null ? (ValueSpecDef)defMap.get(eClass) : null;
    }

    private static ContextData getCachedCtxBinding(EModelElement modelElement, Map<Object, Object> context) {
        Map bindMap;
        if (context != null && (bindMap = (Map)context.get(IDefElementProvider.ContextProvider.class)) != null) {
            return (ContextData)bindMap.get(modelElement);
        }
        if (Trace.shouldTrace(DebugOptions.DEBUG)) {
            Trace.trace("Performance warning: Validation should run in a context for caching");
        }
        return null;
    }

    private static void registerCtxBinding(EStructuralFeature contextDefOwner, ContextData contextData, Map<Object, Object> context) {
        if (context != null) {
            HashMap<EStructuralFeature, ContextData> bindMap = (HashMap<EStructuralFeature, ContextData>)context.get(IDefElementProvider.ContextProvider.class);
            if (bindMap == null) {
                bindMap = new HashMap<EStructuralFeature, ContextData>();
                context.put(IDefElementProvider.ContextProvider.class, bindMap);
            }
            bindMap.put(contextDefOwner, contextData);
        }
    }

    private static EReference[] collectConstrainedFeatures(EClass eClass) {
        LinkedList<EReference> result = new LinkedList<EReference>();
        block0: for (EReference sf : eClass.getEAllReferences()) {
            for (EAnnotation a : sf.getEAnnotations()) {
                if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(a.getSource()) || !"context".equals(a.getDetails().get((Object)"def"))) continue;
                result.add(sf);
                continue block0;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new EReference[result.size()]);
    }

    private static class ContextData {
        final IDefElementProvider.ContextProvider contextClass;
        final Map<String, IDefElementProvider.TypeProvider> environment;

        public ContextData(IDefElementProvider.ContextProvider contextProvider, Map<String, IDefElementProvider.TypeProvider> environment) {
            this.contextClass = contextProvider;
            this.environment = environment;
        }
    }

    private static class DefData {
        String metaKey;
        EClass defClass;
        IDefElementProvider.StringValProvider body;
        IDefElementProvider.StringValProvider lang;
        IDefElementProvider.TypeProvider type;
        IDefElementProvider.ContextProvider context;

        ValueSpecDef createDefinition() {
            ValueSpecDef valueSpecDef;
            assert (this.body != null);
            ValueSpecDef valueSpecDef2 = valueSpecDef = "Constraint".equals(this.metaKey) ? new ConstraintDef(this.body, this.lang) : new ValueSpecDef(this.body, this.lang, this.type);
            if (Trace.shouldTrace(DebugOptions.META_DEFINITIONS)) {
                String msgPtn = "[{0}] {1} type: {2}";
                Trace.trace(MessageFormat.format(msgPtn, this.metaKey, this.defClass.getName(), this.type));
            }
            return valueSpecDef;
        }

        void inheritFrom(EClass valueSpecEClass, ValueSpecDef superDef) {
            this.defClass = valueSpecEClass;
            if (this.body == null) {
                this.body = superDef.getBody();
            }
            if (this.lang == null) {
                this.lang = superDef.getLang();
            }
            if (this.type == null) {
                this.type = superDef.getTypeRestriction();
            }
        }
    }
}

