/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.utils;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gmt.modisco.infra.discoverymanager.Messages;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

@Deprecated
public class BooleanCellEditor
extends CellEditor {
    private final String[] booleanItems = new String[]{Messages.BooleanCellEditor_false, Messages.BooleanCellEditor_true};
    private String[] items;
    private int selection;
    private CCombo comboBox;

    public BooleanCellEditor() {
        this.setItems(this.booleanItems);
        this.setStyle(0);
    }

    protected Object doGetValue() {
        Boolean result = Boolean.valueOf(this.booleanItems[this.selection]);
        return result;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof Boolean));
        int index = 0;
        if (((Boolean)value).booleanValue()) {
            index = 1;
        }
        Assert.isTrue((this.comboBox != null ? 1 : 0) != 0);
        this.selection = index;
        this.comboBox.select(this.selection);
    }

    private void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BooleanCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                BooleanCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                BooleanCellEditor.this.selection = BooleanCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    private void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.items.length > 0 && this.selection >= 0 && this.selection < this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

