/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DescriptionDialogField
extends DialogField {
    private String fText = "";
    private Label fDescriptionControl;

    protected static GridData gridDataForDescription(int span) {
        GridData gd = new GridData(4, 2, false, false);
        gd.horizontalSpan = span;
        return gd;
    }

    protected Label createDescriptionControl(Composite parent) {
        Label desc = new Label(parent, 16448);
        desc.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        return desc;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DescriptionDialogField.gridDataForLabel(1));
        Label description = this.getDescriptionControl(parent);
        description.setLayoutData((Object)DescriptionDialogField.gridDataForDescription(nColumns - 1));
        return new Control[]{label, description};
    }

    public Label getDescriptionControl(Composite parent) {
        if (this.fDescriptionControl == null) {
            this.assertCompositeNotNull(parent);
            this.fDescriptionControl = this.createDescriptionControl(parent);
            this.fDescriptionControl.setText(this.fText);
            this.fDescriptionControl.setFont(parent.getFont());
            this.fDescriptionControl.setEnabled(this.isEnabled());
        }
        return this.fDescriptionControl;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getText() {
        return this.fText;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fDescriptionControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fDescriptionControl)) {
            this.fDescriptionControl.setFocus();
        }
        return true;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fDescriptionControl)) {
            this.fDescriptionControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fDescriptionControl)) {
            this.fDescriptionControl.setText(text);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fDescriptionControl)) {
            this.fDescriptionControl.setEnabled(this.isEnabled());
        }
    }
}

