/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.console.jaas;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.equinox.console.jaas.UserPrincipal;

public class AllowAnyUserLoginModule
implements LoginModule {
    private volatile Subject subject;
    private volatile CallbackHandler callbackHandler;
    private volatile UserPrincipal userPrincipal;

    @Override
    public boolean abort() throws LoginException {
        this.userPrincipal.destroy();
        this.userPrincipal = null;
        return true;
    }

    @Override
    public synchronized boolean commit() throws LoginException {
        this.subject.getPrincipals().add((Principal)this.userPrincipal);
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("username: ");
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback});
        }
        catch (Exception e) {
            throw new FailedLoginException("Cannot get username");
        }
        String username = nameCallback.getName();
        this.userPrincipal = new UserPrincipal(username, username);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws LoginException {
        AllowAnyUserLoginModule allowAnyUserLoginModule = this;
        synchronized (allowAnyUserLoginModule) {
            this.subject.getPrincipals().remove(this.userPrincipal);
        }
        this.subject = null;
        this.userPrincipal.destroy();
        this.userPrincipal = null;
        return true;
    }
}

