/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.jmx;

import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.UnhandledException;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyJmxConnector {
    private static final String PROPERTY_HOST = "gyrex.jmxrmi.host";
    private static final String PROPERTY_PORT = "gyrex.jmxrmi.port";
    private static final Logger LOG = LoggerFactory.getLogger(JettyJmxConnector.class);
    private static ConnectorServer connectorServer;
    private static Status state;

    static synchronized void doStart() throws Exception {
        if (state != Status.STARTING) {
            return;
        }
        EnvironmentInfo info = BootActivator.getEnvironmentInfo();
        if (info.getProperty("gyrex.jmxrmi.skip") != null) {
            return;
        }
        String host = "localhost";
        int port = Platform.getInstancePort(1099);
        if (info.getProperty(PROPERTY_PORT) != null) {
            try {
                port = Integer.parseInt(info.getProperty(PROPERTY_PORT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid JMX port (%s).", info.getProperty(PROPERTY_PORT)), e);
            }
        }
        if (info.getProperty(PROPERTY_HOST) != null) {
            host = info.getProperty(PROPERTY_HOST);
        }
        LOG.info("Enabling JMX remote connections on port {} (host {}).", new Object[]{port, host});
        JMXServiceURL url = new JMXServiceURL("rmi", host, port, String.format("/jndi/rmi://%s:%d/jmxrmi", host, port));
        connectorServer = new ConnectorServer(url, null, "org.eclipse.gyrex.jmx:name=rmiconnectorserver");
        connectorServer.start();
        state = Status.STARTED;
    }

    public static synchronized void start() throws Exception {
        if (state == Status.STARTING || state == Status.STARTED) {
            throw new IllegalStateException("already started");
        }
        state = Status.STARTING;
        Thread t = new Thread("JettyJMXConnectorStart"){

            @Override
            public void run() {
                try {
                    JettyJmxConnector.doStart();
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Jetty JMX is not available. Please configure JMX support manually. ({})", (Object)e.getMessage());
                }
                catch (LinkageError e) {
                    LOG.warn("Jetty JMX is not available. Please configure JMX support manually. ({})", (Object)e.getMessage());
                }
                catch (Exception e) {
                    ServerApplication.shutdown((Throwable)new UnhandledException("An error occured while starting the embedded JMX server. Please verify the port/host configuration is correct and no other server is running. JMX can also be disabled by setting system property 'gyrex.jmxrmi.skip'.", (Throwable)e));
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static synchronized void stop() throws Exception {
        state = null;
        if (connectorServer == null) {
            return;
        }
        try {
            try {
                connectorServer.stop();
            }
            catch (Exception exception) {
                connectorServer = null;
            }
        }
        finally {
            connectorServer = null;
        }
    }

    private static enum Status {
        STARTING,
        STARTED;

    }
}

