/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.internal.roles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.internal.roles.ServerRole;
import org.eclipse.gyrex.server.internal.roles.ServerRoleDefaultStartOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRolesRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRolesRegistry.class);
    private static final String EP_SERVERROLES = "org.eclipse.gyrex.server.roles";
    private static final String ELEM_REQUIRE_BUNDLE = "requireBundle";
    private static final String ELEM_REQUIRE_APPLICATION = "requireApplication";
    private static final String ELEM_DEFAULT_START = "defaultStart";
    private static final String ELEM_ROLE = "role";
    private static final String ATTR_ID = "id";
    private static final String ATTR_START_LEVEL = "startLevel";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_APPLICATION_ID = "applicationId";
    private static final String ATTR_SYMBOLIC_NAME = "symbolicName";
    private static final String ATTR_TRIGGER = "trigger";
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_ROLE_ID = "roleId";
    private static final String ATTR_NODE_FILTER = "nodeFilter";
    private static ServerRolesRegistry instance = new ServerRolesRegistry();
    private Map<String, ServerRole> registeredRoles;
    private final List<ServerRoleDefaultStartOption> defaultStartRoles = new CopyOnWriteArrayList<ServerRoleDefaultStartOption>();

    public static ServerRolesRegistry getDefault() {
        return instance;
    }

    private ServerRolesRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        if (this.registeredRoles != null) {
            return;
        }
        ServerRolesRegistry serverRolesRegistry = this;
        synchronized (serverRolesRegistry) {
            if (this.registeredRoles != null) {
                return;
            }
            this.registeredRoles = new HashMap<String, ServerRole>();
            this.readServerRoles();
        }
    }

    public List<ServerRoleDefaultStartOption> getAllDefaultStartOptions(ServerRoleDefaultStartOption.Trigger trigger) {
        ServerRoleDefaultStartOption.Mode mode = Platform.inDevelopmentMode() ? ServerRoleDefaultStartOption.Mode.DEVELOPMENT : ServerRoleDefaultStartOption.Mode.PRODUCTION;
        ArrayList<ServerRoleDefaultStartOption> startoptions = new ArrayList<ServerRoleDefaultStartOption>();
        for (ServerRoleDefaultStartOption defaultStart : this.defaultStartRoles) {
            if (!defaultStart.matches(mode, trigger)) continue;
            startoptions.add(defaultStart);
        }
        return startoptions;
    }

    public Collection<ServerRole> getAllRoles() {
        return Collections.unmodifiableCollection(this.registeredRoles.values());
    }

    public ServerRole getRole(String id) {
        this.checkInitialized();
        return this.registeredRoles.get(id);
    }

    public Collection<String> getRolesToStartByDefault(ServerRoleDefaultStartOption.Trigger trigger) {
        this.checkInitialized();
        ArrayList<ServerRoleDefaultStartOption> roles = new ArrayList<ServerRoleDefaultStartOption>();
        for (ServerRoleDefaultStartOption defaultStart : this.defaultStartRoles) {
            ServerRoleDefaultStartOption.Mode mode;
            ServerRoleDefaultStartOption.Mode mode2 = mode = Platform.inDevelopmentMode() ? ServerRoleDefaultStartOption.Mode.DEVELOPMENT : ServerRoleDefaultStartOption.Mode.PRODUCTION;
            if (!defaultStart.matches(mode, trigger)) continue;
            roles.add(defaultStart);
        }
        Collections.sort(roles, new Comparator<ServerRoleDefaultStartOption>(){

            @Override
            public int compare(ServerRoleDefaultStartOption r1, ServerRoleDefaultStartOption r2) {
                return r1.getStartLevel() - r2.getStartLevel();
            }
        });
        ArrayList<String> roleIds = new ArrayList<String>(roles.size());
        for (ServerRoleDefaultStartOption roleDefaultStart : roles) {
            String roleId = roleDefaultStart.getRoleId();
            if (roleIds.contains(roleId)) continue;
            roleIds.add(roleId);
        }
        return roleIds;
    }

    private void readDefaultStart(IConfigurationElement element) {
        ServerRoleDefaultStartOption.Trigger trigger;
        ServerRoleDefaultStartOption.Mode mode;
        String roleId = element.getAttribute(ATTR_ROLE_ID);
        if (StringUtils.isBlank((String)roleId)) {
            LOG.warn("Invalid defaultStart extension contributed by bundle {}: missing role id", (Object)element.getContributor().getName());
            return;
        }
        String modeStr = element.getAttribute(ATTR_MODE);
        if ("any".equals(modeStr)) {
            mode = ServerRoleDefaultStartOption.Mode.ANY;
        } else if ("development".equals(modeStr)) {
            mode = ServerRoleDefaultStartOption.Mode.DEVELOPMENT;
        } else if ("production".equals(modeStr)) {
            mode = ServerRoleDefaultStartOption.Mode.PRODUCTION;
        } else {
            LOG.warn("Invalid defaultStart extension contributed by bundle {}: missing/wrong mode", (Object)element.getContributor().getName());
            return;
        }
        String triggerStr = element.getAttribute(ATTR_TRIGGER);
        if ("onBoot".equals(triggerStr)) {
            trigger = ServerRoleDefaultStartOption.Trigger.ON_BOOT;
        } else if ("onCloudConnect".equals(triggerStr)) {
            trigger = ServerRoleDefaultStartOption.Trigger.ON_CLOUD_CONNECT;
        } else {
            LOG.warn("Invalid defaultStart extension contributed by bundle {}: missing/wrong trigger", (Object)element.getContributor().getName());
            return;
        }
        int startLevel = NumberUtils.toInt((String)element.getAttribute(ATTR_START_LEVEL), (int)0);
        String nodeFilter = StringUtils.trimToNull((String)element.getAttribute(ATTR_NODE_FILTER));
        this.defaultStartRoles.add(new ServerRoleDefaultStartOption(roleId, mode, trigger, startLevel, nodeFilter));
    }

    private void readRole(IConfigurationElement element) {
        String id = element.getAttribute(ATTR_ID);
        if (StringUtils.isBlank((String)id)) {
            LOG.warn("Invalid role extension contributed by bundle {}: missing role id", (Object)element.getContributor().getName());
            return;
        }
        String name = element.getAttribute(ATTR_NAME);
        IConfigurationElement[] requireBundleElements = element.getChildren(ELEM_REQUIRE_BUNDLE);
        ArrayList<String> requiredBundles = new ArrayList<String>(requireBundleElements.length);
        IConfigurationElement[] iConfigurationElementArray = requireBundleElements;
        int n = requireBundleElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement requireBundleElement = iConfigurationElementArray[n2];
            String bundleName = requireBundleElement.getAttribute(ATTR_SYMBOLIC_NAME);
            if (StringUtils.isBlank((String)bundleName)) {
                LOG.warn("Invalid role extension contributed by bundle {}: missing symbolic name", (Object)element.getContributor().getName());
                return;
            }
            requiredBundles.add(bundleName);
            ++n2;
        }
        IConfigurationElement[] requiredAppsElements = element.getChildren(ELEM_REQUIRE_APPLICATION);
        ArrayList<String> requiredApps = new ArrayList<String>(requiredAppsElements.length);
        IConfigurationElement[] iConfigurationElementArray2 = requiredAppsElements;
        int n3 = requiredAppsElements.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement requireAppElement = iConfigurationElementArray2[n4];
            String appId = requireAppElement.getAttribute(ATTR_APPLICATION_ID);
            if (StringUtils.isBlank((String)appId)) {
                LOG.warn("Invalid role extension contributed by bundle {}: missing application id", (Object)element.getContributor().getName());
                return;
            }
            requiredApps.add(appId);
            ++n4;
        }
        this.registeredRoles.put(id, new ServerRole(id, name, requiredBundles, requiredApps));
    }

    private void readServerRoles() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            throw new IllegalStateException("The Equinox extension registry is not available. Please check your installation. It may be corrupt.");
        }
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EP_SERVERROLES);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEM_ROLE.equals(element.getName())) {
                this.readRole(element);
            } else if (ELEM_DEFAULT_START.equals(element.getName())) {
                this.readDefaultStart(element);
            }
            ++n2;
        }
    }
}

