/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperGateConfig {
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperGateConfig.class);
    public static final String PREF_NODE_ZOOKEEPER = "zookeeper";
    public static final String PREF_KEY_CLIENT_CONNECT_STRING = "clientConnectString";
    public static final String PREF_KEY_CLIENT_TIMEOUT = "clientTimeout";
    private static final SystemSetting<Integer> defaultSessionTimeout = SystemSetting.newIntegerSetting((String)"gyrex.zookeeper.sessionTimeout", (String)"Default session timeout for the ZooKeeper client.").usingDefault((Object)30000).create();
    private static final SystemSetting<String> defaultConnectString = SystemSetting.newStringSetting((String)"gyrex.zookeeper.connectString", (String)"Default connect string for the ZooKeeper client.").usingDefault((Object)(Platform.inDevelopmentMode() ? "localhost:2181" : null)).create();
    private final String nodeId;
    private String connectString;
    private int sessionTimeout = 30000;

    public ZooKeeperGateConfig(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getConnectString() {
        return this.connectString;
    }

    private String getConnectStringFromPreferences() {
        return CloudActivator.getInstance().getPreferenceService().getString("org.eclipse.gyrex.cloud", "zookeeper/clientConnectString", (String)defaultConnectString.get(), null);
    }

    private int getDefaultSessionTimeout() {
        String sessionTimeoutValue = System.getProperty("gyrex.zookeeper.sessionTimeout");
        int sessionTimeout = (Integer)defaultSessionTimeout.get();
        if (sessionTimeout > 5000) {
            return sessionTimeout;
        }
        if (sessionTimeoutValue != null) {
            LOG.warn("ZooKeeper session timeout of {}ms (parsed from '{}') is too low. Using default {}ms.", new Object[]{sessionTimeout, sessionTimeoutValue, 30000});
        } else {
            LOG.warn("ZooKeeper session timeout of {}ms is too low. Using default {}ms.", (Object)sessionTimeout, (Object)30000);
        }
        return 30000;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    private int getSessionTimeoutFromPreferences() {
        return CloudActivator.getInstance().getPreferenceService().getInt("org.eclipse.gyrex.cloud", "zookeeper/clientTimeout", this.getDefaultSessionTimeout(), null);
    }

    public void readFromPreferences() {
        this.connectString = this.getConnectStringFromPreferences();
        if (this.connectString == null) {
            throw new IllegalStateException("Connect string not configured for node " + this.nodeId);
        }
        this.sessionTimeout = this.getSessionTimeoutFromPreferences();
        if (this.sessionTimeout < 5000) {
            throw new IllegalStateException("Session timeout too low for node " + this.nodeId);
        }
    }

    protected void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    protected void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.connectString).append(", sessionTimeout=").append(this.sessionTimeout).append("]");
        return builder.toString();
    }
}

