/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.internal.commands.BaseContextDefinitionCmd;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.kohsuke.args4j.Argument;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;

public class SetContextFilterCmd
extends BaseContextDefinitionCmd {
    @Argument(index=1, usage="type name of the class a filter applies to", required=true, metaVar="CLASS")
    String typeName;
    @Argument(index=2, usage="the filter (leave empty for unset)", required=false, metaVar="FILTER")
    String filter;

    public SetContextFilterCmd() {
        super("<path> <class> [<filter>] - sets or unsets a context filter");
    }

    @Override
    protected void doExecute(ContextDefinition contextDefinition) throws Exception {
        if (StringUtils.isNotBlank((String)this.filter)) {
            ServiceProxy.verifyFilterContainsObjectClassConditionForServiceInterface((String)this.typeName, (String)this.filter);
            Filter parsedFilter = FrameworkUtil.createFilter((String)this.filter);
            this.printf("succeddfully verified filter: %s", new Object[]{parsedFilter});
        }
        ContextConfiguration.setFilter(contextDefinition.getPath(), this.typeName, StringUtils.trimToNull((String)this.filter));
        this.printf("updated filter configuration", new Object[0]);
    }
}

