/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.di;

import java.lang.annotation.Annotation;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.IContextDisposalListener;
import org.eclipse.gyrex.context.internal.di.BaseContextObjectSupplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class GyrexContextObjectSupplier
extends BaseContextObjectSupplier {
    private final GyrexContextImpl contextImpl;

    public GyrexContextObjectSupplier(GyrexContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    @Override
    protected void addDisposable(IContextDisposalListener listener) {
        this.contextImpl.addDisposable(listener);
    }

    @Override
    protected Object getContextObject(Class<?> key) {
        if (key == null) {
            return null;
        }
        if (IRuntimeContext.class.equals(key)) {
            return this.contextImpl.getHandle();
        }
        return this.contextImpl.get(key);
    }

    @Override
    protected Object getQualifiedObject(Class<?> type, Annotation annotation) {
        return this.getQualifiedObjectFromExtendedObjectSupplier(type, annotation, this.contextImpl.getHandle());
    }

    @Override
    protected IServiceProxy<?> trackService(BundleContext bundleContext, Class<?> serviceInterface, String filter) throws InvalidSyntaxException {
        if (StringUtils.isNotBlank((String)filter)) {
            return this.contextImpl.getServiceLocator(bundleContext).trackService(serviceInterface, filter);
        }
        return this.contextImpl.getServiceLocator(bundleContext).trackService(serviceInterface);
    }
}

