/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.externalprocess;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;

public class AsyncLoggingInputStreamReader
extends Thread {
    private final Logger log;
    private final Level level;
    private final InputStream in;
    private volatile boolean closed;
    private volatile String lastLine;

    public AsyncLoggingInputStreamReader(String name, InputStream in, Logger log, Level level) throws IllegalArgumentException {
        super(name);
        if (in == null) {
            throw new IllegalArgumentException("input stream must not be null");
        }
        if (log == null) {
            throw new IllegalArgumentException("logger must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level must not be null");
        }
        this.in = in;
        this.log = log;
        this.level = level;
        this.setDaemon(true);
        this.closed = false;
        this.start();
    }

    public void close() {
        this.closed = true;
        IOUtils.closeQuietly((InputStream)this.in);
    }

    public String getLastLine() {
        return this.lastLine;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                block11: {
                    LineIterator li;
                    block10: {
                        li = IOUtils.lineIterator((InputStream)this.in, null);
                        if (!true) break block10;
                        if (this.closed) return;
                        if (!li.hasNext()) break block11;
                    }
                    do {
                        String line = this.lastLine = li.next();
                        switch (this.level) {
                            case ERROR: {
                                this.log.error(line);
                                break;
                            }
                            default: {
                                this.log.info(line);
                            }
                        }
                        if (this.closed) return;
                    } while (li.hasNext());
                }
                return;
            }
            catch (AssertionError | Exception | LinkageError e) {
                this.log.error("Unable to read from stream: {}", (Object)((Throwable)e).getMessage(), e);
                IOUtils.closeQuietly((InputStream)this.in);
                return;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.in);
        }
    }

    public static enum Level {
        INFO,
        ERROR;

    }
}

