/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.storage;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.IJobContext;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferencesCleanupJob;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPreferencesCleanupJobProvider
extends JobProvider {
    public static final String CLEANUP_JOB_TYPE = "org.eclipse.gyrex.jobs.system.cleanup.cloud";
    public static final String CLEANUP_JOB_ID = "org.eclipse.gyrex.jobs.system.cleanup.cloud";
    private static final Logger LOG = LoggerFactory.getLogger(CloudPreferencesCleanupJobProvider.class);
    private static AtomicLong lastCleanup = new AtomicLong();
    private static boolean preventAutomaticCleanup = Boolean.getBoolean("gyrex.jobs.cleanup.autotrigger.disabled");

    static void triggerCleanUp() {
        if (preventAutomaticCleanup) {
            return;
        }
        long last = lastCleanup.get();
        if (System.currentTimeMillis() - last > TimeUnit.HOURS.toMillis(3L) && lastCleanup.compareAndSet(last, System.currentTimeMillis())) {
            try {
                IRuntimeContext context = ((IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)Path.ROOT);
                if (context == null) {
                    throw new IllegalStateException("Root context not available!");
                }
                IJobManager jobManager = (IJobManager)context.get(IJobManager.class);
                if (jobManager == null) {
                    throw new IllegalStateException("Job manager not available!");
                }
                IJob cleanupJob = jobManager.getJob("org.eclipse.gyrex.jobs.system.cleanup.cloud");
                if (cleanupJob == null || cleanupJob.getState() == JobState.NONE) {
                    jobManager.queueJob("org.eclipse.gyrex.jobs.system.cleanup.cloud", "org.eclipse.gyrex.jobs.system.cleanup.cloud", null, null, "automatic cleanup triggered by " + ((INodeEnvironment)JobsActivator.getInstance().getService(INodeEnvironment.class)).getNodeId());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to queue job data cloud cleanup. Staring locally. {}", (Object)e.getMessage(), (Object)e);
                new CloudPreferencesCleanupJob().schedule();
            }
        }
    }

    public CloudPreferencesCleanupJobProvider() {
        super(Arrays.asList("org.eclipse.gyrex.jobs.system.cleanup.cloud"));
    }

    @Override
    public Job createJob(String typeId, IJobContext context) throws Exception {
        if (!"org.eclipse.gyrex.jobs.system.cleanup.cloud".equals(typeId)) {
            return null;
        }
        CloudPreferencesCleanupJob cleanupJob = new CloudPreferencesCleanupJob();
        String maxDaysSinceLastRunParam = context.getParameter().get("maxDaysSinceLastRun");
        if (StringUtils.isNotBlank((String)maxDaysSinceLastRunParam)) {
            int maxDaysSinceLastRun = NumberUtils.toInt((String)maxDaysSinceLastRunParam, (int)0);
            if (maxDaysSinceLastRun <= 0) {
                throw new IllegalArgumentException("Invalid value for parameter 'maxDaysSinceLastRun'. Please set it to a positiv integer greater than zero!");
            }
            cleanupJob.setMaxDaysSinceLastRun(maxDaysSinceLastRun);
        }
        return cleanupJob;
    }
}

