/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.mongodb.internal;

import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.persistence.storage.exceptions.ResourceFailureException;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbRegistry {
    public static final String PREF_KEY_URI = "uri";
    private final ConcurrentMap<String, MongoPool> mongoById = new ConcurrentHashMap<String, MongoPool>();
    private boolean stopped;
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbRegistry.class);

    public static void configurePool(String poolId, String uri) throws BackingStoreException {
        if (!IdHelper.isValidId((String)poolId)) {
            throw new IllegalArgumentException("invalid pool id; " + poolId);
        }
        Preferences node = MongoDbRegistry.getPoolsNode().node(poolId);
        node.put(PREF_KEY_URI, uri);
        node.flush();
    }

    public static Preferences getPoolsNode() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.persistence.mongodb").node("pools");
    }

    public static void removePool(String poolId) throws BackingStoreException {
        if (!IdHelper.isValidId((String)poolId)) {
            throw new IllegalArgumentException("invalid pool id; " + poolId);
        }
        Preferences node = MongoDbRegistry.getPoolsNode();
        if (node.nodeExists(poolId)) {
            node.node(poolId).removeNode();
            node.flush();
        }
    }

    private MongoPool createPool(String poolId) {
        Preferences node;
        block7: {
            try {
                node = MongoDbRegistry.getPoolsNode();
                if (node.nodeExists(poolId)) break block7;
                return null;
            }
            catch (BackingStoreException e) {
                throw new ResourceFailureException("Error loading pool. " + e.getMessage(), (Throwable)e);
            }
        }
        String uri = node.node(poolId).get(PREF_KEY_URI, null);
        if (uri == null) {
            throw new ResourceFailureException(String.format("No Mongo URI configured for pool '%s'.", poolId));
        }
        MongoPool mongoPool = new MongoPool();
        try {
            mongoPool.mongo = new Mongo(new MongoURI(uri));
        }
        catch (Exception e) {
            throw new ResourceFailureException("Error loading pool. " + e.getMessage(), (Throwable)e);
        }
        if (this.mongoById.putIfAbsent(poolId, mongoPool) != null) {
            mongoPool.mongo.close();
        }
        return (MongoPool)this.mongoById.get(poolId);
    }

    public Mongo get(String poolId) {
        if (!IdHelper.isValidId((String)poolId)) {
            throw new IllegalArgumentException("invalid pool id; " + poolId);
        }
        if (this.stopped) {
            throw new IllegalStateException("inactive");
        }
        MongoPool pool = (MongoPool)this.mongoById.get(poolId);
        if (pool == null && (pool = this.createPool(poolId)) == null) {
            return null;
        }
        pool.usageCount.incrementAndGet();
        return pool.mongo;
    }

    public void stop() {
        this.stopped = true;
        for (MongoPool mongo : this.mongoById.values()) {
            if (mongo.usageCount.get() > 0L) {
                LOG.warn("MongoDB pool '{}' still in use while closing.");
            }
            mongo.mongo.close();
        }
        this.mongoById.clear();
    }

    public void unget(String poolId) {
        if (!IdHelper.isValidId((String)poolId)) {
            throw new IllegalArgumentException("invalid pool id; " + poolId);
        }
        if (this.stopped) {
            throw new IllegalStateException("inactive");
        }
        MongoPool pool = (MongoPool)this.mongoById.get(poolId);
        if (pool != null && 0L == pool.usageCount.decrementAndGet() && this.mongoById.remove(poolId, pool)) {
            pool.mongo.close();
        }
    }

    static class MongoPool {
        Mongo mongo;
        final AtomicLong usageCount = new AtomicLong(0L);

        MongoPool() {
        }
    }
}

