/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.gyrex.preferences.internal.PreferencesActivator;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudScope
implements IScopeContext {
    private static final Logger LOG = LoggerFactory.getLogger(CloudScope.class);
    public static final String NAME = "cloud";
    public static final CloudScope INSTANCE = new CloudScope();
    private static volatile IEclipsePreferences cloudRootNode;

    private static Preferences getCloudScopeNode() {
        if (cloudRootNode == null) {
            int pass = 0;
            while (cloudRootNode == null) {
                ++pass;
                try {
                    PreferencesActivator.getInstance().getService(IExtensionRegistry.class);
                    cloudRootNode = (IEclipsePreferences)EclipsePreferencesUtil.getPreferencesService().getRootNode().node(NAME);
                }
                catch (IllegalStateException e) {
                    if (pass > 5) {
                        LOG.error("Unable to activating the cloud preferences scope. Please check the server logs and the server configuration. ", (Throwable)e);
                        throw e;
                    }
                    LOG.warn("Error while activating the cloud preferences scope. Will try again. (Pass {}) {}", (Object)pass, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
            }
        }
        return cloudRootNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IScopeContext)) {
            return false;
        }
        IScopeContext other = (IScopeContext)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        IPath location = this.getLocation();
        return location == null ? other.getLocation() == null : location.equals((Object)other.getLocation());
    }

    public IPath getLocation() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public IEclipsePreferences getNode(String qualifier) throws IllegalArgumentException, IllegalStateException {
        if (qualifier == null) {
            throw new IllegalArgumentException("qualifier must not be null");
        }
        return (IEclipsePreferences)CloudScope.getCloudScopeNode().node(qualifier);
    }

    public int hashCode() {
        return NAME.hashCode();
    }
}

