/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseCallMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TSuperMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticBaseCallSurrogate;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;
    public char[][][] allSuperDeclaringTypeNames;
    private char[][][] samePkgSuperDeclaringTypeNames;
    private MatchLocator matchLocator;
    private HashMap methodDeclarationsWithInvalidParam = new HashMap();

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    @Override
    protected void clear() {
        this.methodDeclarationsWithInvalidParam = new HashMap();
    }

    @Override
    protected int fineGrain() {
        return this.pattern.fineGrain;
    }

    private ReferenceBinding getMatchingSuper(ReferenceBinding binding) {
        if (binding == null) {
            return null;
        }
        ReferenceBinding superBinding = binding.superclass();
        int level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, superBinding);
        if (level != 0) {
            return superBinding;
        }
        if (!binding.isInterface() && !CharOperation.equals(binding.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (superBinding = this.getMatchingSuper(superBinding)) != null) {
            return superBinding;
        }
        ReferenceBinding[] interfaces = binding.superInterfaces();
        if (interfaces == null) {
            return null;
        }
        int i = 0;
        while (i < interfaces.length) {
            level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, interfaces[i]);
            if (level != 0) {
                return interfaces[i];
            }
            superBinding = this.getMatchingSuper(interfaces[i]);
            if (superBinding != null) {
                return superBinding;
            }
            ++i;
        }
        return null;
    }

    private MethodBinding getMethodBinding(ReferenceBinding type, char[] methodName, TypeBinding[] argumentTypes) {
        MethodBinding[] methods = type.getMethods(methodName);
        MethodBinding method = null;
        int i = 0;
        int length = methods.length;
        while (i < length) {
            block4: {
                method = methods[i];
                TypeBinding[] parameters = method.parameters;
                if (argumentTypes.length == parameters.length) {
                    int j = 0;
                    int l = parameters.length;
                    while (j < l) {
                        if (!TypeBinding.notEquals(parameters[j].erasure(), argumentTypes[j].erasure())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void initializePolymorphicSearch(MatchLocator locator) {
        long start = 0L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            SuperTypeNamesCollector namesCollector = new SuperTypeNamesCollector(this.pattern, this.pattern.declaringSimpleName, this.pattern.declaringQualification, locator, this.pattern.declaringType, locator.progressMonitor);
            this.allSuperDeclaringTypeNames = namesCollector.collect();
            this.samePkgSuperDeclaringTypeNames = namesCollector.getSamePackageSuperTypeNames();
            this.matchLocator = locator;
        }
        catch (JavaModelException javaModelException) {}
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Time to initialize polymorphic search: " + (System.currentTimeMillis() - start));
        }
    }

    private boolean isTypeInSuperDeclaringTypeNames(char[][] typeName) {
        if (this.allSuperDeclaringTypeNames == null) {
            return false;
        }
        int length = this.allSuperDeclaringTypeNames.length;
        int i = 0;
        while (i < length) {
            if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isVirtualInvoke(MethodBinding method, MessageSend messageSend) {
        return !method.isStatic() && (!method.isPrivate() || method.declaringClass.isRole() && messageSend.receiver.isImplicitThis()) && !(messageSend instanceof TSuperMessageSend) && !messageSend.isSuperAccess() && (!method.isDefault() || this.pattern.focus == null || CharOperation.equals(this.pattern.declaringPackageName, method.declaringClass.qualifiedPackageName()));
    }

    @Override
    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        int declarationsLevel = 0;
        if (this.pattern.findReferences && node instanceof ImportReference) {
            ImportReference importRef = (ImportReference)node;
            int length = importRef.tokens.length - 1;
            if (importRef.isStatic() && (importRef.bits & 0x20000) == 0 && this.matchesName(this.pattern.selector, importRef.tokens[length])) {
                char[][] compoundName = new char[length][];
                System.arraycopy(importRef.tokens, 0, compoundName, 0, length);
                char[] declaringType = CharOperation.concat(this.pattern.declaringQualification, this.pattern.declaringSimpleName, '.');
                if (this.matchesName(declaringType, CharOperation.concatWith(compoundName, '.'))) {
                    declarationsLevel = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return nodeSet.addMatch(node, declarationsLevel);
    }

    @Override
    public int match(LambdaExpression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null && this.pattern.parameterSimpleNames.length != node.arguments().length) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch(node, 2);
    }

    @Override
    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        boolean resolve = this.pattern.mustResolve;
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = MethodSignatureEnhancer.getSourceArguments(node);
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (args != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            nodeSet.mustResolve = true;
                            resolve = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(node, null);
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        if (this.pattern.hasMethodArguments() && (node.typeParameters == null || node.typeParameters.length != this.pattern.methodArguments.length)) {
            return 0;
        }
        return nodeSet.addMatch(node, resolve ? 2 : 3);
    }

    @Override
    public int match(MemberValuePair node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.name)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(MethodSpec methodSpec, MatchingNodeSet nodeSet) {
        if (!this.matchesName(this.pattern.selector, methodSpec.selector)) {
            return 0;
        }
        if (!methodSpec.hasSignature) {
            return nodeSet.addMatch(methodSpec, this.pattern.mustResolve ? 2 : 3);
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = methodSpec.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (!this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    return 0;
                }
                ++i;
            }
        }
        return nodeSet.addMatch(methodSpec, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(BaseCallMessageSend node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.sourceSelector)) {
            return 0;
        }
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (node.bits & 0x8000) == 0)) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = node.sourceArgs;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node._wrappee, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (node.bits & 0x8000) == 0)) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(ReferenceExpression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(Annotation node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        MemberValuePair[] pairs = node.memberValuePairs();
        if (pairs == null || pairs.length == 0) {
            return 0;
        }
        int length = pairs.length;
        MemberValuePair pair = null;
        int i = 0;
        while (i < length) {
            pair = node.memberValuePairs()[i];
            if (this.matchesName(this.pattern.selector, pair.name)) {
                ASTNode possibleNode = node instanceof SingleMemberAnnotation ? node : pair;
                return nodeSet.addMatch(possibleNode, this.pattern.mustResolve ? 2 : 3);
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 31;
        }
        return 2;
    }

    @Override
    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        if (importRef.isStatic() && binding instanceof MethodBinding) {
            super.matchLevelAndReportImportRef(importRef, binding, locator);
        }
    }

    protected int matchMethod(MethodBinding method, boolean skipImpossibleArg) {
        int parameterCount;
        int newLevel;
        if (!this.matchesName(this.pattern.selector, method.selector)) {
            return 0;
        }
        int level = 3;
        if (this.pattern.declaringSimpleName == null && level > (newLevel = this.resolveLevelForType(this.pattern.returnSimpleName, this.pattern.returnQualification, method.returnType))) {
            if (newLevel == 0) {
                return 0;
            }
            level = newLevel;
        }
        int n = parameterCount = this.pattern.parameterSimpleNames == null ? -1 : this.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.parameters == null) {
                return 1;
            }
            if (parameterCount != method.getSourceParamLength()) {
                return 0;
            }
            TypeBinding[] methodParamters = method.getSourceParameters();
            if (!method.isValidBinding() && ((ProblemMethodBinding)method).problemId() == 3) {
                return 1;
            }
            boolean foundTypeVariable = false;
            int i = 0;
            while (i < parameterCount) {
                TypeBinding argType = methodParamters[i];
                int newLevel2 = 0;
                newLevel2 = argType.isMemberType() ? (CharOperation.match(this.pattern.parameterSimpleNames[i], argType.sourceName(), this.isCaseSensitive) ? 3 : 0) : this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], argType);
                if (level > newLevel2) {
                    if (newLevel2 == 0) {
                        if (skipImpossibleArg) {
                            newLevel2 = level;
                        } else if (argType.isTypeVariable()) {
                            newLevel2 = level;
                            foundTypeVariable = true;
                        } else {
                            return 0;
                        }
                    }
                    level = newLevel2;
                }
                ++i;
            }
            if (foundTypeVariable) {
                MethodBinding focusMethodBinding;
                if (!method.isStatic() && !method.isPrivate() && (focusMethodBinding = this.matchLocator.getMethodBinding(this.pattern)) != null && this.matchOverriddenMethod(focusMethodBinding.declaringClass, focusMethodBinding, method)) {
                    return 3;
                }
                return 0;
            }
        }
        return level;
    }

    private boolean matchOverriddenMethod(ReferenceBinding type, MethodBinding method, MethodBinding matchMethod) {
        ReferenceBinding[] interfaces;
        if (type == null || this.pattern.selector == null) {
            return false;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT)) {
            ReferenceBinding superClass = type.superclass();
            if (superClass.isParameterizedType()) {
                MethodBinding[] methods = superClass.getMethods(this.pattern.selector);
                int length = methods.length;
                int i = 0;
                while (i < length) {
                    if (methods[i].areParametersEqual(method) && (matchMethod == null ? this.methodParametersEqualsPattern(methods[i].original()) : methods[i].original().areParametersEqual(matchMethod))) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.matchOverriddenMethod(superClass, method, matchMethod)) {
                return true;
            }
        }
        if ((interfaces = type.superInterfaces()) == null) {
            return false;
        }
        int iLength = interfaces.length;
        int i = 0;
        while (i < iLength) {
            if (interfaces[i].isParameterizedType()) {
                MethodBinding[] methods = interfaces[i].getMethods(this.pattern.selector);
                int length = methods.length;
                int j = 0;
                while (j < length) {
                    if (methods[j].areParametersEqual(method) && (matchMethod == null ? this.methodParametersEqualsPattern(methods[j].original()) : methods[j].original().areParametersEqual(matchMethod))) {
                        return true;
                    }
                    ++j;
                }
            }
            if (this.matchOverriddenMethod(interfaces[i], method, matchMethod)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, null, null, elementBinding, accuracy, locator);
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, IJavaElement localElement, IJavaElement[] otherElements, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = reference instanceof MessageSend ? ((MessageSend)reference).binding : (methodBinding = elementBinding instanceof MethodBinding ? (MethodBinding)elementBinding : null);
        if (methodBinding == null && reference instanceof MethodSpec && (this.pattern.findDecapsulationReferences || ((MethodSpec)reference).implementationStrategy == MethodSpec.ImplementationStrategy.DIRECT)) {
            methodBinding = ((MethodSpec)reference).resolvedMethod;
        }
        if (this.isDeclarationOfReferencedMethodsPattern) {
            if (methodBinding == null) {
                return;
            }
            if (accuracy != 0) {
                return;
            }
            DeclarationOfReferencedMethodsPattern declPattern = (DeclarationOfReferencedMethodsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                this.reportDeclaration(methodBinding, locator, declPattern.knownMethods);
            }
        } else {
            MethodReferenceMatch methodReferenceMatch = locator.newMethodReferenceMatch(element, elementBinding, accuracy, -1, -1, false, false, reference);
            methodReferenceMatch.setLocalElement(localElement);
            this.match = methodReferenceMatch;
            if (this.pattern.findReferences && reference instanceof MessageSend) {
                IJavaElement focus = this.pattern.focus;
                if (focus != null && focus.getElementType() == 9 && methodBinding != null && methodBinding.declaringClass != null) {
                    char[] declaringClassName;
                    boolean isPrivate = Flags.isPrivate(((IMethod)focus).getFlags());
                    ReferenceBinding mDeclaringClass = methodBinding.declaringClass;
                    char[] cArray = declaringClassName = mDeclaringClass.isAnonymousType() ? mDeclaringClass.sourceName : mDeclaringClass.sourceName();
                    if (isPrivate && !CharOperation.equals(declaringClassName, focus.getParent().getElementName().toCharArray())) {
                        return;
                    }
                }
                this.matchReportReference((MessageSend)reference, locator, accuracy, ((MessageSend)reference).binding);
            } else if (this.pattern.findReferences && reference instanceof MethodSpec) {
                MethodSpec methodSpec = (MethodSpec)reference;
                int offset = methodSpec.sourceStart;
                MethodReferenceMatch match = locator.newMethodReferenceMatch(element, elementBinding, accuracy, offset, methodSpec.declarationSourceEnd - offset + 1, false, false, reference);
                locator.report(match);
            } else {
                if (reference instanceof SingleMemberAnnotation) {
                    reference = ((SingleMemberAnnotation)reference).memberValuePairs()[0];
                    this.match.setImplicit(true);
                }
                int offset = reference instanceof ReferenceExpression ? ((ReferenceExpression)reference).nameSourceStart : reference.sourceStart;
                int length = reference.sourceEnd - offset + 1;
                this.match.setOffset(offset);
                this.match.setLength(length);
                locator.report(this.match);
            }
        }
    }

    void matchReportReference(MessageSend messageSend, MatchLocator locator, int accuracy, MethodBinding methodBinding) throws CoreException {
        boolean report;
        boolean isParameterized = false;
        if (methodBinding instanceof ParameterizedGenericMethodBinding) {
            isParameterized = true;
            ParameterizedGenericMethodBinding parameterizedMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            this.match.setRaw(parameterizedMethodBinding.isRaw);
            TypeBinding[] typeArguments = parameterizedMethodBinding.typeArguments;
            this.updateMatch(typeArguments, locator, this.pattern.methodArguments, this.pattern.hasMethodParameters());
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!(!this.pattern.hasTypeArguments() && this.pattern.hasMethodArguments() || parameterizedBinding.isParameterizedWithOwnVariables())) {
                    this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (methodBinding instanceof ParameterizedMethodBinding) {
            isParameterized = true;
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!parameterizedBinding.isParameterizedWithOwnVariables()) {
                    ReferenceBinding refBinding;
                    if ((accuracy & 0xC00) != 0 && (refBinding = this.getMatchingSuper((ReferenceBinding)messageSend.actualReceiverType)) instanceof ParameterizedTypeBinding) {
                        parameterizedBinding = (ParameterizedTypeBinding)refBinding;
                    }
                    if ((accuracy & 0x200) == 0) {
                        this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                    }
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (this.pattern.hasMethodArguments()) {
            this.match.setRule(16);
        }
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl = report = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!report) {
            return;
        }
        int offset = (int)(messageSend.nameSourcePosition >>> 32);
        this.match.setOffset(offset);
        this.match.setLength(messageSend.sourceEnd - offset + 1);
        if (isParameterized && this.pattern.hasMethodArguments()) {
            locator.reportAccurateParameterizedMethodReference(this.match, messageSend, messageSend.typeArguments);
        } else {
            locator.report(this.match);
        }
    }

    private boolean methodParametersEqualsPattern(MethodBinding method) {
        TypeBinding[] methodParameters = method.getSourceParameters();
        int length = methodParameters.length;
        if (length != this.pattern.parameterSimpleNames.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            char[] paramQualifiedName = MethodLocator.qualifiedPattern(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i]);
            if (!CharOperation.match(paramQualifiedName, methodParameters[i].readableName(), this.isCaseSensitive)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public SearchMatch newDeclarationMatch(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, int length, MatchLocator locator) {
        if (elementBinding != null) {
            MethodBinding methodBinding = (MethodBinding)elementBinding;
            if (this.methodDeclarationsWithInvalidParam.containsKey(reference)) {
                Boolean report = (Boolean)this.methodDeclarationsWithInvalidParam.get(reference);
                if (report != null) {
                    if (report.booleanValue()) {
                        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                    }
                    return null;
                }
                if (this.matchOverriddenMethod(methodBinding.declaringClass, methodBinding, null)) {
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                if (this.isTypeInSuperDeclaringTypeNames(methodBinding.declaringClass.compoundName)) {
                    MethodBinding patternBinding = locator.getMethodBinding(this.pattern);
                    if (patternBinding != null && !this.matchOverriddenMethod(patternBinding.declaringClass, patternBinding, methodBinding)) {
                        this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                        return null;
                    }
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                return null;
            }
        }
        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
    }

    @Override
    protected int referenceType() {
        return 9;
    }

    protected void reportDeclaration(MethodBinding methodBinding, MatchLocator locator, SimpleSet knownMethods) throws CoreException {
        TypeDeclaration typeDecl;
        AbstractMethodDeclaration methodDecl;
        ClassScope scope;
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        if (type.isBinary()) {
            IMethod method = null;
            TypeBinding[] parameters = methodBinding.original().getSourceParameters();
            int parameterLength = parameters.length;
            char[][] parameterTypes = new char[parameterLength][];
            int i = 0;
            while (i < parameterLength) {
                char[] typeName = parameters[i].qualifiedSourceName();
                int j = 0;
                int dim = parameters[i].dimensions();
                while (j < dim) {
                    typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                    ++j;
                }
                parameterTypes[i] = typeName;
                ++i;
            }
            method = locator.createBinaryMethodHandle(type, methodBinding.selector, parameterTypes);
            if (method == null || knownMethods.addIfNotIncluded(method) == null) {
                return;
            }
            IResource resource = type.getResource();
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            IBinaryType info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMemberDeclaration(resource, method, methodBinding, info, 0);
            return;
        }
        IResource resource = type.getResource();
        if (declaringClass instanceof ParameterizedTypeBinding) {
            declaringClass = ((ParameterizedTypeBinding)declaringClass).genericType();
        }
        if ((scope = ((SourceTypeBinding)declaringClass).scope) != null && (methodDecl = (typeDecl = scope.referenceContext).declarationOf(methodBinding.original())) != null) {
            String methodName = new String(methodBinding.selector);
            Argument[] arguments = methodDecl.arguments;
            int length = arguments == null ? 0 : arguments.length;
            String[] parameterTypes = new String[length];
            int i = 0;
            while (i < length) {
                char[][] typeName = arguments[i].type.getParameterizedTypeName();
                parameterTypes[i] = Signature.createTypeSignature(CharOperation.concatWith(typeName, '.'), false);
                ++i;
            }
            IMethod method = type.getMethod(methodName, parameterTypes);
            if (method == null || knownMethods.addIfNotIncluded(method) == null) {
                return;
            }
            int offset = methodDecl.sourceStart;
            this.match = new MethodDeclarationMatch(method, 0, offset, methodDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
            locator.report(this.match);
        }
    }

    @Override
    public int resolveLevel(ASTNode possibleMatchingNode) {
        if (this.pattern.findReferences) {
            if (possibleMatchingNode instanceof MessageSend) {
                return this.resolveLevel((MessageSend)possibleMatchingNode);
            }
            if (possibleMatchingNode instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation annotation = (SingleMemberAnnotation)possibleMatchingNode;
                return this.resolveLevel(annotation.memberValuePairs()[0].binding);
            }
            if (possibleMatchingNode instanceof MemberValuePair) {
                MemberValuePair memberValuePair = (MemberValuePair)possibleMatchingNode;
                return this.resolveLevel(memberValuePair.binding);
            }
            if (possibleMatchingNode instanceof ReferenceExpression) {
                return this.resolveLevel((ReferenceExpression)possibleMatchingNode);
            }
            if (possibleMatchingNode instanceof MethodSpec) {
                if (this.pattern.constrainToCallerDirection && ((MethodSpec)possibleMatchingNode).isDeclaration) {
                    return 0;
                }
                return this.resolveLevel(((MethodSpec)possibleMatchingNode).resolvedMethod);
            }
        }
        if (this.pattern.findDeclarations) {
            if (possibleMatchingNode instanceof MethodDeclaration) {
                return this.resolveLevel(((MethodDeclaration)possibleMatchingNode).binding);
            }
            if (possibleMatchingNode instanceof LambdaExpression) {
                return this.resolveLevel(((LambdaExpression)possibleMatchingNode).descriptor);
            }
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        boolean subType;
        boolean skipVerif;
        int methodLevel;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        if (binding instanceof ProblemMethodBinding && !binding.isValidBinding()) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        if (method.parameters != null) {
            TypeBinding[] paramTypes = method.parameters;
            int idx = 0;
            while (idx < paramTypes.length) {
                MemberTypeBinding type;
                if (paramTypes[idx] instanceof MemberTypeBinding && (type = (MemberTypeBinding)paramTypes[idx]).isRole()) {
                    method = method.copyInheritanceSrc;
                    break;
                }
                ++idx;
            }
        }
        if ((methodLevel = this.matchMethod(method, skipVerif = this.pattern.findDeclarations && this.mayBeGeneric)) == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), skipVerif);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return methodLevel;
        }
        boolean bl = subType = !method.isStatic() && !method.isPrivate();
        if (subType && this.pattern.declaringQualification != null && method.declaringClass != null && method.declaringClass.fPackage != null) {
            subType = CharOperation.compareWith(this.pattern.declaringQualification, method.declaringClass.fPackage.shortReadableName()) == 0;
        }
        int declaringLevel = subType ? this.resolveLevelAsSubtype(this.pattern.declaringSimpleName, this.pattern.declaringQualification, method.declaringClass, method.selector, null, method.declaringClass.qualifiedPackageName(), method.isDefault()) : this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, method.declaringClass);
        return (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(MessageSend messageSend) {
        int declaringLevel;
        MethodBinding method = messageSend.binding;
        if (method instanceof SyntheticBaseCallSurrogate) {
            method = ((SyntheticBaseCallSurrogate)method).targetMethod;
        }
        if (method == null) {
            return 1;
        }
        if (messageSend.resolvedType == null) {
            int argLength;
            int n = argLength = messageSend.arguments == null ? 0 : messageSend.arguments.length;
            if (this.pattern.parameterSimpleNames == null || argLength == this.pattern.parameterSimpleNames.length) {
                return 1;
            }
            return 0;
        }
        int methodLevel = this.matchMethod(method, false);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), false);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return methodLevel;
        }
        if (this.isVirtualInvoke(method, messageSend) && messageSend.actualReceiverType instanceof ReferenceBinding) {
            ReferenceBinding methodReceiverType = (ReferenceBinding)messageSend.actualReceiverType;
            CalloutMappingDeclaration callout = MethodModel.getImplementingInferredCallout(messageSend.binding);
            if (callout != null) {
                methodReceiverType = callout.getImplementationMethodSpec().getDeclaringClass();
            }
            if ((declaringLevel = this.resolveLevelAsSubtype(this.pattern.declaringSimpleName, this.pattern.declaringQualification, methodReceiverType, method.selector, method.parameters, methodReceiverType.qualifiedPackageName(), method.isDefault())) == 0) {
                if (method.declaringClass == null || this.allSuperDeclaringTypeNames == null) {
                    declaringLevel = 1;
                } else {
                    char[][][] superTypeNames;
                    char[][][] cArray = superTypeNames = method.isDefault() && this.pattern.focus == null ? this.samePkgSuperDeclaringTypeNames : this.allSuperDeclaringTypeNames;
                    if (superTypeNames != null && this.resolveLevelAsSuperInvocation(methodReceiverType, method.parameters, superTypeNames, true)) {
                        declaringLevel = methodLevel | 0x200;
                    }
                }
            }
            if ((declaringLevel & 0xFFFFFFF0) != 0) {
                return declaringLevel;
            }
        } else {
            char[] patternDeclaringQualification = this.pattern.getDeclaringQualification();
            ReferenceBinding declaringClass = method.declaringClass;
            CalloutMappingDeclaration callout = MethodModel.getImplementingInferredCallout(messageSend.binding);
            if (callout != null) {
                declaringClass = callout.getImplementationMethodSpec().getDeclaringClass();
            }
            declaringLevel = this.resolveLevelForType(this.pattern.declaringSimpleName, patternDeclaringQualification, declaringClass);
        }
        return (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(ReferenceExpression referenceExpression) {
        MethodBinding method = referenceExpression.getMethodBinding();
        if (method == null || !method.isValidBinding()) {
            return 1;
        }
        int methodLevel = this.matchMethod(method, false);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), false);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return methodLevel;
        }
        int declaringLevel = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, method.declaringClass);
        return (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
    }

    protected int resolveLevelAsSubtype(char[] simplePattern, char[] qualifiedPattern, ReferenceBinding type, char[] methodName, TypeBinding[] argumentTypes, char[] packageName, boolean isDefault) {
        ReferenceBinding[] interfaces;
        MethodBinding method;
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(simplePattern, qualifiedPattern, type);
        if (level != 0) {
            char[] typeName = type.getRealType().readableName();
            level = this.pattern.resolveLevelForType(new String(typeName), level);
        }
        if (level != 0) {
            if (isDefault && !CharOperation.equals(packageName, type.qualifiedPackageName())) {
                return 0;
            }
            MethodBinding methodBinding = method = argumentTypes == null ? null : this.getMethodBinding(type, methodName, argumentTypes);
            if (!((method == null || method.isAbstract()) && type.isAbstract() || type.isInterface())) {
                level |= 0x800;
            }
            return level;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, type.superclass(), methodName, argumentTypes, packageName, isDefault)) != 0) {
            if (argumentTypes != null && (method = this.getMethodBinding(type, methodName, argumentTypes)) != null) {
                if ((level & 0x800) != 0) {
                    return 0;
                }
                if (!method.isAbstract() && !type.isInterface()) {
                    level |= 0x800;
                }
            }
            return level | 0x400;
        }
        RoleModel roleModel = type.roleModel;
        if (type.roleModel != null) {
            ReferenceBinding[] tsuperTypes = roleModel.getTSuperRoleBindings();
            int t = tsuperTypes.length - 1;
            while (t >= 0) {
                level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, tsuperTypes[t], methodName, argumentTypes, packageName, isDefault);
                if (level != 0) {
                    if (argumentTypes != null) {
                        MethodBinding[] methods = type.getMethods(this.pattern.selector);
                        int i = 0;
                        int length = methods.length;
                        while (i < length) {
                            TypeBinding[] parameters;
                            MethodBinding method2 = methods[i];
                            if (method2.copyInheritanceSrc == null && argumentTypes.length == (parameters = method2.parameters).length) {
                                boolean found = true;
                                int j = 0;
                                int l = parameters.length;
                                while (j < l) {
                                    if (TypeBinding.notEquals(parameters[j].erasure(), argumentTypes[j].erasure())) {
                                        found = false;
                                        break;
                                    }
                                    ++j;
                                }
                                if (found) {
                                    if ((level & 0x800) != 0) {
                                        return 0;
                                    }
                                    if (!method2.isAbstract() && !type.isInterface()) {
                                        level |= 0x800;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    return level | 0x400;
                }
                --t;
            }
        }
        if ((interfaces = type.superInterfaces()) == null) {
            return 1;
        }
        int i = 0;
        while (i < interfaces.length) {
            level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, interfaces[i], methodName, null, packageName, isDefault);
            if (level != 0) {
                if (!type.isAbstract() && !type.isInterface()) {
                    level |= 0x800;
                }
                return level | 0x400;
            }
            ++i;
        }
        return 0;
    }

    private boolean resolveLevelAsSuperInvocation(ReferenceBinding type, TypeBinding[] argumentTypes, char[][][] superTypeNames, boolean methodAlreadyVerified) {
        char[][] compoundName = type.compoundName;
        int i = 0;
        int max = superTypeNames.length;
        while (i < max) {
            if (CharOperation.equals(superTypeNames[i], compoundName)) {
                if (methodAlreadyVerified) {
                    return true;
                }
                MethodBinding[] methods = type.getMethods(this.pattern.selector);
                int j = 0;
                int length = methods.length;
                while (j < length) {
                    MethodBinding method = methods[j];
                    TypeBinding[] parameters = method.parameters;
                    if (argumentTypes.length == parameters.length) {
                        boolean found = true;
                        int k = 0;
                        int l = parameters.length;
                        while (k < l) {
                            if (TypeBinding.notEquals(parameters[k].erasure(), argumentTypes[k].erasure())) {
                                found = false;
                                break;
                            }
                            ++k;
                        }
                        if (found) {
                            return true;
                        }
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (type.isInterface()) {
            ReferenceBinding[] interfaces = type.superInterfaces();
            if (interfaces == null) {
                return false;
            }
            int i2 = 0;
            while (i2 < interfaces.length) {
                if (this.resolveLevelAsSuperInvocation(interfaces[i2], argumentTypes, superTypeNames, false)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

