/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletSecurityElement;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Servlet Handler")
public class ServletHandler
extends ScopedHandler {
    private static final Logger LOG = Log.getLogger(ServletHandler.class);
    public static final String __DEFAULT_SERVLET = "default";
    private ServletContextHandler _contextHandler;
    private ServletContext _servletContext;
    private FilterHolder[] _filters = new FilterHolder[0];
    private FilterMapping[] _filterMappings;
    private int _matchBeforeIndex = -1;
    private int _matchAfterIndex = -1;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 512;
    private boolean _startWithUnavailable = false;
    private boolean _ensureDefaultServlet = true;
    private IdentityService _identityService;
    private ServletHolder[] _servlets = new ServletHolder[0];
    private ServletMapping[] _servletMappings;
    private final Map<String, FilterHolder> _filterNameMap = new HashMap<String, FilterHolder>();
    private List<FilterMapping> _filterPathMappings;
    private MultiMap<FilterMapping> _filterNameMappings;
    private final Map<String, ServletHolder> _servletNameMap = new HashMap<String, ServletHolder>();
    private PathMap<ServletHolder> _servletPathMap;
    private ListenerHolder[] _listeners = new ListenerHolder[0];
    protected final ConcurrentMap<String, FilterChain>[] _chainCache = new ConcurrentMap[31];
    protected final Queue<String>[] _chainLRU = new Queue[31];

    protected synchronized void doStart() throws Exception {
        SecurityHandler security_handler;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        this._servletContext = context == null ? new ContextHandler.NoContext() : context;
        this._contextHandler = (ServletContextHandler)(context == null ? null : context.getContextHandler());
        if (this._contextHandler != null && (security_handler = (SecurityHandler)this._contextHandler.getChildHandlerByClass(SecurityHandler.class)) != null) {
            this._identityService = security_handler.getIdentityService();
        }
        this.updateNameMappings();
        this.updateMappings();
        if (this.getServletMapping("/") == null && this._ensureDefaultServlet) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Default404Servlet to {}", new Object[]{this});
            }
            this.addServletWithMapping(Default404Servlet.class, "/");
            this.updateMappings();
            this.getServletMapping("/").setDefault(true);
        }
        if (this._filterChainsCached) {
            this._chainCache[1] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[2] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[4] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[8] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[16] = new ConcurrentHashMap<String, FilterChain>();
            this._chainLRU[1] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[2] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[4] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[8] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[16] = new ConcurrentLinkedQueue<String>();
        }
        if (this._contextHandler == null) {
            this.initialize();
        }
        super.doStart();
    }

    public boolean isEnsureDefaultServlet() {
        return this._ensureDefaultServlet;
    }

    public void setEnsureDefaultServlet(boolean ensureDefaultServlet) {
        this._ensureDefaultServlet = ensureDefaultServlet;
    }

    protected void start(LifeCycle l) throws Exception {
        if (!(l instanceof Holder)) {
            super.start(l);
        }
    }

    protected synchronized void doStop() throws Exception {
        super.doStop();
        ArrayList<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        List filterMappings = ArrayUtil.asMutableList((Object[])this._filterMappings);
        if (this._filters != null) {
            int i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
                if (this._filters[i].getSource() != BaseHolder.Source.EMBEDDED) {
                    this._filterNameMap.remove(this._filters[i].getName());
                    ListIterator fmitor = filterMappings.listIterator();
                    while (fmitor.hasNext()) {
                        FilterMapping fm = (FilterMapping)fmitor.next();
                        if (!fm.getFilterName().equals(this._filters[i].getName())) continue;
                        fmitor.remove();
                    }
                    continue;
                }
                filterHolders.add(this._filters[i]);
            }
        }
        FilterHolder[] fhs = (FilterHolder[])LazyList.toArray(filterHolders, FilterHolder.class);
        this.updateBeans((Object[])this._filters, (Object[])fhs);
        this._filters = fhs;
        Object[] fms = (FilterMapping[])LazyList.toArray((Object)filterMappings, FilterMapping.class);
        this.updateBeans(this._filterMappings, fms);
        this._filterMappings = fms;
        this._matchAfterIndex = this._filterMappings == null || this._filterMappings.length == 0 ? -1 : this._filterMappings.length - 1;
        this._matchBeforeIndex = -1;
        ArrayList<ServletHolder> servletHolders = new ArrayList<ServletHolder>();
        List servletMappings = ArrayUtil.asMutableList((Object[])this._servletMappings);
        if (this._servlets != null) {
            int i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
                if (this._servlets[i].getSource() != BaseHolder.Source.EMBEDDED) {
                    this._servletNameMap.remove(this._servlets[i].getName());
                    ListIterator smitor = servletMappings.listIterator();
                    while (smitor.hasNext()) {
                        ServletMapping sm = (ServletMapping)smitor.next();
                        if (!sm.getServletName().equals(this._servlets[i].getName())) continue;
                        smitor.remove();
                    }
                    continue;
                }
                servletHolders.add(this._servlets[i]);
            }
        }
        Object[] shs = (ServletHolder[])LazyList.toArray(servletHolders, ServletHolder.class);
        this.updateBeans(this._servlets, shs);
        this._servlets = shs;
        Object[] sms = (ServletMapping[])LazyList.toArray((Object)servletMappings, ServletMapping.class);
        this.updateBeans(this._servletMappings, sms);
        this._servletMappings = sms;
        ArrayList<ListenerHolder> listenerHolders = new ArrayList<ListenerHolder>();
        if (this._listeners != null) {
            int i = this._listeners.length;
            while (i-- > 0) {
                try {
                    this._listeners[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
                if (this._listeners[i].getSource() != BaseHolder.Source.EMBEDDED) continue;
                listenerHolders.add(this._listeners[i]);
            }
        }
        ListenerHolder[] listeners = (ListenerHolder[])LazyList.toArray(listenerHolders, ListenerHolder.class);
        this.updateBeans((Object[])this._listeners, (Object[])listeners);
        this._listeners = listeners;
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
    }

    protected IdentityService getIdentityService() {
        return this._identityService;
    }

    public Object getContextLog() {
        return null;
    }

    @ManagedAttribute(value="filters", readonly=true)
    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    @ManagedAttribute(value="filters", readonly=true)
    public FilterHolder[] getFilters() {
        return this._filters;
    }

    public PathMap.MappedEntry<ServletHolder> getHolderEntry(String pathInContext) {
        if (this._servletPathMap == null) {
            return null;
        }
        return this._servletPathMap.getMatch(pathInContext);
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    @ManagedAttribute(value="mappings of servlets", readonly=true)
    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletMapping getServletMapping(String pathSpec) {
        if (pathSpec == null || this._servletMappings == null) {
            return null;
        }
        ServletMapping mapping = null;
        block0: for (int i = 0; i < this._servletMappings.length && mapping == null; ++i) {
            ServletMapping m = this._servletMappings[i];
            if (m.getPathSpecs() == null) continue;
            for (String p : m.getPathSpecs()) {
                if (!pathSpec.equals(p)) continue;
                mapping = m;
                continue block0;
            }
        }
        return mapping;
    }

    @ManagedAttribute(value="servlets", readonly=true)
    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    public ServletHolder getServlet(String name) {
        return this._servletNameMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = null;
        UserIdentity.Scope old_scope = null;
        if (target.startsWith("/")) {
            PathMap.MappedEntry<ServletHolder> entry = this.getHolderEntry(target);
            if (entry != null) {
                servlet_holder = (ServletHolder)entry.getValue();
                String servlet_path_spec = entry.getKey();
                String servlet_path = entry.getMapped() != null ? entry.getMapped() : PathMap.pathMatch((String)servlet_path_spec, (String)target);
                String path_info = PathMap.pathInfo((String)servlet_path_spec, (String)target);
                if (DispatcherType.INCLUDE.equals((Object)type)) {
                    baseRequest.setAttribute("javax.servlet.include.servlet_path", (Object)servlet_path);
                    baseRequest.setAttribute("javax.servlet.include.path_info", (Object)path_info);
                } else {
                    baseRequest.setServletPath(servlet_path);
                    baseRequest.setPathInfo(path_info);
                }
            }
        } else {
            servlet_holder = this._servletNameMap.get(target);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("servlet {}|{}|{} -> {}", new Object[]{baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), servlet_holder});
        }
        try {
            old_scope = baseRequest.getUserIdentityScope();
            baseRequest.setUserIdentityScope((UserIdentity.Scope)servlet_holder);
            if (this.never()) {
                this.nextScope(target, baseRequest, request, response);
            } else if (this._nextScope != null) {
                this._nextScope.doScope(target, baseRequest, request, response);
            } else if (this._outerScope != null) {
                this._outerScope.doHandle(target, baseRequest, request, response);
            } else {
                this.doHandle(target, baseRequest, request, response);
            }
        }
        finally {
            if (old_scope != null) {
                baseRequest.setUserIdentityScope(old_scope);
            }
            if (!DispatcherType.INCLUDE.equals((Object)type)) {
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block45: {
            DispatcherType type = baseRequest.getDispatcherType();
            ServletHolder servlet_holder = (ServletHolder)baseRequest.getUserIdentityScope();
            FilterChain chain = null;
            if (target.startsWith("/")) {
                if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                    chain = this.getFilterChain(baseRequest, target, servlet_holder);
                }
            } else if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                chain = this.getFilterChain(baseRequest, null, servlet_holder);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("chain={}", new Object[]{chain});
            }
            Throwable th = null;
            try {
                if (servlet_holder == null) {
                    this.notFound(baseRequest, request, response);
                } else {
                    HttpServletResponse res;
                    HttpServletRequest req = request;
                    if (req instanceof ServletRequestHttpWrapper) {
                        req = ((ServletRequestHttpWrapper)req).getRequest();
                    }
                    if ((res = response) instanceof ServletResponseHttpWrapper) {
                        res = ((ServletResponseHttpWrapper)res).getResponse();
                    }
                    if (chain != null) {
                        chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    } else {
                        servlet_holder.handle(baseRequest, (ServletRequest)req, (ServletResponse)res);
                    }
                }
            }
            catch (EofException e) {
                throw e;
            }
            catch (RuntimeIOException e) {
                throw e;
            }
            catch (Exception e) {
                if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof ServletException) {
                        throw (ServletException)e;
                    }
                }
                if ((th = e) instanceof ServletException) {
                    if (th instanceof QuietServletException) {
                        LOG.warn(th.toString(), new Object[0]);
                        LOG.debug(th);
                    } else {
                        LOG.warn(th);
                    }
                } else {
                    if (th instanceof EofException) {
                        throw (EofException)th;
                    }
                    LOG.warn(request.getRequestURI(), th);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(request.toString(), new Object[0]);
                    }
                }
                request.setAttribute("javax.servlet.error.exception_type", th.getClass());
                request.setAttribute("javax.servlet.error.exception", (Object)th);
                if (!response.isCommitted()) {
                    baseRequest.getResponse().getHttpFields().put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    if (th instanceof UnavailableException) {
                        UnavailableException ue = (UnavailableException)th;
                        if (ue.isPermanent()) {
                            response.sendError(404);
                        } else {
                            response.sendError(503);
                        }
                    } else {
                        response.sendError(500);
                    }
                    break block45;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof ServletException) {
                    throw (ServletException)th;
                }
                throw new IllegalStateException("response already committed", th);
            }
            catch (Error e) {
                if ("ContinuationThrowable".equals(e.getClass().getSimpleName())) {
                    throw e;
                }
                th = e;
                if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                    throw e;
                }
                LOG.warn("Error for " + request.getRequestURI(), (Throwable)e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(request.toString(), new Object[0]);
                }
                request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                request.setAttribute("javax.servlet.error.exception", (Object)e);
                if (!response.isCommitted()) {
                    baseRequest.getResponse().getHttpFields().put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    response.sendError(500);
                } else {
                    LOG.debug("Response already committed for handling ", (Throwable)e);
                }
            }
            finally {
                if (th != null && request.isAsyncStarted()) {
                    baseRequest.getHttpChannelState().errorComplete();
                }
                if (servlet_holder != null) {
                    baseRequest.setHandled(true);
                }
            }
        }
    }

    protected FilterChain getFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        FilterChain chain;
        String key = pathInContext == null ? servletHolder.getName() : pathInContext;
        int dispatch = FilterMapping.dispatch(baseRequest.getDispatcherType());
        if (this._filterChainsCached && this._chainCache != null && (chain = (FilterChain)this._chainCache[dispatch].get(key)) != null) {
            return chain;
        }
        ArrayList<FilterHolder> filters = new ArrayList<FilterHolder>();
        if (pathInContext != null && this._filterPathMappings != null) {
            for (FilterMapping filterPathMapping : this._filterPathMappings) {
                if (!filterPathMapping.appliesTo(pathInContext, dispatch)) continue;
                filters.add(filterPathMapping.getFilterHolder());
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0 && this._filterNameMappings.size() > 0) {
            FilterMapping mapping;
            int i;
            Object o = this._filterNameMappings.get((Object)servletHolder.getName());
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters.add(mapping.getFilterHolder());
            }
            o = this._filterNameMappings.get((Object)"*");
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters.add(mapping.getFilterHolder());
            }
        }
        if (filters.isEmpty()) {
            return null;
        }
        Object chain2 = null;
        if (this._filterChainsCached) {
            if (filters.size() > 0) {
                chain2 = new CachedChain(filters, servletHolder);
            }
            ConcurrentMap<String, FilterChain> cache = this._chainCache[dispatch];
            Queue<String> lru = this._chainLRU[dispatch];
            while (this._maxFilterChainsCacheSize > 0 && cache.size() >= this._maxFilterChainsCacheSize) {
                String k = lru.poll();
                if (k == null) {
                    cache.clear();
                    break;
                }
                cache.remove(k);
            }
            cache.put(key, (FilterChain)chain2);
            lru.add(key);
        } else if (filters.size() > 0) {
            chain2 = new Chain(baseRequest, filters, servletHolder);
        }
        return chain2;
    }

    protected void invalidateChainsCache() {
        if (this._chainLRU[1] != null) {
            this._chainLRU[1].clear();
            this._chainLRU[2].clear();
            this._chainLRU[4].clear();
            this._chainLRU[8].clear();
            this._chainLRU[16].clear();
            this._chainCache[1].clear();
            this._chainCache[2].clear();
            this._chainCache[4].clear();
            this._chainCache[8].clear();
            this._chainCache[16].clear();
        }
    }

    public boolean isAvailable() {
        ServletHolder[] holders;
        if (!this.isStarted()) {
            return false;
        }
        for (ServletHolder holder : holders = this.getServlets()) {
            if (holder == null || holder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void setStartWithUnavailable(boolean start) {
        this._startWithUnavailable = start;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this._filters != null) {
            for (FilterHolder f : this._filters) {
                try {
                    f.start();
                    f.initialize();
                }
                catch (Exception e) {
                    mx.add((Throwable)e);
                }
            }
        }
        if (this._servlets != null) {
            Object[] servlets = (ServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (Object servlet : servlets) {
                try {
                    servlet.start();
                    ((ServletHolder)servlet).initialize();
                }
                catch (Throwable e) {
                    LOG.debug("EXCEPTION ", e);
                    mx.add(e);
                }
            }
        }
        for (Holder h : this.getBeans(Holder.class)) {
            try {
                if (h.isStarted()) continue;
                h.start();
                h.initialize();
            }
            catch (Exception e) {
                mx.add((Throwable)e);
            }
        }
        mx.ifExceptionThrow();
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public void addListener(ListenerHolder listener) {
        if (listener != null) {
            this.setListeners((ListenerHolder[])ArrayUtil.addToArray((Object[])this.getListeners(), (Object)((Object)listener), ListenerHolder.class));
        }
    }

    public ListenerHolder[] getListeners() {
        return this._listeners;
    }

    public void setListeners(ListenerHolder[] listeners) {
        if (listeners != null) {
            for (ListenerHolder holder : listeners) {
                holder.setServletHandler(this);
            }
        }
        this.updateBeans((Object[])this._listeners, (Object[])listeners);
        this._listeners = listeners;
    }

    public ListenerHolder newListenerHolder(BaseHolder.Source source) {
        return new ListenerHolder(source);
    }

    public ServletHolder newServletHolder(BaseHolder.Source source) {
        return new ServletHolder(source);
    }

    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        ServletHolder holder = this.newServletHolder(BaseHolder.Source.EMBEDDED);
        holder.setClassName(className);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public ServletHolder addServletWithMapping(Class<? extends Servlet> servlet, String pathSpec) {
        ServletHolder holder = this.newServletHolder(BaseHolder.Source.EMBEDDED);
        holder.setHeldClass(servlet);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        Object[] holders = this.getServlets();
        if (holders != null) {
            holders = (ServletHolder[])holders.clone();
        }
        try {
            this.setServlets((ServletHolder[])ArrayUtil.addToArray((Object[])holders, (Object)servlet, ServletHolder.class));
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpec(pathSpec);
            this.setServletMappings((ServletMapping[])ArrayUtil.addToArray((Object[])this.getServletMappings(), (Object)mapping, ServletMapping.class));
        }
        catch (Exception e) {
            this.setServlets((ServletHolder[])holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void addServlet(ServletHolder holder) {
        this.setServlets((ServletHolder[])ArrayUtil.addToArray((Object[])this.getServlets(), (Object)holder, ServletHolder.class));
    }

    public void addServletMapping(ServletMapping mapping) {
        this.setServletMappings((ServletMapping[])ArrayUtil.addToArray((Object[])this.getServletMappings(), (Object)mapping, ServletMapping.class));
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        if (this._contextHandler != null) {
            return this._contextHandler.setServletSecurity(registration, servletSecurityElement);
        }
        return Collections.emptySet();
    }

    public FilterHolder newFilterHolder(BaseHolder.Source source) {
        return new FilterHolder(source);
    }

    public FilterHolder getFilter(String name) {
        return this._filterNameMap.get(name);
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder holder = this.newFilterHolder(BaseHolder.Source.EMBEDDED);
        holder.setHeldClass(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder holder = this.newFilterHolder(BaseHolder.Source.EMBEDDED);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatcherTypes(dispatches);
            this.addFilterMapping(mapping);
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(BaseHolder.Source.EMBEDDED);
        holder.setHeldClass(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(BaseHolder.Source.EMBEDDED);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatches(dispatches);
            this.addFilterMapping(mapping);
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilter(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.addFilterWithMapping(className, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            this.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])this.getFilters(), (Object)((Object)filter), FilterHolder.class));
        }
        if (filterMapping != null) {
            this.addFilterMapping(filterMapping);
        }
    }

    public void addFilter(FilterHolder filter) {
        if (filter != null) {
            this.setFilters((FilterHolder[])ArrayUtil.addToArray((Object[])this.getFilters(), (Object)((Object)filter), FilterHolder.class));
        }
    }

    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            BaseHolder.Source source = mapping.getFilterHolder() == null ? null : mapping.getFilterHolder().getSource();
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                this.setFilterMappings(this.insertFilterMapping(mapping, 0, false));
                if (source != null && source == BaseHolder.Source.JAVAX_API) {
                    this._matchAfterIndex = 0;
                }
            } else if (source != null && BaseHolder.Source.JAVAX_API == source) {
                this.setFilterMappings(this.insertFilterMapping(mapping, mappings.length - 1, false));
                if (this._matchAfterIndex < 0) {
                    this._matchAfterIndex = this.getFilterMappings().length - 1;
                }
            } else if (this._matchAfterIndex < 0) {
                this.setFilterMappings(this.insertFilterMapping(mapping, mappings.length - 1, false));
            } else {
                FilterMapping[] new_mappings = this.insertFilterMapping(mapping, this._matchAfterIndex, true);
                ++this._matchAfterIndex;
                this.setFilterMappings(new_mappings);
            }
        }
    }

    public void prependFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            BaseHolder.Source source = mapping.getFilterHolder().getSource();
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                this.setFilterMappings(this.insertFilterMapping(mapping, 0, false));
                if (source != null && BaseHolder.Source.JAVAX_API == source) {
                    this._matchBeforeIndex = 0;
                }
            } else {
                if (source != null && BaseHolder.Source.JAVAX_API == source) {
                    if (this._matchBeforeIndex < 0) {
                        this._matchBeforeIndex = 0;
                        FilterMapping[] new_mappings = this.insertFilterMapping(mapping, 0, true);
                        this.setFilterMappings(new_mappings);
                    } else {
                        FilterMapping[] new_mappings = this.insertFilterMapping(mapping, this._matchBeforeIndex, false);
                        ++this._matchBeforeIndex;
                        this.setFilterMappings(new_mappings);
                    }
                } else {
                    FilterMapping[] new_mappings = this.insertFilterMapping(mapping, 0, true);
                    this.setFilterMappings(new_mappings);
                }
                if (this._matchAfterIndex >= 0) {
                    ++this._matchAfterIndex;
                }
            }
        }
    }

    protected FilterMapping[] insertFilterMapping(FilterMapping mapping, int pos, boolean before) {
        if (pos < 0) {
            throw new IllegalArgumentException("FilterMapping insertion pos < 0");
        }
        FilterMapping[] mappings = this.getFilterMappings();
        if (mappings == null || mappings.length == 0) {
            return new FilterMapping[]{mapping};
        }
        FilterMapping[] new_mappings = new FilterMapping[mappings.length + 1];
        if (before) {
            System.arraycopy(mappings, 0, new_mappings, 0, pos);
            new_mappings[pos] = mapping;
            System.arraycopy(mappings, pos, new_mappings, pos + 1, mappings.length - pos);
        } else {
            System.arraycopy(mappings, 0, new_mappings, 0, pos + 1);
            new_mappings[pos + 1] = mapping;
            if (mappings.length > pos + 1) {
                System.arraycopy(mappings, pos + 1, new_mappings, pos + 2, mappings.length - (pos + 1));
            }
        }
        return new_mappings;
    }

    protected synchronized void updateNameMappings() {
        this._filterNameMap.clear();
        if (this._filters != null) {
            for (Holder holder : this._filters) {
                this._filterNameMap.put(holder.getName(), (FilterHolder)holder);
                holder.setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            for (Holder holder : this._servlets) {
                this._servletNameMap.put(holder.getName(), (ServletHolder)holder);
                holder.setServletHandler(this);
            }
        }
    }

    protected synchronized void updateMappings() {
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList<FilterMapping>();
            this._filterNameMappings = new MultiMap();
            for (FilterMapping filtermapping : this._filterMappings) {
                String[] names;
                FilterHolder filter_holder = this._filterNameMap.get(filtermapping.getFilterName());
                if (filter_holder == null) {
                    throw new IllegalStateException("No filter named " + filtermapping.getFilterName());
                }
                filtermapping.setFilterHolder(filter_holder);
                if (filtermapping.getPathSpecs() != null) {
                    this._filterPathMappings.add(filtermapping);
                }
                if (filtermapping.getServletNames() == null) continue;
                for (String name : names = filtermapping.getServletNames()) {
                    if (name == null) continue;
                    this._filterNameMappings.add(name, (Object)filtermapping);
                }
            }
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pm = new PathMap();
            HashMap<String, ServletMapping> servletPathMappings = new HashMap<String, ServletMapping>();
            HashMap<String, HashSet<ServletMapping>> sms = new HashMap<String, HashSet<ServletMapping>>();
            for (ServletMapping servletMapping : this._servletMappings) {
                String[] pathSpecs = servletMapping.getPathSpecs();
                if (pathSpecs == null) continue;
                for (String pathSpec : pathSpecs) {
                    HashSet<ServletMapping> mappings = (HashSet<ServletMapping>)sms.get(pathSpec);
                    if (mappings == null) {
                        mappings = new HashSet<ServletMapping>();
                        sms.put(pathSpec, mappings);
                    }
                    mappings.add(servletMapping);
                }
            }
            for (String pathSpec : sms.keySet()) {
                Set mappings = (Set)sms.get(pathSpec);
                ServletMapping finalMapping = null;
                for (ServletMapping mapping : mappings) {
                    ServletHolder servlet_holder = this._servletNameMap.get(mapping.getServletName());
                    if (servlet_holder == null) {
                        throw new IllegalStateException("No such servlet: " + mapping.getServletName());
                    }
                    if (!servlet_holder.isEnabled()) continue;
                    if (finalMapping == null) {
                        finalMapping = mapping;
                        continue;
                    }
                    if (finalMapping.isDefault()) {
                        finalMapping = mapping;
                        continue;
                    }
                    if (mapping.isDefault()) continue;
                    throw new IllegalStateException("Multiple servlets map to path: " + pathSpec + ": " + finalMapping.getServletName() + "," + mapping.getServletName());
                }
                if (finalMapping == null) {
                    throw new IllegalStateException("No acceptable servlet mappings for " + pathSpec);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Chose path={} mapped to servlet={} from default={}", new Object[]{pathSpec, finalMapping.getServletName(), finalMapping.isDefault()});
                }
                servletPathMappings.put(pathSpec, finalMapping);
                pm.put(pathSpec, (Object)this._servletNameMap.get(finalMapping.getServletName()));
            }
            this._servletPathMap = pm;
        }
        if (this._chainCache != null) {
            int i = this._chainCache.length;
            while (i-- > 0) {
                if (this._chainCache[i] == null) continue;
                this._chainCache[i].clear();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filterNameMap=" + this._filterNameMap, new Object[0]);
            LOG.debug("pathFilters=" + this._filterPathMappings, new Object[0]);
            LOG.debug("servletFilterMap=" + this._filterNameMappings, new Object[0]);
            LOG.debug("servletPathMap=" + this._servletPathMap, new Object[0]);
            LOG.debug("servletNameMap=" + this._servletNameMap, new Object[0]);
        }
        try {
            if (this._contextHandler != null && this._contextHandler.isStarted() || this._contextHandler == null && this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void notFound(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not Found {}", new Object[]{request.getRequestURI()});
        }
        if (this.getHandler() != null) {
            this.nextHandle(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo()), baseRequest, request, response);
        }
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        this.updateBeans(this._filterMappings, filterMappings);
        this._filterMappings = filterMappings;
        if (this.isStarted()) {
            this.updateMappings();
        }
        this.invalidateChainsCache();
    }

    public synchronized void setFilters(FilterHolder[] holders) {
        if (holders != null) {
            for (FilterHolder holder : holders) {
                holder.setServletHandler(this);
            }
        }
        this.updateBeans((Object[])this._filters, (Object[])holders);
        this._filters = holders;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        this.updateBeans(this._servletMappings, servletMappings);
        this._servletMappings = servletMappings;
        if (this.isStarted()) {
            this.updateMappings();
        }
        this.invalidateChainsCache();
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        if (holders != null) {
            for (ServletHolder holder : holders) {
                holder.setServletHandler(this);
            }
        }
        this.updateBeans(this._servlets, holders);
        this._servlets = holders;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        this._maxFilterChainsCacheSize = maxFilterChainsCacheSize;
    }

    void destroyServlet(Servlet servlet) {
        if (this._contextHandler != null) {
            this._contextHandler.destroyServlet(servlet);
        }
    }

    void destroyFilter(Filter filter) {
        if (this._contextHandler != null) {
            this._contextHandler.destroyFilter(filter);
        }
    }

    public static class Default404Servlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.sendError(404);
        }
    }

    private class Chain
    implements FilterChain {
        final Request _baseRequest;
        final List<FilterHolder> _chain;
        final ServletHolder _servletHolder;
        int _filter = 0;

        Chain(Request baseRequest, List<FilterHolder> filters, ServletHolder servletHolder) {
            this._baseRequest = baseRequest;
            this._chain = filters;
            this._servletHolder = servletHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doFilter " + this._filter, new Object[0]);
            }
            if (this._filter < this._chain.size()) {
                FilterHolder holder = this._chain.get(this._filter++);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call filter " + (Object)((Object)holder), new Object[0]);
                }
                Filter filter = holder.getFilter();
                boolean requestAsyncSupported = this._baseRequest.isAsyncSupported();
                try {
                    if (!holder.isAsyncSupported() && requestAsyncSupported) {
                        this._baseRequest.setAsyncSupported(false);
                    }
                    filter.doFilter(request, response, (FilterChain)this);
                }
                finally {
                    this._baseRequest.setAsyncSupported(requestAsyncSupported);
                }
                return;
            }
            HttpServletRequest srequest = (HttpServletRequest)request;
            if (this._servletHolder == null) {
                ServletHandler.this.notFound(request instanceof Request ? (Request)request : HttpChannel.getCurrentHttpChannel().getRequest(), srequest, (HttpServletResponse)response);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call servlet {}", new Object[]{this._servletHolder});
                }
                this._servletHolder.handle(this._baseRequest, request, response);
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (FilterHolder f : this._chain) {
                b.append(f.toString());
                b.append("->");
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(List<FilterHolder> filters, ServletHolder servletHolder) {
            if (filters.size() > 0) {
                this._filterHolder = filters.get(0);
                filters.remove(0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Request baseRequest;
            Request request2 = baseRequest = request instanceof Request ? (Request)request : HttpChannel.getCurrentHttpChannel().getRequest();
            if (this._filterHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call filter {}", new Object[]{this._filterHolder});
                }
                Filter filter = this._filterHolder.getFilter();
                boolean requestAsyncSupported = baseRequest.isAsyncSupported();
                try {
                    if (!this._filterHolder.isAsyncSupported() && requestAsyncSupported) {
                        baseRequest.setAsyncSupported(false);
                    }
                    filter.doFilter(request, response, (FilterChain)this._next);
                }
                finally {
                    baseRequest.setAsyncSupported(requestAsyncSupported);
                }
                return;
            }
            HttpServletRequest srequest = (HttpServletRequest)request;
            if (this._servletHolder == null) {
                ServletHandler.this.notFound(baseRequest, srequest, (HttpServletResponse)response);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call servlet " + this._servletHolder, new Object[0]);
                }
                this._servletHolder.handle(baseRequest, request, response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return (Object)((Object)this._filterHolder) + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

