/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAnnotatedElement<E extends AnnotatedElement>
extends SourceModel
implements JavaResourceAnnotatedElement {
    final E annotatedElement;
    private final Hashtable<String, Annotation> annotations = new Hashtable();
    private final HashMap<String, Annotation> nullAnnotationCache = new HashMap();
    private final Hashtable<String, CombinationAnnotationContainer> annotationContainers = new Hashtable();
    protected TextRange nameTextRange;
    protected TextRange textRange;
    private static final Transformer<CombinationAnnotationContainer_, Annotation> TOP_LEVEL_ANNOTATION_CONTAINER_TRANSFORMER = new TopLevelAnnotationContainerTransformer();

    SourceAnnotatedElement(JavaResourceModel parent, E annotatedElement) {
        super(parent);
        this.annotatedElement = annotatedElement;
    }

    protected void initialize(ASTNode node, Name nameNode) {
        this.textRange = this.buildTextRange(node);
        this.nameTextRange = ASTTools.buildTextRange((ASTNode)nameNode);
        this.initializeAnnotations(node);
    }

    private void initializeAnnotations(ASTNode node) {
        AnnotationVisitor visitor = new AnnotationVisitor(node);
        node.accept((ASTVisitor)visitor);
        this.initializeAnnotations(visitor.astAnnotations);
        this.initializeContainerAnnotations(visitor.astContainerAnnotations);
        this.initializeStandaloneNestableAnnotations(visitor.astStandaloneNestableAnnotations);
    }

    private void initializeAnnotations(HashMap<String, org.eclipse.jdt.core.dom.Annotation> astAnnotations) {
        for (Map.Entry<String, org.eclipse.jdt.core.dom.Annotation> entry : astAnnotations.entrySet()) {
            String annotationName = entry.getKey();
            org.eclipse.jdt.core.dom.Annotation astAnnotation = entry.getValue();
            Annotation annotation = this.buildAnnotation(annotationName, astAnnotation);
            this.annotations.put(annotationName, annotation);
        }
    }

    private void initializeContainerAnnotations(HashMap<String, org.eclipse.jdt.core.dom.Annotation> astContainerAnnotations) {
        for (Map.Entry<String, org.eclipse.jdt.core.dom.Annotation> entry : astContainerAnnotations.entrySet()) {
            String containerAnnotationName = entry.getKey();
            org.eclipse.jdt.core.dom.Annotation astAnnotation = entry.getValue();
            String nestableAnnotationName = this.getNestableAnnotationName(containerAnnotationName);
            CombinationAnnotationContainer container = new CombinationAnnotationContainer(nestableAnnotationName, containerAnnotationName);
            container.initializeFromContainerAnnotation(astAnnotation);
            this.annotationContainers.put(nestableAnnotationName, container);
        }
    }

    private void initializeStandaloneNestableAnnotations(HashMap<String, org.eclipse.jdt.core.dom.Annotation> astStandaloneNestableAnnotations) {
        for (Map.Entry<String, org.eclipse.jdt.core.dom.Annotation> entry : astStandaloneNestableAnnotations.entrySet()) {
            String nestableAnnotationName = entry.getKey();
            org.eclipse.jdt.core.dom.Annotation astAnnotation = entry.getValue();
            if (this.annotationContainers.get(nestableAnnotationName) != null) continue;
            CombinationAnnotationContainer container = new CombinationAnnotationContainer(nestableAnnotationName);
            container.initializeFromStandaloneAnnotation(astAnnotation);
            this.annotationContainers.put(nestableAnnotationName, container);
        }
    }

    protected void synchronizeWith(ASTNode node, Name nameNode) {
        this.textRange = this.buildTextRange(node);
        this.nameTextRange = ASTTools.buildTextRange((ASTNode)nameNode);
        this.syncAnnotations(node);
    }

    @Override
    public Iterable<Annotation> getAnnotations() {
        return IterableTools.cloneLive(this.annotations.values());
    }

    @Override
    public int getAnnotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.annotations.get(annotationName);
    }

    @Override
    public Annotation getContainerAnnotation(String containerAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(this.getAnnotationProvider().getNestableAnnotationName(containerAnnotationName));
        return container == null ? null : container.getContainerAnnotation();
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.getNullAnnotation(annotationName);
    }

    private Annotation getNullAnnotation(String annotationName) {
        Annotation annotation = this.nullAnnotationCache.get(annotationName);
        if (annotation == null) {
            annotation = this.buildNullAnnotation(annotationName);
            this.nullAnnotationCache.put(annotationName, annotation);
        }
        return annotation;
    }

    private Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAnnotation(this, annotationName);
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        Annotation annotation = this.buildAnnotation(annotationName);
        this.annotations.put(annotationName, annotation);
        annotation.newAnnotation();
        return annotation;
    }

    @Override
    public void removeAnnotation(String annotationName) {
        Annotation annotation = this.annotations.remove(annotationName);
        annotation.removeAnnotation();
    }

    boolean annotationIsValid(String annotationName) {
        return IterableTools.contains(this.getAnnotationProvider().getAnnotationNames(), (Object)annotationName);
    }

    Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildAnnotation((JavaResourceAnnotatedElement)this, (AnnotatedElement)this.annotatedElement, annotationName);
    }

    Annotation buildAnnotation(String annotationName, org.eclipse.jdt.core.dom.Annotation astAnnotation) {
        Annotation annotation = this.getAnnotationProvider().buildAnnotation((JavaResourceAnnotatedElement)this, (AnnotatedElement)this.annotatedElement, annotationName);
        annotation.initialize(astAnnotation);
        return annotation;
    }

    private Iterable<NestableAnnotation> getNestableAnnotations() {
        return IterableTools.children(this.getAnnotationContainers(), CombinationAnnotationContainer_.NESTED_ANNOTATIONS_TRANSFORMER);
    }

    private Iterable<CombinationAnnotationContainer> getAnnotationContainers() {
        return IterableTools.cloneLive(this.annotationContainers.values());
    }

    @Override
    public ListIterable<NestableAnnotation> getAnnotations(String nestableAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container != null ? container.getNestedAnnotations() : EmptyListIterable.instance();
    }

    @Override
    public int getAnnotationsSize(String nestableAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? 0 : container.getNestedAnnotationsSize();
    }

    @Override
    public NestableAnnotation getAnnotation(int index, String nestableAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        if (container == null) {
            throw new ArrayIndexOutOfBoundsException("size: 0 index: " + index);
        }
        return container.getNestedAnnotation(index);
    }

    private String getNestableAnnotationName(String containerAnnotationName) {
        return this.getAnnotationProvider().getNestableAnnotationName(containerAnnotationName);
    }

    String getContainerAnnotationName(String nestableAnnotationName) {
        return this.getAnnotationProvider().getContainerAnnotationName(nestableAnnotationName);
    }

    String getNestableElementName(String nestableAnnotationName) {
        return this.getAnnotationProvider().getNestableElementName(nestableAnnotationName);
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        if (container == null) {
            container = new CombinationAnnotationContainer(nestableAnnotationName);
            this.annotationContainers.put(nestableAnnotationName, container);
        }
        return container.addNestedAnnotation(index);
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String nestableAnnotationName) {
        this.annotationContainers.get(nestableAnnotationName).moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        container.removeNestedAnnotation(index);
        if (container.isEmpty()) {
            this.annotationContainers.remove(nestableAnnotationName);
        }
    }

    boolean annotationIsValidContainer(String annotationName) {
        return IterableTools.contains(this.getAnnotationProvider().getContainerAnnotationNames(), (Object)annotationName);
    }

    boolean annotationIsValidNestable(String annotationName) {
        return IterableTools.contains(this.getAnnotationProvider().getNestableAnnotationNames(), (Object)annotationName);
    }

    NestableAnnotation buildNestableAnnotation(String annotationName, int index) {
        return this.getAnnotationProvider().buildAnnotation(this, (AnnotatedElement)this.annotatedElement, annotationName, index);
    }

    void nestedAnnotationAdded(String collectionName, NestableAnnotation addedAnnotation) {
        this.fireItemAdded(collectionName, addedAnnotation);
    }

    void nestedAnnotationsRemoved(String collectionName, Collection<? extends NestableAnnotation> removedAnnotations) {
        this.fireItemsRemoved(collectionName, removedAnnotations);
    }

    Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        HashSet<String> annotationNames = new HashSet<String>();
        CollectionTools.addAll(annotationNames, supportingAnnotationNames);
        if (primaryAnnotationName != null) {
            annotationNames.add(primaryAnnotationName);
        }
        this.retainAnnotations(annotationNames);
        this.retainAnnotationContainers(annotationNames);
        if (primaryAnnotationName == null) {
            return null;
        }
        Annotation primaryAnnotation = this.getAnnotation(primaryAnnotationName);
        if (primaryAnnotation == null) {
            primaryAnnotation = this.buildAnnotation(primaryAnnotationName);
            this.annotations.put(primaryAnnotationName, primaryAnnotation);
            primaryAnnotation.newAnnotation();
        }
        return primaryAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retainAnnotations(HashSet<String> annotationNames) {
        Hashtable<String, Annotation> hashtable = this.annotations;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, Annotation>> stream = this.annotations.entrySet().iterator();
            while (stream.hasNext()) {
                Map.Entry<String, Annotation> entry = stream.next();
                String annotationName = entry.getKey();
                Annotation annotation = entry.getValue();
                if (annotationNames.contains(annotationName)) continue;
                stream.remove();
                annotation.removeAnnotation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retainAnnotationContainers(HashSet<String> annotationNames) {
        Hashtable<String, CombinationAnnotationContainer> hashtable = this.annotationContainers;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, CombinationAnnotationContainer>> stream = this.annotationContainers.entrySet().iterator();
            while (stream.hasNext()) {
                Map.Entry<String, CombinationAnnotationContainer> entry = stream.next();
                String nestableAnnotationName = entry.getKey();
                CombinationAnnotationContainer container = entry.getValue();
                Annotation containerAnnotation = container.getContainerAnnotation();
                if (containerAnnotation != null) {
                    if (annotationNames.contains(container.getContainerAnnotationName())) continue;
                    stream.remove();
                    containerAnnotation.removeAnnotation();
                    continue;
                }
                if (annotationNames.contains(nestableAnnotationName)) continue;
                stream.remove();
                container.getNestedAnnotation(0).removeAnnotation();
            }
        }
    }

    private void syncAnnotations(ASTNode node) {
        AnnotationVisitor visitor = new AnnotationVisitor(node);
        node.accept((ASTVisitor)visitor);
        this.syncAnnotations(visitor.astAnnotations);
        this.syncAnnotationContainers(visitor.astContainerAnnotations, visitor.astStandaloneNestableAnnotations);
    }

    private void syncAnnotations(HashMap<String, org.eclipse.jdt.core.dom.Annotation> astAnnotations) {
        HashMap<String, Annotation> annotationsToRemove = new HashMap<String, Annotation>(this.annotations);
        HashMap<String, Annotation> annotationsToAdd = new HashMap<String, Annotation>();
        for (Map.Entry<String, org.eclipse.jdt.core.dom.Annotation> entry : astAnnotations.entrySet()) {
            String annotationName = entry.getKey();
            org.eclipse.jdt.core.dom.Annotation astAnnotation = entry.getValue();
            Annotation annotation = annotationsToRemove.remove(annotationName);
            if (annotation == null) {
                annotation = this.buildAnnotation(annotationName, astAnnotation);
                annotationsToAdd.put(annotationName, annotation);
                continue;
            }
            annotation.synchronizeWith(astAnnotation);
        }
        this.annotations.putAll(annotationsToAdd);
        this.fireItemsAdded("annotations", annotationsToAdd.values());
        for (String annotationName : annotationsToRemove.keySet()) {
            this.annotations.remove(annotationName);
        }
        this.fireItemsRemoved("annotations", annotationsToRemove.values());
    }

    private void syncAnnotationContainers(HashMap<String, org.eclipse.jdt.core.dom.Annotation> astContainerAnnotations, HashMap<String, org.eclipse.jdt.core.dom.Annotation> astStandaloneNestableAnnotations) {
        CombinationAnnotationContainer container;
        String nestableAnnotationName;
        HashMap<String, CombinationAnnotationContainer> containersToRemove = new HashMap<String, CombinationAnnotationContainer>(this.annotationContainers);
        HashMap<Object, CombinationAnnotationContainer> containersToAdd = new HashMap<Object, CombinationAnnotationContainer>();
        for (Map.Entry<String, org.eclipse.jdt.core.dom.Annotation> entry : astContainerAnnotations.entrySet()) {
            String containerAnnotationName = entry.getKey();
            org.eclipse.jdt.core.dom.Annotation astContainerAnnotation = entry.getValue();
            nestableAnnotationName = this.getNestableAnnotationName(containerAnnotationName);
            container = containersToRemove.remove(nestableAnnotationName);
            if (container == null) {
                container = new CombinationAnnotationContainer(nestableAnnotationName, containerAnnotationName);
                container.initializeFromContainerAnnotation(astContainerAnnotation);
                containersToAdd.put(nestableAnnotationName, container);
            } else {
                container.synchronize(astContainerAnnotation);
            }
            astStandaloneNestableAnnotations.remove(nestableAnnotationName);
        }
        for (Map.Entry<String, org.eclipse.jdt.core.dom.Annotation> entry : astStandaloneNestableAnnotations.entrySet()) {
            String nestableAnnotationName2 = entry.getKey();
            org.eclipse.jdt.core.dom.Annotation astNestableAnnotation = entry.getValue();
            CombinationAnnotationContainer container2 = containersToRemove.remove(nestableAnnotationName2);
            if (container2 == null) {
                container2 = new CombinationAnnotationContainer(nestableAnnotationName2);
                container2.initializeFromStandaloneAnnotation(astNestableAnnotation);
                containersToAdd.put(nestableAnnotationName2, container2);
                continue;
            }
            container2.synchronizeNestableAnnotation(astNestableAnnotation);
        }
        ArrayList removedNestableAnnotations = new ArrayList();
        for (String nestableAnnotationName3 : containersToRemove.keySet()) {
            CombinationAnnotationContainer container3 = this.annotationContainers.remove(nestableAnnotationName3);
            CollectionTools.addAll(removedNestableAnnotations, container3.getNestedAnnotations());
        }
        this.fireItemsRemoved("nestableAnnotations", removedNestableAnnotations);
        ArrayList addedNestableAnnotations = new ArrayList();
        for (Map.Entry entry : containersToAdd.entrySet()) {
            nestableAnnotationName = (String)entry.getKey();
            container = (CombinationAnnotationContainer)entry.getValue();
            this.annotationContainers.put(nestableAnnotationName, container);
            CollectionTools.addAll(addedNestableAnnotations, container.getNestedAnnotations());
        }
        this.fireItemsAdded("nestableAnnotations", addedNestableAnnotations);
    }

    @Override
    public Iterable<Annotation> getTopLevelAnnotations() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getAnnotations(), this.getContainerOrStandaloneNestableAnnotations()});
    }

    private Iterable<Annotation> getContainerOrStandaloneNestableAnnotations() {
        return new TransformationIterable(this.getAnnotationContainers(), TOP_LEVEL_ANNOTATION_CONTAINER_TRANSFORMER);
    }

    @Override
    public boolean isAnnotated() {
        return !this.isUnannotated();
    }

    public boolean isUnannotated() {
        return this.annotations.isEmpty() && this.annotationContainers.isEmpty();
    }

    @Override
    public boolean isAnnotatedWithAnyOf(Iterable<String> annotationNames) {
        for (Annotation annotation : this.getSignificantAnnotations()) {
            if (!IterableTools.contains(annotationNames, (Object)annotation.getAnnotationName())) continue;
            return true;
        }
        return false;
    }

    private Iterable<Annotation> getSignificantAnnotations() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getAnnotations(), this.getNestableAnnotations()});
    }

    @Override
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getTextRange(String nestableAnnotationName) {
        CombinationAnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        if (container == null) {
            return null;
        }
        Annotation annotation = container.getContainerAnnotation();
        if (annotation == null) {
            annotation = container.getNestedAnnotation(0);
        }
        return annotation.getTextRange();
    }

    private TextRange buildTextRange(ASTNode astNode) {
        return astNode == null ? null : ASTTools.buildTextRange(astNode);
    }

    class AnnotationVisitor
    extends ASTVisitor {
        private final ASTNode node;
        final HashMap<String, org.eclipse.jdt.core.dom.Annotation> astAnnotations = new HashMap();
        final HashMap<String, org.eclipse.jdt.core.dom.Annotation> astContainerAnnotations = new HashMap();
        final HashMap<String, org.eclipse.jdt.core.dom.Annotation> astStandaloneNestableAnnotations = new HashMap();

        AnnotationVisitor(ASTNode node) {
            this.node = node;
        }

        public boolean visit(SingleMemberAnnotation annotation) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)annotation);
        }

        public boolean visit(NormalAnnotation annotation) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)annotation);
        }

        public boolean visit(MarkerAnnotation annotation) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)annotation);
        }

        private boolean visit_(org.eclipse.jdt.core.dom.Annotation astAnnotation) {
            if (astAnnotation.getParent() == this.node) {
                this.visitChildAnnotation(astAnnotation);
            }
            return false;
        }

        private void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation astAnnotation) {
            String astAnnotationName = this.resolveAnnotationName(astAnnotation);
            if (astAnnotationName == null) {
                return;
            }
            if (SourceAnnotatedElement.this.annotationIsValidContainer(astAnnotationName)) {
                if (this.astContainerAnnotations.get(astAnnotationName) == null) {
                    this.astContainerAnnotations.put(astAnnotationName, astAnnotation);
                }
            } else if (SourceAnnotatedElement.this.annotationIsValid(astAnnotationName)) {
                if (this.astAnnotations.get(astAnnotationName) == null) {
                    this.astAnnotations.put(astAnnotationName, astAnnotation);
                }
            } else if (SourceAnnotatedElement.this.annotationIsValidNestable(astAnnotationName) && this.astStandaloneNestableAnnotations.get(astAnnotationName) == null) {
                this.astStandaloneNestableAnnotations.put(astAnnotationName, astAnnotation);
            }
        }

        private String resolveAnnotationName(org.eclipse.jdt.core.dom.Annotation astAnnotation) {
            IAnnotationBinding annotationBinding = astAnnotation.resolveAnnotationBinding();
            if (annotationBinding == null) {
                return null;
            }
            ITypeBinding annotationTypeBinding = annotationBinding.getAnnotationType();
            return annotationTypeBinding == null ? null : annotationTypeBinding.getQualifiedName();
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this), (Object)this.node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CombinationAnnotationContainer
    extends SourceModel.AnnotationContainer<NestableAnnotation>
    implements CombinationAnnotationContainer_ {
        private final String nestableAnnotationName;
        private final String containerAnnotationName;
        private Annotation containerAnnotation;

        CombinationAnnotationContainer(String nestableAnnotationName) {
            this(nestableAnnotationName, sourceAnnotatedElement.getContainerAnnotationName(nestableAnnotationName));
        }

        CombinationAnnotationContainer(String nestableAnnotationName, String containerAnnotationName) {
            if (nestableAnnotationName == null || containerAnnotationName == null) {
                throw new NullPointerException();
            }
            this.nestableAnnotationName = nestableAnnotationName;
            this.containerAnnotationName = containerAnnotationName;
        }

        @Override
        public void initializeFromContainerAnnotation(org.eclipse.jdt.core.dom.Annotation astContainerAnnotation) {
            super.initializeFromContainerAnnotation(astContainerAnnotation);
            this.containerAnnotation = this.buildContainerAnnotation(this.containerAnnotationName, astContainerAnnotation);
        }

        private Annotation buildContainerAnnotation(String name) {
            return SourceAnnotatedElement.this.buildAnnotation(name);
        }

        private Annotation buildContainerAnnotation(String name, org.eclipse.jdt.core.dom.Annotation astContainerAnnotation) {
            return SourceAnnotatedElement.this.buildAnnotation(name, astContainerAnnotation);
        }

        @Override
        public Annotation getContainerAnnotation() {
            return this.containerAnnotation;
        }

        String getContainerAnnotationName() {
            return this.containerAnnotationName;
        }

        @Override
        protected String getElementName() {
            return SourceAnnotatedElement.this.getNestableElementName(this.nestableAnnotationName);
        }

        @Override
        protected String getNestedAnnotationName() {
            return this.nestableAnnotationName;
        }

        @Override
        protected NestableAnnotation buildNestedAnnotation(int index) {
            return SourceAnnotatedElement.this.buildNestableAnnotation(this.nestableAnnotationName, index);
        }

        void initializeFromStandaloneAnnotation(org.eclipse.jdt.core.dom.Annotation astStandaloneNestableAnnotation) {
            NestableAnnotation nestedAnnotation = this.buildNestedAnnotation(0);
            this.nestedAnnotations.add(nestedAnnotation);
            nestedAnnotation.initialize(astStandaloneNestableAnnotation);
        }

        void synchronizeNestableAnnotation(org.eclipse.jdt.core.dom.Annotation astStandaloneNestableAnnotation) {
            this.containerAnnotation = null;
            if (this.nestedAnnotations.size() == 0) {
                this.syncAddNestedAnnotation(astStandaloneNestableAnnotation);
            } else {
                ((NestableAnnotation)this.nestedAnnotations.get(0)).synchronizeWith(astStandaloneNestableAnnotation);
                this.syncRemoveNestedAnnotations(1);
            }
        }

        @Override
        public NestableAnnotation addNestedAnnotation(int index) {
            if (this.nestedAnnotations.size() == 1 && this.containerAnnotation == null) {
                this.containerAnnotation = this.buildContainerAnnotation(this.containerAnnotationName);
            }
            return super.addNestedAnnotation(index);
        }

        @Override
        public NestableAnnotation removeNestedAnnotation(int index) {
            if (this.nestedAnnotations.size() <= 2) {
                this.containerAnnotation = null;
            }
            return super.removeNestedAnnotation(index);
        }

        @Override
        protected String getNestedAnnotationsListName() {
            throw new UnsupportedOperationException();
        }

        @Override
        void nestedAnnotationAdded(int index, NestableAnnotation addedAnnotation) {
            SourceAnnotatedElement.this.nestedAnnotationAdded("nestableAnnotations", addedAnnotation);
        }

        @Override
        void nestedAnnotationsRemoved(int index, List<NestableAnnotation> removedAnnotations) {
            SourceAnnotatedElement.this.nestedAnnotationsRemoved("nestableAnnotations", removedAnnotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CombinationAnnotationContainer_ {
        public static final Transformer<CombinationAnnotationContainer_, Iterable<NestableAnnotation>> NESTED_ANNOTATIONS_TRANSFORMER = new NestedAnnotationsTransformer();

        public Annotation getContainerAnnotation();

        public ListIterable<NestableAnnotation> getNestedAnnotations();

        public NestableAnnotation getNestedAnnotation(int var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class NestedAnnotationsTransformer
        extends TransformerAdapter<CombinationAnnotationContainer_, Iterable<NestableAnnotation>> {
            public Iterable<NestableAnnotation> transform(CombinationAnnotationContainer_ container) {
                return container.getNestedAnnotations();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TopLevelAnnotationContainerTransformer
    extends TransformerAdapter<CombinationAnnotationContainer_, Annotation> {
        TopLevelAnnotationContainerTransformer() {
        }

        public Annotation transform(CombinationAnnotationContainer_ container) {
            Annotation containerAnnotation = container.getContainerAnnotation();
            return containerAnnotation != null ? containerAnnotation : container.getNestedAnnotation(0);
        }
    }
}

