/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.swt.events.SelectionAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BooleanButtonModelBinding {
    private final ModifiablePropertyValueModel<Boolean> booleanModel;
    private final PropertyChangeListener booleanListener;
    private final boolean defaultValue;
    private final Button button;
    private final SelectionListener buttonSelectionListener;
    private final DisposeListener buttonDisposeListener;

    BooleanButtonModelBinding(ModifiablePropertyValueModel<Boolean> booleanModel, Button button, boolean defaultValue) {
        if (booleanModel == null || button == null) {
            throw new NullPointerException();
        }
        this.booleanModel = booleanModel;
        this.button = button;
        this.defaultValue = defaultValue;
        this.booleanListener = this.buildBooleanListener();
        this.booleanModel.addPropertyChangeListener("value", this.booleanListener);
        this.buttonSelectionListener = this.buildButtonSelectionListener();
        this.button.addSelectionListener(this.buttonSelectionListener);
        this.buttonDisposeListener = this.buildButtonDisposeListener();
        this.button.addDisposeListener(this.buttonDisposeListener);
        this.setButtonSelection((Boolean)this.booleanModel.getValue());
    }

    private PropertyChangeListener buildBooleanListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new BooleanListener(), (Widget)this.button);
    }

    private SelectionListener buildButtonSelectionListener() {
        return new ButtonSelectionListener();
    }

    private DisposeListener buildButtonDisposeListener() {
        return new ButtonDisposeListener();
    }

    void booleanChanged(PropertyChangeEvent event) {
        if (!this.button.isDisposed()) {
            this.setButtonSelection((Boolean)event.getNewValue());
        }
    }

    private void setButtonSelection(Boolean b) {
        this.button.setSelection(this.booleanValue(b));
    }

    private boolean booleanValue(Boolean b) {
        return b != null ? b : this.defaultValue;
    }

    void buttonSelected() {
        this.booleanModel.setValue((Object)this.button.getSelection());
    }

    void buttonDisposed() {
        this.button.removeSelectionListener(this.buttonSelectionListener);
        this.button.removeDisposeListener(this.buttonDisposeListener);
        this.booleanModel.removePropertyChangeListener("value", this.booleanListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.booleanModel);
    }

    class BooleanListener
    extends PropertyChangeAdapter {
        BooleanListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            BooleanButtonModelBinding.this.booleanChanged(event);
        }
    }

    class ButtonDisposeListener
    extends DisposeAdapter {
        ButtonDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            BooleanButtonModelBinding.this.buttonDisposed();
        }
    }

    class ButtonSelectionListener
    extends SelectionAdapter {
        ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BooleanButtonModelBinding.this.buttonSelected();
        }
    }
}

