/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeInterruptibleClosureWrapper<A>
implements InterruptibleClosure<A> {
    private final InterruptibleClosure<? super A> closure;
    private final ExceptionHandler exceptionHandler;

    public SafeInterruptibleClosureWrapper(InterruptibleClosure<? super A> closure, ExceptionHandler exceptionHandler) {
        if (closure == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.closure = closure;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute(A argument) throws InterruptedException {
        try {
            this.closure.execute(argument);
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closure);
    }
}

