/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator<E>
implements Iterator<E> {
    private final LinkedList<Iterator<? extends E>> iterators;
    private final Transformer<? super E, ? extends Iterator<? extends E>> transformer;
    private Iterator<? extends E> currentIterator;

    public TreeIterator(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        if (roots == null || transformer == null) {
            throw new NullPointerException();
        }
        this.currentIterator = roots;
        this.iterators = new LinkedList();
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        for (Iterator iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.currentIterator.hasNext()) {
            return this.nextInternal();
        }
        Iterator stream = this.iterators.iterator();
        while (stream.hasNext()) {
            this.currentIterator = (Iterator)stream.next();
            if (this.currentIterator.hasNext()) break;
            stream.remove();
        }
        return this.nextInternal();
    }

    private E nextInternal() {
        E next = this.currentIterator.next();
        this.iterators.add(this.transformer.transform(next));
        return next;
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.currentIterator);
    }
}

