/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessReference;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;

public interface PersistentAttribute
extends JpaStructureNode,
AccessReference {
    public static final String NAME_PROPERTY = "name";
    public static final Transformer<PersistentAttribute, String> NAME_TRANSFORMER = new NameTransformer();
    public static final String MAPPING_PROPERTY = "mapping";
    public static final Transformer<PersistentAttribute, AttributeMapping> MAPPING_TRANSFORMER = new MappingTransformer();
    public static final String DEFAULT_MAPPING_KEY_PROPERTY = "defaultMappingKey";

    public String getName();

    public AttributeMapping getMapping();

    public String getMappingKey();

    public String getDefaultMappingKey();

    public PersistentType getDeclaringPersistentType();

    public TypeMapping getDeclaringTypeMapping();

    public String getTypeName();

    public String getTypeName(PersistentType var1);

    public String getPrimaryKeyColumnName();

    public boolean isVirtual();

    public JavaSpecifiedPersistentAttribute getJavaPersistentAttribute();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingTransformer
    extends TransformerAdapter<PersistentAttribute, AttributeMapping> {
        public AttributeMapping transform(PersistentAttribute pa) {
            return pa.getMapping();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameEquals
    extends CriterionPredicate<PersistentAttribute, String> {
        public NameEquals(String attributeName) {
            super((Object)attributeName);
        }

        public boolean evaluate(PersistentAttribute attribute) {
            return ObjectTools.equals((Object)this.criterion, (Object)attribute.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameTransformer
    extends TransformerAdapter<PersistentAttribute, String> {
        public String transform(PersistentAttribute attribute) {
            return attribute.getName();
        }
    }
}

