/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.internal.common.operations.Method;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMethod
implements Method {
    private IMethod method;

    public BinaryMethod(IMethod method) {
        this.method = method;
    }

    @Override
    public String getSignature() {
        try {
            return this.method.getSignature();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.method.getElementName();
    }

    @Override
    public String getContainingJavaClass() {
        return this.method.getDeclaringType().getElementName();
    }

    @Override
    public String getReturnType() {
        try {
            return Signature.getSignatureSimpleName((String)this.method.getReturnType());
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDefaultReturnValue() {
        block4: {
            String signature;
            block5: {
                try {
                    signature = this.method.getReturnType();
                    int kind = Signature.getTypeSignatureKind((String)signature);
                    if (kind != 2) break block4;
                    if (!"V".equals(signature)) break block5;
                    return null;
                }
                catch (JavaModelException e) {
                    throw new RuntimeException(e);
                }
            }
            if ("Z".equals(signature)) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Override
    public Collection<String> getReturnTypeImports() {
        try {
            ArrayList<String> result = new ArrayList<String>();
            String signature = this.method.getReturnType();
            this.getTypeImports(signature, result);
            return result;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getParamsForCall() {
        return this.getParams(false, true);
    }

    @Override
    public String getParamsForDeclaration() {
        return this.getParams(true, true);
    }

    @Override
    public String getParamsForJavadoc() {
        return this.getParams(true, false);
    }

    @Override
    public Collection<String> getParameterImports() {
        String[] parameterTypes;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = parameterTypes = this.method.getParameterTypes();
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterType = stringArray[n2];
            this.getTypeImports(parameterType, result);
            ++n2;
        }
        return result;
    }

    @Override
    public String getExceptions() {
        StringBuffer exceptions = new StringBuffer();
        try {
            String[] exceptionTypes = this.method.getExceptionTypes();
            int i = 0;
            while (i < exceptionTypes.length) {
                exceptions.append(Signature.toString((String)exceptionTypes[i]));
                if (i < exceptionTypes.length - 1) {
                    exceptions.append(", ");
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            J2EEPlugin.logError((CoreException)((Object)e));
        }
        return exceptions.toString();
    }

    public boolean equals(Object o) {
        Method obj = (Method)o;
        return this.getName().equals(obj.getName()) && this.getSignature().equals(obj.getSignature());
    }

    public int hashCode() {
        return this.getName().hashCode() * this.getSignature().hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private String getParams(boolean types, boolean names) {
        block8: {
            result = new StringBuilder();
            parameterTypes = this.method.getParameterTypes();
            try {
                parameterNames = this.method.getParameterNames();
                break block8;
            }
            catch (JavaModelException e) {
                J2EEPlugin.logError((CoreException)e);
                parameterNames = new String[parameterTypes.length];
                i = 0;
                ** while (i < parameterNames.length)
            }
lbl-1000:
            // 1 sources

            {
                parameterNames[i] = "arg" + i;
                ++i;
                continue;
            }
        }
        i = 0;
        while (i < parameterTypes.length) {
            if (types) {
                result.append(Signature.getSignatureSimpleName((String)parameterTypes[i]));
            }
            if (types && names) {
                result.append(" ");
            }
            if (names) {
                result.append(parameterNames[i]);
            }
            if (i < parameterNames.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    private void getTypeImports(String type, List<String> result) {
        int kind = Signature.getTypeSignatureKind((String)type);
        switch (kind) {
            case 4: {
                this.getArrayTypeImports(type, result);
                break;
            }
            case 2: {
                this.getBaseTypeImports(type, result);
                break;
            }
            case 6: {
                this.getCaptureTypeImports(type, result);
                break;
            }
            case 1: {
                this.getClassTypeImports(type, result);
                break;
            }
            case 3: {
                this.getTypeVarialbleImports(type, result);
                break;
            }
            case 5: {
                this.getWildcardTypeImports(type, result);
                break;
            }
            default: {
                throw new IllegalStateException("invalid type signature kind: " + kind);
            }
        }
    }

    private void getArrayTypeImports(String type, List<String> result) {
        String elementType = Signature.getElementType((String)type);
        this.getTypeImports(elementType, result);
    }

    private void getBaseTypeImports(String type, List<String> result) {
    }

    private void getCaptureTypeImports(String type, List<String> result) {
    }

    private void getClassTypeImports(String type, List<String> result) {
        result.add(Signature.toString((String)Signature.getTypeErasure((String)type)));
    }

    private void getTypeVarialbleImports(String type, List<String> result) {
    }

    private void getWildcardTypeImports(String type, List<String> result) {
    }
}

