/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.client.core.functions.FunctionContext;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class NodeAttributeEvaluator
extends AbstractFunctionEvaluator {
    private static final String COMMENT_ATTRIBUTE = "comment";
    private static final String NAME_ATTRIBUTE = "name";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String evaluate(String[] arguments) throws InvalidDataException {
        this.validateParamCount(arguments, 1);
        String arg0 = arguments[0].toLowerCase();
        String attributeValue = null;
        FunctionContext context = this.getContext();
        if (context == null) throw new InvalidDataException("Function is being called without a node context!", MessageIDs.E_FUNCTION_EVAL_ERROR);
        INodePO node = context.getNode();
        if (NAME_ATTRIBUTE.equals(arg0)) {
            return node.getName();
        }
        if (!COMMENT_ATTRIBUTE.equals(arg0)) throw new InvalidDataException("Unkown attribute: " + arg0, MessageIDs.E_FUNCTION_EVAL_ERROR);
        return node.getComment();
    }
}

