/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.rc.commands;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.rc.commands.IPostExecutionCommand;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.Traverser;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public abstract class AbstractPostExecutionCommand
implements IPostExecutionCommand {
    private Locale m_locale;
    private Traverser m_traverser;
    private ICapPO m_currentCap;
    private ExternalTestDataBP m_externalTestDataBP;

    protected String getValueForParam(ITestDataPO date, ICapPO cap, IParamDescriptionPO desc) throws InvalidDataException {
        String value = "";
        Locale locale = this.getLocale();
        ModelParamValueConverter conv = new ModelParamValueConverter(date.getValue(locale), (IParameterInterfacePO)cap, locale, desc);
        try {
            ArrayList<ExecObject> stackList = new ArrayList<ExecObject>(this.getTraverser().getExecStackAsList());
            value = conv.getExecutionString(stackList, locale);
        }
        catch (InvalidDataException invalidDataException) {
            throw new InvalidDataException(String.valueOf(Messages.NeitherValueNorReferenceForNode) + ":" + " " + cap.getName(), MessageIDs.E_NO_REFERENCE);
        }
        return value;
    }

    protected String getValueForParam(String paramID) throws JBException {
        ICapPO currentCap = this.getCurrentCap();
        IParamDescriptionPO desc = currentCap.getParameterForUniqueId(paramID);
        ITDManager tdManager = this.getExternalTestDataBP().getExternalCheckedTDManager(currentCap);
        ITestDataPO date = tdManager.getCell(0, desc);
        return this.getValueForParam(date, currentCap, desc);
    }

    protected Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    protected Traverser getTraverser() {
        return this.m_traverser;
    }

    public void setTraverser(Traverser traverser) {
        this.m_traverser = traverser;
    }

    protected ICapPO getCurrentCap() {
        return this.m_currentCap;
    }

    public void setCurrentCap(ICapPO currentCap) {
        this.m_currentCap = currentCap;
    }

    protected ExternalTestDataBP getExternalTestDataBP() {
        return this.m_externalTestDataBP;
    }

    public void setExternalTestDataBP(ExternalTestDataBP externalTestDataBP) {
        this.m_externalTestDataBP = externalTestDataBP;
    }
}

