/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.tools.exception.InvalidDataException;

public final class DefaultEventHandler {
    private static Map<String, IEventExecTestCasePO> handlerMap = new HashMap<String, IEventExecTestCasePO>();

    private DefaultEventHandler() {
    }

    public static IEventExecTestCasePO getDefaultEventHandler(String eventId, INodePO rootNode) {
        DefaultEventHandler.createMap(rootNode);
        return handlerMap.get(eventId) != null ? handlerMap.get(eventId) : handlerMap.get("Default");
    }

    private static void createMap(INodePO rootNode) {
        handlerMap = new HashMap<String, IEventExecTestCasePO>();
        if (rootNode instanceof ITestSuitePO) {
            ITestSuitePO testSuite = (ITestSuitePO)rootNode;
            Map<String, Integer> map = testSuite.getDefaultEventHandler();
            Set<String> mapKeySet = map.keySet();
            for (String key : mapKeySet) {
                try {
                    handlerMap.put(key, DefaultEventHandler.createHandler(key, ReentryProperty.getProperty(map.get(key)), rootNode));
                }
                catch (InvalidDataException invalidDataException) {
                    return;
                }
            }
            handlerMap.put("Default", DefaultEventHandler.createHandler(Messages.DefaultEventHandlerUnknown, ReentryProperty.EXIT, rootNode));
            return;
        }
        handlerMap.put("TestErrorEvent.Action", DefaultEventHandler.createHandler(Messages.TestErrorEventAction, ReentryProperty.EXIT, rootNode));
        handlerMap.put("TestErrorEvent.CompNotFound", DefaultEventHandler.createHandler(Messages.TestErrorEventCompNotFound, ReentryProperty.EXIT, rootNode));
        handlerMap.put("TestErrorEvent.Config", DefaultEventHandler.createHandler(Messages.TestErrorEventConfig, ReentryProperty.CONTINUE, rootNode));
        handlerMap.put("TestErrorEvent.VerifyFailed", DefaultEventHandler.createHandler(Messages.TestErrorEventVerifyFailed, ReentryProperty.CONTINUE, rootNode));
        handlerMap.put("Default", DefaultEventHandler.createHandler(Messages.DefaultEventHandlerUnknown, ReentryProperty.EXIT, rootNode));
    }

    private static IEventExecTestCasePO createHandler(String eventType, ReentryProperty prop, INodePO assocNode) {
        IEventExecTestCasePO eventTC = NodeMaker.createEventExecTestCasePO(NodeMaker.createSpecTestCasePO("EmptySpecTestCase"), assocNode);
        eventTC.setReentryProp(prop);
        eventTC.setName(Messages.DefaultEventHandlerDefEH);
        eventTC.setEventType(eventType);
        return eventTC;
    }
}

