/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.compcheck.ProblemPropagator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.teststyle.ExtensionHelper;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.CheckCont;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.gui.TeststyleProblemAdder;
import org.eclipse.jubula.client.teststyle.gui.decoration.DecoratorHandler;
import org.eclipse.jubula.client.teststyle.problems.ProblemCont;

public final class TeststyleHandler
implements DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IProjectStateListener {
    private static TeststyleHandler instance;

    private TeststyleHandler() {
        DataEventDispatcher.getInstance().addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, false);
        this.addToListener();
    }

    public static TeststyleHandler getInstance() {
        if (instance == null) {
            instance = new TeststyleHandler();
        }
        return instance;
    }

    public void handleProjectLoaded() {
        if (GeneralStorage.getInstance().getProject() == null) {
            return;
        }
        ExtensionHelper.initCheckConfiguration();
        this.checkEverything();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        if (!this.isEnabled()) {
            return;
        }
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleChangedPo(e.getPo(), e.getDataState(), e.getUpdateState());
            ++n2;
        }
        this.refresh();
        this.addTeststyleProblems();
        ProblemPropagator.getInstance().propagate();
    }

    private void handleChangedPo(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        ProblemCont.getInstance().remove(po);
        switch (dataState) {
            case Renamed: 
            case Added: 
            case StructureModified: 
            case ReuseChanged: {
                this.check(po);
                break;
            }
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            ProblemCont.getInstance().remove(project);
            this.check(project);
        }
        if (po instanceof ISpecTestCasePO || po instanceof ITestSuitePO || po instanceof ITestJobPO) {
            INodePO node = (INodePO)po;
            Iterator iter = node.getNodeListIterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof IParamNodePO)) continue;
                IParamNodePO paramNode = (IParamNodePO)next;
                this.handleChangedPo((IPersistentObject)paramNode, dataState, updateState);
            }
            if (node instanceof ISpecTestCasePO) {
                ISpecTestCasePO specTc = (ISpecTestCasePO)node;
                Collection c = specTc.getAllEventEventExecTC();
                for (IEventExecTestCasePO eh : c) {
                    this.handleChangedPo((IPersistentObject)eh, dataState, updateState);
                }
            }
        }
    }

    public void check(Object obj) {
        BaseContext context = BaseContext.getFor(obj.getClass());
        List<BaseCheck> checks = CheckCont.getChecksFor(context);
        for (BaseCheck check : checks) {
            if (!check.isActive(context) || !check.hasError(obj)) continue;
            if (obj instanceof ITestDataCubePO) {
                ProblemCont.getInstance().add(((ITestDataCubePO)obj).getId(), check);
                continue;
            }
            ProblemCont.getInstance().add(obj, check);
        }
    }

    public void checkEverything() {
        ProblemCont.getInstance().clear();
        if (this.isEnabled()) {
            for (BaseContext context : CheckCont.getContexts()) {
                for (Object object : context.getAll()) {
                    this.check(object);
                }
            }
        }
        this.refresh();
        this.addTeststyleProblems();
        ProblemPropagator.getInstance().propagate();
    }

    private void addTeststyleProblems() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        TeststyleProblemAdder op = new TeststyleProblemAdder();
        TreeTraverser traverser = new TreeTraverser((INodePO)project, (ITreeNodeOperation)op);
        traverser.traverse(true);
    }

    public void addToListener() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
    }

    public void removeFromListener() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        ded.removeProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
    }

    public void start() {
        ExtensionHelper.initChecks();
        if (this.isEnabled()) {
            this.addToListener();
        }
    }

    public void stop() {
        if (this.isEnabled()) {
            this.removeFromListener();
        }
        ProblemCont.getInstance().clear();
    }

    public void refresh() {
        DecoratorHandler.refresh();
    }

    public boolean isEnabled() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return false;
        }
        return project.getProjectProperties().getCheckConfCont().getEnabled();
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        switch (state) {
            case prop_modified: {
                this.checkEverything();
                break;
            }
            case closed: {
                ProblemCont.getInstance().clear();
                break;
            }
        }
    }
}

