/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.rename;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;

public abstract class AbstractRenameTreeItemHandler
extends AbstractSelectionBasedHandler {
    protected InputDialog createDialog(INodePO node) {
        if (node instanceof ITestSuitePO) {
            return this.createRenameTestSuiteDialog(node);
        }
        if (node instanceof ITestJobPO) {
            return this.createRenameTestJobDialog(node);
        }
        if (node instanceof ITestCasePO) {
            return this.createRenameTestCaseDialog(node);
        }
        if (node instanceof ICategoryPO) {
            return this.createRenameCategoryDialog(node);
        }
        return null;
    }

    private InputDialog createRenameTestJobDialog(final INodePO node) {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        return new InputDialog(this.getActiveShell(), Messages.RenameActionTJTitle, node.getName(), Messages.RenameActionTJMessage, Messages.RenameActionTJLabel, Messages.RenameActionTJError, Messages.RenameActionDoubleTJName, "testJobDialog.gif", Messages.RenameActionTJShell, false){

            @Override
            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return node.getName().equals(newName) || !ProjectPM.doesTestJobExists((Long)project.getId(), (String)newName);
            }
        };
    }

    private InputDialog createRenameCategoryDialog(INodePO node) {
        return new InputDialog(this.getActiveShell(), Messages.RenameActionCatTitle, node.getName(), Messages.RenameActionCatMessage, Messages.RenameActionCatLabel, Messages.RenameActionCatError, Messages.RenameActionDoubleCatName, "category_big.gif", Messages.RenameActionCatShell, false);
    }

    private InputDialog createRenameTestCaseDialog(INodePO node) {
        String name = node.getName();
        if (node instanceof IExecTestCasePO) {
            name = ((IExecTestCasePO)node).getRealName();
        }
        return new InputDialog(this.getActiveShell(), Messages.RenameActionTCTitle, name, Messages.RenameActionTCMessage, Messages.RenameActionTCLabel, Messages.RenameActionTCError, Messages.RenameActionDoubleTCName, "renameTC.gif", Messages.RenameActionTCShell, false);
    }

    private InputDialog createRenameTestSuiteDialog(final INodePO node) {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        return new InputDialog(this.getActiveShell(), Messages.RenameActionTSTitle, node.getName(), Messages.RenameActionTSMessage, Messages.RenameActionTSLabel, Messages.RenameActionTSError, Messages.RenameActionDoubleTSName, "newTestSuiteDialog.gif", Messages.RenameActionTSShell, false){

            @Override
            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return node.getName().equals(newName) || !ProjectPM.doesTestSuiteExists((Long)project.getId(), (String)newName);
            }
        };
    }

    private boolean isRenamingAllowed(INodePO node) {
        block10: {
            block9: {
                if (!(node instanceof ISpecTestCasePO)) break block9;
                ISpecTestCasePO spec = (ISpecTestCasePO)node;
                for (IExecTestCasePO reuse : NodePM.getInternalExecTestCases((String)spec.getGuid(), (long)spec.getParentProjectId())) {
                    INodePO reusedInNode = reuse.getParentNode();
                    for (IEditorReference edit : Plugin.getAllEditors()) {
                        INodePO editNode;
                        block8: {
                            try {
                                if (!edit.isDirty() || !(edit.getEditorInput() instanceof NodeEditorInput)) continue;
                                editNode = ((NodeEditorInput)edit.getEditorInput()).getNode();
                                if (!(reusedInNode instanceof ITestSuitePO) || editNode != reusedInNode) break block8;
                                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_LOCK_OBJ_3, (Object[])new Object[]{node.getName(), reusedInNode.getName(), edit.getPartName()}, null);
                                return false;
                            }
                            catch (PartInitException partInitException) {}
                        }
                        if (editNode != reusedInNode) continue;
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_LOCK_OBJ_2, (Object[])new Object[]{node.getName(), reusedInNode.getName(), edit.getPartName()}, null);
                        return false;
                    }
                }
                break block10;
            }
            if (!(node instanceof IExecTestCasePO)) break block10;
            for (IEditorReference edit : Plugin.getAllEditors()) {
                try {
                    INodePO editNode;
                    if (!edit.isDirty() || !(edit.getEditorInput() instanceof NodeEditorInput) || (editNode = ((NodeEditorInput)edit.getEditorInput()).getNode()) != node.getParentNode()) continue;
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_LOCK_OBJ_3, (Object[])new Object[]{node.getName(), editNode.getName(), edit.getPartName()}, null);
                    return false;
                }
                catch (PartInitException partInitException) {}
            }
        }
        return true;
    }

    protected void dialogPopUp(IStructuredSelection sel) {
        INodePO node = (INodePO)sel.getFirstElement();
        InputDialog dialog = this.createDialog(node);
        if (dialog != null) {
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogRenameContextId");
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                try {
                    if (!this.isRenamingAllowed(node)) {
                        return;
                    }
                    NodePM.renameNode((INodePO)node, (String)dialog.getName());
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleProjectDeletedException();
                }
            }
        }
    }
}

