/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.data.TypeName;
import org.eclipse.jubula.client.ui.rcp.search.query.Operation;
import org.eclipse.osgi.util.NLS;

public class SearchOptions {
    private static final int MAX_RECENT = 12;
    private final String m_searchNameNLS;
    private final TypeName[] m_searchableTypes;
    private final List<String> m_recent;
    private List<TypeName> m_selectedSearchableTypes;
    private String m_searchName;
    private String m_searchString;
    private Operation m_operation = Operation.MATCH_CASE;
    private boolean m_hasNodesToBeSelected;
    private boolean m_isSearchingInTestSuiteBrowser;
    private boolean m_isSearchingInTestCaseBrowser;
    private boolean m_isSearchingInTestCaseBrowsersAll;
    private boolean m_isSearchingInReusedProjects;

    public SearchOptions(String searchNameNLS, TypeName[] searchableTypes) {
        this.m_searchNameNLS = searchNameNLS;
        this.m_searchableTypes = searchableTypes;
        this.m_recent = new ArrayList<String>(12);
    }

    public SearchOptions() {
        this("", new TypeName[0]);
    }

    public SearchOptions(SearchOptions searchData) {
        this.m_searchNameNLS = searchData.m_searchNameNLS;
        this.m_searchableTypes = searchData.m_searchableTypes;
        this.m_selectedSearchableTypes = searchData.m_selectedSearchableTypes;
        this.m_searchName = searchData.m_searchName;
        this.m_searchString = searchData.m_searchString;
        this.m_operation = searchData.m_operation;
        this.m_recent = searchData.m_recent;
        this.m_hasNodesToBeSelected = searchData.m_hasNodesToBeSelected;
        this.m_isSearchingInTestSuiteBrowser = searchData.m_isSearchingInTestSuiteBrowser;
        this.m_isSearchingInTestCaseBrowser = searchData.m_isSearchingInTestCaseBrowser;
        this.m_isSearchingInTestCaseBrowsersAll = searchData.m_isSearchingInTestCaseBrowsersAll;
        this.m_isSearchingInReusedProjects = searchData.m_isSearchingInReusedProjects;
    }

    public void setData(String searchString, boolean caseSensitive, boolean useRegex, boolean hasNodesToBeSelected, boolean isSearchingInTestSuiteBrowser, boolean isSearchingInTestCaseBrowser, boolean isSearchingInTestCaseBrowsersAll, boolean isSearchingInReusedProject) {
        this.m_operation = Operation.create(caseSensitive, useRegex);
        this.m_selectedSearchableTypes = new ArrayList<TypeName>();
        TypeName[] typeNameArray = this.m_searchableTypes;
        int n = this.m_searchableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeName type = typeNameArray[n2];
            if (type.isSelected()) {
                this.m_selectedSearchableTypes.add(type);
            }
            ++n2;
        }
        this.m_hasNodesToBeSelected = hasNodesToBeSelected;
        this.m_isSearchingInTestSuiteBrowser = isSearchingInTestSuiteBrowser;
        this.m_isSearchingInTestCaseBrowser = isSearchingInTestCaseBrowser;
        this.m_isSearchingInTestCaseBrowsersAll = isSearchingInTestCaseBrowsersAll;
        this.m_isSearchingInReusedProjects = isSearchingInReusedProject;
        this.setSearchString(searchString);
    }

    public String getSearchName() {
        return this.m_searchName;
    }

    public Operation getOperation() {
        return this.m_operation;
    }

    private void setSearchString(String searchString) {
        this.m_searchString = searchString;
        String scopeName = Messages.SimpleSearchTaskScopeAll;
        if (this.hasNodesToBeSelected()) {
            scopeName = Messages.SimpleSearchTaskScopeSelectedNodes;
        }
        this.m_searchName = NLS.bind((String)this.m_searchNameNLS, (Object)scopeName, (Object)searchString);
        if (this.m_recent.contains(searchString)) {
            this.m_recent.remove(searchString);
        }
        if (this.m_recent.size() >= 12) {
            this.m_recent.remove(this.getRecent().size() - 1);
        }
        this.m_recent.add(0, searchString);
    }

    public String getSearchString() {
        return this.m_searchString;
    }

    public List<String> getRecent() {
        return this.m_recent;
    }

    public TypeName[] getSearchableTypes() {
        return this.m_searchableTypes;
    }

    public List<TypeName> getSelectedSearchableTypes() {
        return this.m_selectedSearchableTypes;
    }

    public boolean hasNodesToBeSelected() {
        return this.m_hasNodesToBeSelected;
    }

    public boolean isSearchingInTestSuiteBrowser() {
        return this.m_isSearchingInTestSuiteBrowser;
    }

    public boolean isSearchingInTestCaseBrowser() {
        return this.m_isSearchingInTestCaseBrowser;
    }

    public boolean isSearchinInTestCaseBrowsersAll() {
        return this.m_isSearchingInTestCaseBrowsersAll;
    }

    public boolean isSearchingInReusedProjects() {
        return this.m_isSearchingInReusedProjects;
    }
}

