/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutAgentManager {
    private static final Logger LOG = LoggerFactory.getLogger(AutAgentManager.class);
    private static AutAgentManager instance = null;
    private SortedSet<AutAgent> m_autAgents = new TreeSet<AutAgent>();
    private AutAgent m_lastUsedAutAgent = null;

    private AutAgentManager() {
        this.readFromPrefStore();
    }

    public static AutAgentManager getInstance() {
        if (instance == null) {
            instance = new AutAgentManager();
        }
        return instance;
    }

    private void readFromPrefStore() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        String autAgentValue = prefStore.getString("AUT_AGENT_SETTINGS_KEY");
        String lastUsedAutAgentValue = prefStore.getString("LAST_USED_AUT_AGENT_KEY");
        try {
            this.decodeAutAgentPrefs(autAgentValue);
        }
        catch (JBException jbe) {
            LOG.error("Error occurred while loading AUT Agent preferences. Resetting to default values.", (Throwable)jbe);
            prefStore.setToDefault("AUT_AGENT_SETTINGS_KEY");
            try {
                this.decodeAutAgentPrefs(autAgentValue);
            }
            catch (JBException jBException) {
                LOG.error("Error occurred while reading AUT Agent preferences default values.", (Throwable)jbe);
            }
        }
        this.m_lastUsedAutAgent = !StringUtils.isEmpty((String)lastUsedAutAgentValue) ? new AutAgent(lastUsedAutAgentValue.substring(0, lastUsedAutAgentValue.indexOf(":")), new Integer(lastUsedAutAgentValue.substring(lastUsedAutAgentValue.indexOf(":") + 1))) : null;
    }

    private void decodeAutAgentPrefs(String store) throws JBException {
        this.m_autAgents.clear();
        String[] autAgentStrings = StringUtils.split((String)store, (char)';');
        if (autAgentStrings.length % 2 == 0) {
            int i = 0;
            while (i < autAgentStrings.length) {
                String[] encodedPorts;
                String hostname = this.decodeString(autAgentStrings[i]);
                String[] stringArray = encodedPorts = StringUtils.split((String)autAgentStrings[i + 1], (char)',');
                int n = encodedPorts.length;
                int n2 = 0;
                while (n2 < n) {
                    String encodedPort = stringArray[n2];
                    String port = this.decodeString(encodedPort);
                    this.m_autAgents.add(new AutAgent(hostname, Integer.valueOf(port)));
                    ++n2;
                }
                i += 2;
            }
        } else {
            throw new JBException("Number of entries in server list must be even.", Integer.valueOf(0));
        }
    }

    String decodeString(String encodedString) throws JBException {
        if (!Base64.isArrayByteBase64((byte[])encodedString.getBytes())) {
            throw new JBException("", new Integer(0));
        }
        return new String(Base64.decodeBase64((byte[])encodedString.getBytes()));
    }

    public void addServer(AutAgent autAgent) {
        Validate.notNull((Object)autAgent, (String)(String.valueOf(Messages.ServerObjectMustNotBeNull) + "."));
        if (!autAgent.getName().equals("") && !this.m_autAgents.contains(autAgent)) {
            this.m_autAgents.add(autAgent);
        }
    }

    public void removeAutAgent(AutAgent autAgent) {
        if (this.m_lastUsedAutAgent != null && this.m_lastUsedAutAgent.equals(autAgent)) {
            this.m_lastUsedAutAgent = null;
        }
        this.m_autAgents.remove(autAgent);
    }

    public void storeAutAgentList() {
        StringBuilder storage = new StringBuilder();
        for (AutAgent autAgent : this.m_autAgents) {
            byte[] autAgentArray = autAgent.getName().getBytes();
            String autAgentEncoded = new String(Base64.encodeBase64((byte[])autAgentArray));
            storage.append(autAgentEncoded).append(";");
            storage.append(new String(Base64.encodeBase64((byte[])autAgent.getPort().toString().getBytes())));
            storage.append(";");
        }
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        preferenceStore.setValue("AUT_AGENT_SETTINGS_KEY", storage.toString());
        if (this.m_lastUsedAutAgent != null) {
            if (this.m_autAgents.contains(this.m_lastUsedAutAgent)) {
                preferenceStore.setValue("LAST_USED_AUT_AGENT_KEY", this.buildLastUsedAutAgentPortString(this.m_lastUsedAutAgent));
            } else {
                this.m_lastUsedAutAgent = null;
            }
        }
    }

    private String buildLastUsedAutAgentPortString(AutAgent lastUsedAutAgent) {
        if (lastUsedAutAgent != null) {
            return String.valueOf(lastUsedAutAgent.getName()) + ":" + lastUsedAutAgent.getPort();
        }
        Integer port = new Integer(-1);
        return ":" + port;
    }

    public AutAgent getAutAgent(String autAgentName, Integer port) {
        AutAgent serv = null;
        for (AutAgent server : this.m_autAgents) {
            if (!autAgentName.equals(server.getName()) || !server.getPort().equals(port)) continue;
            serv = server;
        }
        return serv;
    }

    public boolean containsAutAgent(String autAgentName) {
        Validate.notNull((Object)autAgentName);
        for (AutAgent autAgent : this.m_autAgents) {
            if (!autAgentName.equals(autAgent.getName())) continue;
            return true;
        }
        return false;
    }

    public SortedSet<String> getAutAgentNames() {
        TreeSet<String> autAgent = new TreeSet<String>();
        for (AutAgent server : this.m_autAgents) {
            if ("".equals(server.getName())) continue;
            autAgent.add(server.getName());
        }
        return autAgent;
    }

    public AutAgent getLastUsedAutAgent() {
        return this.m_lastUsedAutAgent;
    }

    public SortedSet<AutAgent> getAutAgents() {
        return this.m_autAgents;
    }

    public void setAutAgents(SortedSet<AutAgent> autAgents) {
        this.m_autAgents = autAgents;
    }

    public void setLastUsedAutAgent(AutAgent autAgent) {
        this.m_lastUsedAutAgent = autAgent;
    }

    public static class AutAgent
    implements Comparable {
        private String m_name;
        private Integer m_port = new Integer(-1);

        public AutAgent(String name, Integer port) {
            this.m_name = name;
            this.m_port = port;
        }

        public String getName() {
            return this.m_name;
        }

        public Integer getPort() {
            return this.m_port;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setPort(Integer port) {
            this.m_port = port;
        }

        public int compareTo(Object o) {
            AutAgent autAgent = (AutAgent)o;
            if (this.getName().compareTo(autAgent.getName()) == 0) {
                return this.getPort().compareTo(autAgent.getPort());
            }
            return this.getName().compareTo(autAgent.getName());
        }
    }
}

