/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.ConfigurableLogger;
import org.eclipse.jubula.communication.IExceptionHandler;
import org.eclipse.jubula.communication.connection.DefaultClientSocket;
import org.eclipse.jubula.communication.connection.UnexpectedEofException;
import org.eclipse.jubula.communication.listener.IErrorHandler;
import org.eclipse.jubula.communication.listener.IMessageHandler;
import org.eclipse.jubula.communication.message.MessageHeader;
import org.eclipse.jubula.communication.parser.MessageHeaderSerializer;
import org.eclipse.jubula.communication.writer.MessageWriter;
import org.eclipse.jubula.tools.exception.SerialisationException;
import org.slf4j.LoggerFactory;

public class Connection {
    public static final String IO_STREAM_ENCODING = "UTF8";
    private static final long SEQUENCE_START = 1L;
    private ConfigurableLogger m_logger = new ConfigurableLogger(LoggerFactory.getLogger(Connection.class));
    private long m_sequenceNumber;
    private Socket m_socket;
    private BufferedReader m_inputStreamReader;
    private OutputStream m_outputStream;
    private Set m_messageHandlers;
    private Set m_errorHandlers;
    private IExceptionHandler m_exceptionHandler = null;
    private ReaderThread m_readerThread = null;
    private boolean m_shutDownFired;
    private MessageHeaderSerializer m_headerSerializer;

    public Connection(DefaultClientSocket socket) throws IOException, IllegalArgumentException {
        this(socket, socket.getInputStreamReader());
    }

    public Connection(Socket socket, BufferedReader socketInputStreamReader) throws IllegalArgumentException {
        Validate.notNull((Object)socket, (String)"socket must not be null");
        try {
            this.m_socket = socket;
            this.m_outputStream = this.m_socket.getOutputStream();
            this.m_inputStreamReader = socketInputStreamReader;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("socket must be connected");
        }
        this.m_shutDownFired = false;
        this.m_sequenceNumber = 1L;
        this.m_messageHandlers = new HashSet();
        this.m_errorHandlers = new HashSet();
        this.m_headerSerializer = new MessageHeaderSerializer();
    }

    public synchronized String getNextSequenceNumber() {
        if (this.m_sequenceNumber == Long.MAX_VALUE) {
            this.m_sequenceNumber = 1L;
        }
        String result = String.valueOf(this.m_sequenceNumber);
        ++this.m_sequenceNumber;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReading(String id) {
        ReaderThread readerThread = this.m_readerThread;
        if (readerThread == null) {
            readerThread = new ReaderThread("Connection.ReaderThread:" + id);
            readerThread.setDaemon(true);
        }
        ReaderThread readerThread2 = readerThread;
        synchronized (readerThread2) {
            if (!readerThread.isAlive()) {
                readerThread.start();
            }
        }
        this.m_readerThread = readerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_readerThread != null) {
            ReaderThread readerThread = this.m_readerThread;
            synchronized (readerThread) {
                if (this.m_readerThread.isAlive()) {
                    this.m_readerThread.interrupt();
                }
            }
        }
        try {
            this.m_socket.close();
        }
        catch (IOException ioe) {
            this.getLogger().debug("io error closing a socket", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageHandler(IMessageHandler messageHandler) {
        if (messageHandler != null) {
            Set set = this.m_messageHandlers;
            synchronized (set) {
                this.m_messageHandlers.add(messageHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(IMessageHandler messageHandler) {
        if (messageHandler != null) {
            Set set = this.m_messageHandlers;
            synchronized (set) {
                this.m_messageHandlers.remove(messageHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorHandler(IErrorHandler errorHandler) {
        if (errorHandler != null) {
            Set set = this.m_errorHandlers;
            synchronized (set) {
                this.m_errorHandlers.add(errorHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorHandler(IErrorHandler errorHandler) {
        if (errorHandler != null) {
            Set set = this.m_errorHandlers;
            synchronized (set) {
                this.m_errorHandlers.remove(errorHandler);
            }
        }
    }

    public synchronized IExceptionHandler getExceptionHandler() {
        return this.m_exceptionHandler;
    }

    public synchronized void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public InetAddress getAddress() {
        return this.m_socket.getInetAddress();
    }

    public synchronized void send(MessageHeader header, String message) throws IOException, IllegalArgumentException {
        Validate.notNull((Object)header, (String)"Message header must not be null");
        Validate.notNull((Object)message, (String)"Message must not be null");
        try {
            header.setMessageLength(message.length());
            String serializedHeader = this.m_headerSerializer.serialize(header);
            MessageWriter writer = new MessageWriter(new OutputStreamWriter(this.m_outputStream, IO_STREAM_ENCODING));
            writer.write(35);
            writer.write("" + serializedHeader.length());
            writer.newLine();
            writer.write(serializedHeader);
            writer.write(message);
            writer.flush();
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("sent to " + this.m_socket.getRemoteSocketAddress() + " message with header: " + serializedHeader);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("sent message: " + message);
            }
        }
        catch (IOException ioe) {
            this.getLogger().error("send failed", ioe);
            this.fireSendFailed(message, header);
            this.fireShutDown();
            throw ioe;
        }
        catch (SerialisationException se) {
            this.getLogger().error("serialisation of " + header.toString() + "failed", se);
            this.fireSendFailed(message, header);
        }
    }

    private synchronized void fireSendFailed(String message, MessageHeader header) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("firing send failed, message=" + message);
        }
        Iterator iter = ((HashSet)((HashSet)this.m_errorHandlers).clone()).iterator();
        while (iter.hasNext()) {
            try {
                ((IErrorHandler)iter.next()).sendFailed(header, message);
            }
            catch (Throwable t) {
                this.getLogger().error("Exception while calling listener", t);
            }
        }
    }

    private synchronized void fireShutDown() {
        if (!this.m_shutDownFired) {
            this.getLogger().debug("firing shutdown");
            Iterator iter = ((HashSet)((HashSet)this.m_errorHandlers).clone()).iterator();
            while (iter.hasNext()) {
                try {
                    ((IErrorHandler)iter.next()).shutDown();
                }
                catch (Throwable t) {
                    this.getLogger().error("Exception while calling listener", t);
                }
            }
            this.m_shutDownFired = true;
        } else {
            this.getLogger().debug("shutdown already fired");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fireMessageReceived(MessageHeader header, String message) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("firing message received, message=" + message);
        }
        var4_3 = this;
        synchronized (var4_3) {
            iter = ((HashSet)((HashSet)this.m_messageHandlers).clone()).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var4_3
            if (true) ** GOTO lbl17
        }
        do {
            try {
                ((IMessageHandler)iter.next()).received(header, message);
            }
            catch (Throwable t) {
                this.getLogger().error("Exception while calling listener", t);
            }
lbl17:
            // 3 sources

        } while (iter.hasNext());
    }

    public void clearListeners() {
        this.m_errorHandlers.clear();
        this.m_messageHandlers.clear();
    }

    public ConfigurableLogger getLogger() {
        return this.m_logger;
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread(String name) {
            super(name);
        }

        public void run() {
            while (!this.isInterrupted()) {
                String headerLengthToken = null;
                try {
                    if (!this.waitForInput()) {
                        return;
                    }
                    headerLengthToken = Connection.this.m_inputStreamReader.readLine();
                    int headerLength = Integer.parseInt(headerLengthToken);
                    String headerString = this.readString(Connection.this.m_inputStreamReader, headerLength);
                    if (Connection.this.getLogger().isInfoEnabled()) {
                        Connection.this.getLogger().info("read header: " + headerString);
                    }
                    MessageHeader header = Connection.this.m_headerSerializer.deserialize(headerString);
                    header.validateVersion();
                    String message = this.readString(Connection.this.m_inputStreamReader, header.getMessageLength());
                    if (Connection.this.getLogger().isDebugEnabled()) {
                        Connection.this.getLogger().debug("read message: " + message);
                    }
                    Connection.this.fireMessageReceived(header, message);
                }
                catch (IOException ioe) {
                    Connection.this.getLogger().debug("stopping reading either due to io exception or stopped AUT", ioe);
                    this.fireShutDownAndFinish();
                }
                catch (UnexpectedEofException e) {
                    Connection.this.getLogger().error("unexpected end of file while reading message", (Throwable)((Object)e));
                    Connection.this.close();
                    this.fireShutDownAndFinish();
                }
                catch (NumberFormatException e) {
                    Connection.this.getLogger().error("invalid header length token: " + headerLengthToken, e);
                }
                catch (MessageHeader.InvalidHeaderVersionException ihve) {
                    Connection.this.getLogger().error(ihve.getLocalizedMessage(), (Throwable)((Object)ihve));
                }
                catch (Throwable t) {
                    Connection.this.getLogger().error("exception raised", t);
                    IExceptionHandler exceptionHandler = Connection.this.getExceptionHandler();
                    if (exceptionHandler == null || exceptionHandler.handle(t)) continue;
                    Connection.this.close();
                    this.fireShutDownAndFinish();
                }
            }
            Connection.this.fireShutDown();
        }

        private String readString(BufferedReader reader, int length) throws IOException, UnexpectedEofException {
            if (Connection.this.getLogger().isDebugEnabled()) {
                Connection.this.getLogger().debug("readString len " + length);
            }
            char[] headerChars = new char[length];
            int required = length;
            int filled = 0;
            while (required > 0) {
                int nread = reader.read(headerChars, filled, required);
                if (nread == -1) {
                    Connection.this.getLogger().error("received message part before unexpected eof: " + String.valueOf(headerChars));
                    throw new UnexpectedEofException("after reading " + filled + " bytes of expected " + length + " bytes of string");
                }
                filled += nread;
                required -= nread;
            }
            return String.valueOf(headerChars);
        }

        private boolean waitForInput() throws IOException {
            int character = this.nextChar();
            boolean createLogMessage = Connection.this.getLogger().isDebugEnabled();
            StringWriter logMessage = new StringWriter();
            while (!this.isInterrupted() && character != 35) {
                if (character == -1) {
                    this.fireShutDownAndFinish();
                    if (this.isInterrupted()) {
                        return false;
                    }
                }
                character = this.nextChar();
                if (!createLogMessage) continue;
                logMessage.write(character);
            }
            if (createLogMessage) {
                logMessage.flush();
                Connection.this.getLogger().debug("received a portion of a message:" + logMessage.toString());
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int nextChar() throws SocketException, IOException {
            int oldTimeout = Connection.this.m_socket.getSoTimeout();
            Connection.this.m_socket.setSoTimeout(5000);
            boolean loop = false;
            int character = -1;
            try {
                do {
                    try {
                        loop = false;
                        character = Connection.this.m_inputStreamReader.read();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        loop = true;
                    }
                    if (!loop) return character;
                } while (!this.isInterrupted());
                return character;
            }
            finally {
                Connection.this.m_socket.setSoTimeout(oldTimeout);
            }
        }

        private void fireShutDownAndFinish() {
            this.interrupt();
            Connection.this.fireShutDown();
        }
    }
}

