/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.message;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.message.Message;

public class StartAUTServerMessage
extends Message {
    private String m_client;
    private int m_port;
    private long m_eventConfirmTimeOut;
    private Locale m_locale;
    private String m_autToolKit;
    private Map m_autConfiguration = null;
    private boolean m_generateNames;

    public StartAUTServerMessage() {
    }

    public StartAUTServerMessage(String host, int port, Map autConfig, String autToolKit, boolean generateNames) {
        Validate.notEmpty((String)host);
        Validate.isTrue((port > 0 ? 1 : 0) != 0);
        this.setAutConfiguration(autConfig);
        this.setClient(host);
        this.setPort(port);
        this.setAutToolKit(autToolKit);
        this.setGenerateNames(generateNames);
    }

    private void setAutToolKit(String autToolKit) {
        this.m_autToolKit = autToolKit;
    }

    public String getCommandClass() {
        return "org.eclipse.jubula.autagent.commands.StartAUTServerCommand";
    }

    public String getClient() {
        return this.m_client;
    }

    public void setClient(String client) {
        Validate.notEmpty((String)client);
        this.m_client = client;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        Validate.isTrue((port > 0 ? 1 : 0) != 0);
        this.m_port = port;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public long getEventConfirmTimeOut() {
        return this.m_eventConfirmTimeOut;
    }

    public void setEventConfirmTimeOut(long eventConfirmTimeOut) {
        this.m_eventConfirmTimeOut = eventConfirmTimeOut;
    }

    public String getAutToolKit() {
        return this.m_autToolKit;
    }

    public Map getAutConfiguration() {
        return this.m_autConfiguration;
    }

    public void setAutConfiguration(Map autConfiguration) {
        this.m_autConfiguration = autConfiguration;
    }

    public void setGenerateNames(boolean generateNames) {
        this.m_generateNames = generateNames;
    }

    public boolean isGenerateNames() {
        return this.m_generateNames;
    }
}

