/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.components;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jubula.rc.common.components.AUTComponent;

public abstract class HierarchyContainer {
    private boolean m_nameGenerated;
    private HierarchyContainer m_parent;
    private AUTComponent m_component;
    private List m_containerList = new ArrayList();
    private List m_listenerList = new ArrayList();
    private String m_name;

    public HierarchyContainer(AUTComponent component, HierarchyContainer parent) {
        this.m_component = component;
        this.m_parent = parent;
    }

    public HierarchyContainer(AUTComponent component) {
        this(component, null);
        this.m_parent = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HierarchyContainer)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HierarchyContainer o = (HierarchyContainer)obj;
        return this.m_component.equals(o.m_component);
    }

    public int hashCode() {
        return this.m_component.hashCode();
    }

    protected AUTComponent getCompID() {
        return this.m_component;
    }

    public void add(HierarchyContainer component) {
        this.getContainerList().add(component);
    }

    public void remove(HierarchyContainer component) {
        this.getContainerList().remove(component);
    }

    protected HierarchyContainer[] getComps() {
        if (this.getContainerList().isEmpty()) {
            return new HierarchyContainer[0];
        }
        Object[] objectArray = this.getContainerList().toArray();
        HierarchyContainer[] containerArray = new HierarchyContainer[objectArray.length];
        int i = 0;
        while (i < objectArray.length) {
            containerArray[i] = (HierarchyContainer)objectArray[i];
            ++i;
        }
        return containerArray;
    }

    protected AUTComponent getComp(int index) {
        return (AUTComponent)this.getContainerList().get(index);
    }

    protected void addContainerListnr(EventListener listener) {
        this.m_listenerList.add(listener);
    }

    protected void removeContainerListener(EventListener listener) {
        this.m_listenerList.remove(listener);
    }

    protected EventListener[] getListnrs() {
        if (this.m_listenerList.isEmpty()) {
            return new EventListener[0];
        }
        return this.m_listenerList.toArray(new EventListener[this.m_listenerList.size()]);
    }

    public String getName() {
        return this.m_name;
    }

    public final void setName(String name, boolean nameGenerated) {
        this.m_name = name;
        this.m_nameGenerated = nameGenerated;
    }

    public final boolean isNameGenerated() {
        return this.m_nameGenerated;
    }

    public HierarchyContainer getPrnt() {
        return this.m_parent;
    }

    public void setPrnt(HierarchyContainer parent) {
        this.m_parent = parent;
    }

    protected List getContainerList() {
        return this.m_containerList;
    }
}

