/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RunnableWrapper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.swt.widgets.Display;

public class EventThreadQueuerSwtImpl
implements IEventThreadQueuer {
    private static AutServerLogger log = new AutServerLogger(EventThreadQueuerSwtImpl.class);

    public Object invokeAndWait(String name, IRunnable runnable) throws IllegalArgumentException, StepExecutionException {
        Display display;
        RunnableWrapper wrapper;
        block6: {
            Validate.notNull((Object)runnable, (String)"runnable must not be null");
            wrapper = new RunnableWrapper(name, runnable);
            try {
                display = this.getDisplay();
                if (!display.isDisposed()) break block6;
                log.warn((Object)"Display has already been disposed - skipping IRunnable invocation!");
                return null;
            }
            catch (InvocationTargetException ite) {
                Throwable thrown = ite.getTargetException();
                if (thrown instanceof StepExecutionException) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)ite);
                    }
                    throw (StepExecutionException)thrown;
                }
                log.error((Object)("exception thrown by '" + wrapper.getName() + "':"), thrown);
                throw new StepExecutionException(thrown);
            }
        }
        display.syncExec((Runnable)wrapper);
        StepExecutionException exception = wrapper.getException();
        if (exception != null) {
            throw new InvocationTargetException((Throwable)exception);
        }
        return wrapper.getResult();
    }

    public void invokeLater(String name, Runnable runnable) throws StepExecutionException {
        Validate.notNull((Object)runnable, (String)"runnable must not be null");
        this.getDisplay().asyncExec(runnable);
    }

    private Display getDisplay() {
        return ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
    }
}

