/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IWidgetComponent;
import org.eclipse.jubula.rc.swt.tester.adapter.WidgetAdapter;
import org.eclipse.jubula.rc.swt.tester.util.EventListener;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public class ControlAdapter
extends WidgetAdapter
implements IWidgetComponent {
    private Control m_component;

    public ControlAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_component = (Control)objectToAdapt;
    }

    public Object getRealComponent() {
        return this.m_component;
    }

    public String getPropteryValue(final String propertyname) {
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", new IRunnable(){

            public Object run() throws StepExecutionException {
                try {
                    return ControlAdapter.this.getRobot().getPropertyValue(ControlAdapter.this.getRealComponent(), propertyname);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    public boolean isShowing() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isShowing", new IRunnable(){

            public Object run() {
                return ControlAdapter.this.m_component.isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public boolean isEnabled() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", new IRunnable(){

            public Object run() {
                return ControlAdapter.this.m_component.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public boolean hasFocus() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("hasFocus", new IRunnable(){

            public Object run() {
                return ControlAdapter.this.m_component.isFocusControl() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    protected static class PopupShownCondition
    implements EventListener.Condition {
        private Menu m_popup = null;

        protected PopupShownCondition() {
        }

        public Menu getPopup() {
            return this.m_popup;
        }

        public boolean isTrue(Event event) {
            if (event.type == 22 && event.widget instanceof Menu) {
                this.m_popup = (Menu)event.widget;
                return true;
            }
            return false;
        }
    }
}

