/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jwt.transformations.properties.PropertyProcessor;
import org.eclipse.jwt.transformations.properties.PropertyProcessorFactory;
import org.eclipse.jwt.transformations.properties.SimplePropertyProcess;
import org.eclipse.jwt.transformations.properties.extension.EMFBasedMultiExtensionHelper;
import org.eclipse.jwt.transformations.properties.extension.FeatureFullDescription;
import org.eclipse.jwt.transformations.properties.extension.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyProcessorsExtensionPoint {
    private static EMFBasedMultiExtensionHelper<PropertyProcessorFactory> extensionPoint;
    public static final String EXTENSION_POINT = "org.eclipse.jwt.transformations.properties.customProperties";
    private static final String PROPERTY_PROCESSOR = "PropertyProcessorFactory";

    PropertyProcessorsExtensionPoint() {
    }

    public static List<PropertyProcessor> getPropertyProcessors(EObject app, EStructuralFeature feature) {
        PropertyProcessorsExtensionPoint.init();
        FeatureFullDescription currentFeature = new FeatureFullDescription(feature.getName(), app.eClass().getName(), app.eClass().getEPackage().getNsURI());
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        for (PropertyProcessorFactory factory : extensionPoint.getObject(currentFeature)) {
            processors.add(factory.createPropertyProcessor(app, feature));
        }
        if (processors.size() == 0) {
            processors.add(new SimplePropertyProcess(app, feature));
        }
        return processors;
    }

    private static void init() {
        extensionPoint = new EMFBasedMultiExtensionHelper<PropertyProcessorFactory>(EXTENSION_POINT, new PropertyProcessorFactoryProxyFactory());
    }

    private static class PropertyProcessorFactoryProxy
    implements PropertyProcessorFactory {
        private PropertyProcessorFactory delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        public PropertyProcessorFactoryProxy(IConfigurationElement element) {
            this.element = element;
        }

        private final PropertyProcessorFactory getDelegate() {
            if (this.invoked) {
                return this.delegate;
            }
            this.invoked = true;
            try {
                Object callback = this.element.createExecutableExtension(PropertyProcessorsExtensionPoint.PROPERTY_PROCESSOR);
                if (!(callback instanceof PropertyProcessorFactory)) {
                    throw new ClassCastException("Class [" + callback.getClass().getName() + "] is not an instance of PropertyDescriptorFactory");
                }
                this.delegate = (PropertyProcessorFactory)callback;
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
            return this.delegate;
        }

        public PropertyProcessor createPropertyProcessor(EObject app, EStructuralFeature feature) {
            return this.getDelegate().createPropertyProcessor(app, feature);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyProcessorFactoryProxyFactory
    implements ProxyFactory<PropertyProcessorFactory> {
        @Override
        public PropertyProcessorFactory createProxy(IConfigurationElement member) {
            return new PropertyProcessorFactoryProxy(member);
        }
    }
}

