/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.internal.rpm.core.utils.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class RPMBuild {
    private List<String> macroDefines = new ArrayList<String>();
    private String rpmBuildCmd;
    private String mainFolder;

    public RPMBuild(IProjectConfiguration config) {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        if (config.getBuildFolder().getLocation() == null) {
            this.mainFolder = config.getSourcesFolder().getLocationURI().toString();
        }
        this.rpmBuildCmd = node.get("RPMBUILD_CMD", "");
        String[] tmpMacroDefines = new String[]{this.rpmBuildCmd, "-v"};
        this.macroDefines.addAll(Arrays.asList(tmpMacroDefines));
        this.macroDefines.addAll(config.getConfigDefines());
    }

    public IStatus buildPrep(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bp");
    }

    public IStatus buildBinary(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bb");
    }

    public IStatus buildAll(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-ba");
    }

    public IStatus buildSource(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bs");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus build(IResource specFile, OutputStream outStream, String buildParameter) throws CoreException {
        if (specFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", Messages.Specfile_not_found));
        }
        ArrayList<String> command = new ArrayList<String>();
        IRemoteCommandLauncher rmtCmdLauncher = null;
        command.addAll(this.macroDefines);
        command.add(buildParameter);
        if (specFile.getLocation() == null) {
            command.remove(0);
            RemoteProxyManager rmtProxyMgr = RemoteProxyManager.getInstance();
            try {
                rmtCmdLauncher = rmtProxyMgr.getLauncher(new URI(this.mainFolder));
            }
            catch (URISyntaxException e1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e1.getMessage(), (Throwable)e1));
            }
            command.add(specFile.getLocationURI().getPath());
            String[] empty = new String[]{};
            Process pProxy = rmtCmdLauncher.execute(Path.fromOSString((String)this.rpmBuildCmd), command.toArray(new String[command.size()]), empty, null, (IProgressMonitor)new NullProgressMonitor());
            MessageConsole console = new MessageConsole("rpmbuild", null);
            console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            MessageConsoleStream stream = console.newMessageStream();
            if (pProxy == null) return Status.OK_STATUS;
            try {
                Throwable throwable = null;
                Object var12_16 = null;
                try {
                    BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));
                    try {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(pProxy.getInputStream()));){
                            String err = error.readLine();
                            while (err != null) {
                                stream.println(err);
                                err = error.readLine();
                            }
                            String readLine = reader.readLine();
                            while (readLine != null) {
                                stream.println(readLine);
                                readLine = reader.readLine();
                            }
                            reader.close();
                        }
                        if (error == null) return Status.OK_STATUS;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (error == null) throw throwable;
                        error.close();
                        throw throwable;
                    }
                    error.close();
                    return Status.OK_STATUS;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
            }
        }
        command.add(specFile.getLocation().toString());
        try {
            return Utils.runCommand(outStream, specFile.getProject(), command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }
}

