/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.form;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoUtils;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.linuxtools.internal.rpm.createrepo.dnd.ImportRPMDropListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.menus.IMenuService;

public class ImportRPMsPage
extends FormPage
implements IResourceChangeListener {
    private CreaterepoProject project;
    private Tree tree;
    private static final String MENU_URI = "toolbar:formsToolbar";
    private static final String HEADER_ICON = "/icons/repository_rep.gif";

    public ImportRPMsPage(FormEditor editor, CreaterepoProject project) {
        super(editor, Messages.ImportRPMsPage_title, Messages.ImportRPMsPage_title);
        this.project = project;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        GridLayout layout = new GridLayout();
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(Messages.ImportRPMsPage_formHeaderText);
        form.setImage(Activator.getImageDescriptor(HEADER_ICON).createImage());
        ToolBarManager toolbarManager = (ToolBarManager)form.getToolBarManager();
        toolkit.decorateFormHeading(form.getForm());
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)toolbarManager, MENU_URI);
        toolbarManager.update(true);
        layout = new GridLayout(2, true);
        layout.marginWidth = 6;
        layout.marginHeight = 12;
        form.getBody().setLayout((Layout)layout);
        Section rpmSection = toolkit.createSection(form.getBody(), 384);
        layout = new GridLayout();
        rpmSection.setText(Messages.ImportRPMsPage_sectionTitle);
        rpmSection.setDescription(Messages.ImportRPMsPage_sectionInstruction);
        rpmSection.setLayoutData((Object)ImportRPMsPage.expandComposite());
        Composite sectionClient = toolkit.createComposite((Composite)rpmSection);
        layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        layout.marginHeight = 7;
        sectionClient.setLayout((Layout)layout);
        TreeViewer viewer = new TreeViewer(sectionClient, 33622786);
        viewer.addDropSupport(1, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new ImportRPMDropListener((Viewer)viewer, this.project));
        this.tree = viewer.getTree();
        this.tree.setLayoutData((Object)ImportRPMsPage.expandComposite());
        Composite buttonList = toolkit.createComposite(sectionClient);
        layout = new GridLayout();
        GridData data = new GridData(1, 4, false, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonList.setLayout((Layout)layout);
        buttonList.setLayoutData((Object)data);
        ImportRPMsPage.createPushButton(buttonList, Messages.ImportRPMsPage_buttonImportRPMs, toolkit).addSelectionListener((SelectionListener)new ImportButtonListener());
        ImportRPMsPage.createPushButton(buttonList, Messages.ImportRPMsPage_buttonRemoveRPMs, toolkit).addSelectionListener((SelectionListener)new RemoveButtonListener());
        new Label(buttonList, 0).setLayoutData((Object)new GridData(0, 0));
        ImportRPMsPage.createPushButton(buttonList, Messages.ImportRPMsPage_buttonCreateRepo, toolkit).addSelectionListener((SelectionListener)new CreaterepoButtonListener());
        this.refreshTree();
        rpmSection.setClient((Control)sectionClient);
        managedForm.refresh();
    }

    private static GridData expandComposite() {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    private static Button createPushButton(Composite parent, String buttonText, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, buttonText, 0x3800008);
        button.setFont(parent.getFont());
        GridData gd = new GridData(4, 1, true, false);
        button.setLayoutData((Object)gd);
        return button;
    }

    private void refreshTree() {
        this.tree.removeAll();
        try {
            for (IResource rpm : this.project.getRPMs()) {
                this.addItemToTree(rpm.getName());
            }
        }
        catch (CoreException e) {
            Activator.logError(Messages.ImportRPMsPage_errorRefreshingTree, e);
        }
        this.tree.setFocus();
    }

    private boolean addItemToTree(String itemName) {
        boolean exists = false;
        if (itemName == null || itemName.isEmpty()) {
            return false;
        }
        if (this.tree.getItemCount() > 0) {
            TreeItem[] treeItemArray = this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getText().equals(itemName)) {
                    exists = true;
                }
                ++n2;
            }
        }
        if (!exists || this.tree.getItemCount() == 0) {
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setText(itemName);
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    IPath projectPath = this.project.getContentFolder().getFullPath();
                    IResourceDelta delta = event.getDelta().findMember(projectPath);
                    if (delta == null) break;
                    delta.accept((IResourceDeltaVisitor)new CreaterepoDeltaVisitor());
                    break;
                }
                catch (CoreException e) {
                    Activator.logError(Messages.ImportRPMsPage_errorResourceChanged, e);
                }
            }
        }
    }

    public class CreaterepoButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            Job executeCreaterepo = new Job(Messages.Createrepo_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(Messages.CreaterepoProject_executeCreaterepo, -1);
                        MessageConsoleStream os = CreaterepoUtils.findConsole(Messages.CreaterepoProject_consoleName).newMessageStream();
                        IStatus iStatus = ImportRPMsPage.this.project.createrepo((OutputStream)os);
                        return iStatus;
                    }
                    catch (CoreException e) {
                        Activator.logError(Messages.Createrepo_errorExecuting, e);
                    }
                    finally {
                        monitor.done();
                    }
                    return null;
                }
            };
            executeCreaterepo.setUser(true);
            executeCreaterepo.schedule();
        }
    }

    class CreaterepoDeltaVisitor
    implements IResourceDeltaVisitor {
        CreaterepoDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getKind() == 2 || (delta.getFlags() | delta.getKind()) == 16388) {
                return false;
            }
            IResourceDelta[] removedFiles = delta.getAffectedChildren(2);
            IResourceDelta[] addedFiles = delta.getAffectedChildren(1);
            if (removedFiles.length <= 0 && addedFiles.length == 0) {
                return false;
            }
            boolean rpmsDeleted = false;
            IResourceDelta[] iResourceDeltaArray = removedFiles;
            int n = removedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                String extension = resourceDelta.getResource().getFileExtension();
                if (extension != null && extension.equals("rpm")) {
                    rpmsDeleted = true;
                    break;
                }
                ++n2;
            }
            boolean rpmsAdded = false;
            IResourceDelta[] iResourceDeltaArray2 = addedFiles;
            int n3 = addedFiles.length;
            n = 0;
            while (n < n3) {
                IResourceDelta resourceDelta = iResourceDeltaArray2[n];
                String extension = resourceDelta.getResource().getFileExtension();
                if (extension != null && extension.equals("rpm")) {
                    rpmsAdded = true;
                    break;
                }
                ++n;
            }
            if (!rpmsDeleted && !rpmsAdded) {
                return false;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImportRPMsPage.this.refreshTree();
                }
            });
            return false;
        }
    }

    public class ImportButtonListener
    extends SelectionAdapter {
        private final String[] EXTENSION_FILTERS = new String[]{"*.rpm"};

        public void widgetSelected(SelectionEvent e) {
            String[] files;
            IWorkbench workbench = PlatformUI.getWorkbench();
            Shell shell = workbench.getModalDialogShellProvider().getShell();
            FileDialog fileDialog = new FileDialog(shell, 2);
            fileDialog.setFilterExtensions(this.EXTENSION_FILTERS);
            if (fileDialog.open() != null && (files = fileDialog.getFileNames()).length > 0) {
                String directoryPath = fileDialog.getFilterPath();
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    File externalFile = new File(directoryPath, file);
                    try {
                        ImportRPMsPage.this.project.importRPM(externalFile);
                    }
                    catch (CoreException e1) {
                        Activator.logError(Messages.ImportButtonListener_error, e1);
                    }
                    ++n2;
                }
                ImportRPMsPage.this.refreshTree();
            }
        }
    }

    public class RemoveButtonListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            TreeItem[] selection = ImportRPMsPage.this.tree.getSelection();
            try {
                List<IResource> rpms = ImportRPMsPage.this.project.getRPMs();
                if (selection.length > 0 && !rpms.isEmpty()) {
                    for (IResource resource : rpms) {
                        TreeItem[] treeItemArray = selection;
                        int n = selection.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem treeItem = treeItemArray[n2];
                            this.deleteIfEquals(resource, treeItem);
                            ++n2;
                        }
                    }
                }
                ImportRPMsPage.this.refreshTree();
            }
            catch (CoreException e1) {
                Activator.logError(Messages.RemoveButtonListener_error, e1);
            }
        }

        private void deleteIfEquals(IResource resource, TreeItem treeItem) throws CoreException {
            if (resource.getName().equals(treeItem.getText())) {
                resource.delete(false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

